/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.PingOneForEnterpriseSettings;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.pingone.PingOneAdminServiceSettings;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.SpConnectionFactory;

public class PingOneForEnterpriseSettingsTranslator {
    public PingOneForEnterpriseSettings domainToApi(PingOneAdminServiceSettings pingOneAdminServiceSettings) {
        PingOneAdminService pingOneAdminService = MgmtFactory.getPingOneAdminService();
        PingOneForEnterpriseSettings settings = new PingOneForEnterpriseSettings();
        settings.setConnectedToPingOneForEnterprise(pingOneAdminService.isAssociated());
        if (pingOneAdminService.isAssociated()) {
            SpConnection spConn;
            SpConnectionFactory connFactory;
            String companyName = pingOneAdminService.getMetadata().getPingOneCompanyName();
            if (StringUtils.isNotBlank((String)companyName)) {
                settings.setCompanyName(companyName);
            }
            if ((connFactory = pingOneAdminService.getSpConnectionFactory()).hasManagedSpConnection()) {
                ResourceLink resourceLink = new ResourceLink();
                String connId = connFactory.getManagedSpConnection().getId();
                resourceLink.setId(connId);
                resourceLink.setLocation(ApiUtil.getResourceUrl("/idp/spConnections", connId));
                settings.setPingOneSsoConnection(resourceLink);
            }
            settings.setEnableAdminConsoleSso(pingOneAdminServiceSettings.isEnableAdminConsoleSso());
            settings.setEnableMonitoring(pingOneAdminServiceSettings.isEnableMonitoring());
            PkCert currentKey = pingOneAdminService.getClientAuthnKeyPair();
            PkCert previousKey = pingOneAdminService.getPreviousClientAuthnKeyPair();
            if (currentKey != null) {
                settings.setCurrentAuthnKeyCreationTime(currentKey.getX509Certificate().getNotBefore());
            }
            if (previousKey != null) {
                settings.setPreviousAuthnKeyCreationTime(previousKey.getX509Certificate().getNotBefore());
            }
            if ((spConn = pingOneAdminService.getSpConnectionFactory().getManagedSpConnection()) != null && spConn.isActive() && pingOneAdminService.getSpConnectionFactory().isMetadataUploadPending()) {
                settings.setIdentityRepositoryUpdateRequired(true);
            } else {
                settings.setIdentityRepositoryUpdateRequired(false);
            }
        } else {
            settings.setEnableAdminConsoleSso(false);
            settings.setEnableMonitoring(false);
            settings.setIdentityRepositoryUpdateRequired(false);
        }
        return settings;
    }

    public PingOneAdminServiceSettings apiToDomain(PingOneForEnterpriseSettings apiSettings) {
        PingOneAdminService pingOneAdminService = MgmtFactory.getPingOneAdminService();
        PingOneAdminServiceSettings domainSettings = pingOneAdminService.getSettings();
        domainSettings.setEnableAdminConsoleSso(apiSettings.getEnableAdminConsoleSso());
        domainSettings.setEnableMonitoring(apiSettings.getEnableMonitoring());
        return domainSettings;
    }
}

