/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AlternativeLoginHintTokenIssuer;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.IdentityHintAttribute;
import com.pingidentity.admin.api.model.IdentityHintContract;
import com.pingidentity.admin.api.model.RequestPolicy;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.pf.admin.rest.translator.AlternativeLoginHintTokenIssuerTranslator;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.saml20.domain.OOBAuthPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class RequestPolicyTranslator {
    private final AlternativeLoginHintTokenIssuerTranslator alternativeLoginHintTokenIssuerTranslator = new AlternativeLoginHintTokenIssuerTranslator();
    private final AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();

    public RequestPolicy domainToApi(CibaServerPolicy.RequestHandlingPolicy domainRequestHandlingPolicy) {
        RequestPolicy apiRequestHandlingPolicy = new RequestPolicy();
        apiRequestHandlingPolicy.setId(domainRequestHandlingPolicy.getId());
        apiRequestHandlingPolicy.setName(domainRequestHandlingPolicy.getName());
        ResourceLink oobAuthenticatorResourceLink = new ResourceLink();
        oobAuthenticatorResourceLink.setId(domainRequestHandlingPolicy.getPluginId());
        oobAuthenticatorResourceLink.setLocation(ApiUtil.getResourceUrl("/oauth/outOfBandAuthPlugins", domainRequestHandlingPolicy.getPluginId()));
        apiRequestHandlingPolicy.setAuthenticatorRef(oobAuthenticatorResourceLink);
        if (StringUtils.isNotBlank((String)domainRequestHandlingPolicy.getUserCodePcvId())) {
            ResourceLink pcvResourceLink = new ResourceLink();
            pcvResourceLink.setId(domainRequestHandlingPolicy.getUserCodePcvId());
            pcvResourceLink.setLocation(ApiUtil.getResourceUrl("/passwordCredentialValidators", domainRequestHandlingPolicy.getUserCodePcvId()));
            apiRequestHandlingPolicy.setUserCodePcvRef(pcvResourceLink);
        }
        apiRequestHandlingPolicy.setAllowUnsignedLoginHintToken(domainRequestHandlingPolicy.isAllowUnsignedLoginHintToken());
        apiRequestHandlingPolicy.setRequireTokenForIdentityHint(domainRequestHandlingPolicy.isRequireTokenForHint());
        apiRequestHandlingPolicy.setTransactionLifetime(domainRequestHandlingPolicy.getTransactionLifeInSeconds());
        for (CibaServerPolicy.RequestHandlingPolicy.AlternativeLoginHintTokenIssuer domainAltTokenIssuer : domainRequestHandlingPolicy.getAlternativeLoginHintTokenIssuers()) {
            apiRequestHandlingPolicy.getAlternativeLoginHintTokenIssuers().add(this.alternativeLoginHintTokenIssuerTranslator.domainToApi(domainAltTokenIssuer));
        }
        IdentityHintAttribute apiCoreAttribute = new IdentityHintAttribute("IDENTITY_HINT_SUBJECT");
        IdentityHintContract apiRequestHintContract = new IdentityHintContract();
        apiRequestHintContract.getCoreAttributes().add(apiCoreAttribute);
        List<IdentityHintAttribute> apiRequestHintAttributes = domainRequestHandlingPolicy.getRequestHintAttributeContract().stream().map(domainExtendedAttribute -> {
            IdentityHintAttribute apiExtendedAttribute = new IdentityHintAttribute((String)domainExtendedAttribute);
            return apiExtendedAttribute;
        }).collect(Collectors.toList());
        apiRequestHintContract.setExtendedAttributes(apiRequestHintAttributes);
        apiRequestHandlingPolicy.setIdentityHintContract(apiRequestHintContract);
        if (domainRequestHandlingPolicy.getEnhanceRequestHintContractMapping() != null) {
            AttributeMapping apiEnhanceRequestHintContractMapping = new AttributeMapping();
            this.attributeMappingTranslator.domainToApi(domainRequestHandlingPolicy.getEnhanceRequestHintContractMapping(), apiEnhanceRequestHintContractMapping);
            apiRequestHandlingPolicy.setIdentityHintContractFulfillment(apiEnhanceRequestHintContractMapping);
        }
        AttributeMapping apiHintContractToOOBAuthPluginMapping = new AttributeMapping();
        OOBAuthPluginInstance plugin = (OOBAuthPluginInstance)MgmtFactory.getOOBAuthPluginManager().getInstance(domainRequestHandlingPolicy.getPluginId());
        Set<String> validAttributeContract = this.generateValidContract(apiRequestHandlingPolicy, plugin);
        this.attributeMappingTranslator.domainToApi(domainRequestHandlingPolicy.getHintContractToOOBAuthPluginMapping(), apiHintContractToOOBAuthPluginMapping, validAttributeContract, false);
        apiRequestHandlingPolicy.setIdentityHintMapping(apiHintContractToOOBAuthPluginMapping);
        if (domainRequestHandlingPolicy.getLastModified() != null) {
            apiRequestHandlingPolicy.setLastModified(domainRequestHandlingPolicy.getLastModified().getTime());
        }
        return apiRequestHandlingPolicy;
    }

    private Set<String> generateValidContract(RequestPolicy apiRequestHandlingPolicy, OOBAuthPluginInstance plugin) {
        HashSet<String> validAttributeContract;
        Set set = validAttributeContract = MgmtFactory.getAuthzServerManager().getKeyNameContract() == null ? new HashSet() : MgmtFactory.getAuthzServerManager().getKeyNameContract().getAllAttributeNames();
        if (plugin != null && plugin.getAttributeContract() != null && !plugin.getAttributeContract().isEmpty()) {
            validAttributeContract.addAll(plugin.getAttributeContract().getAllAttributeNames());
        }
        if (apiRequestHandlingPolicy.getUserCodePcvRef() != null) {
            validAttributeContract.add("USER_CODE_USER_NAME");
        }
        return validAttributeContract;
    }

    public CibaServerPolicy.RequestHandlingPolicy apiToDomain(RequestPolicy apiRequestHandlingPolicy) {
        org.sourceid.saml20.domain.AttributeMapping domainAttributeMapping;
        CibaServerPolicy.RequestHandlingPolicy domainRequestHandlingPolicy = new CibaServerPolicy.RequestHandlingPolicy();
        domainRequestHandlingPolicy.setId(apiRequestHandlingPolicy.getId());
        domainRequestHandlingPolicy.setName(apiRequestHandlingPolicy.getName());
        domainRequestHandlingPolicy.setPluginId(apiRequestHandlingPolicy.getAuthenticatorRef().getId());
        if (apiRequestHandlingPolicy.getUserCodePcvRef() != null) {
            domainRequestHandlingPolicy.setUserCodePcvId(apiRequestHandlingPolicy.getUserCodePcvRef().getId());
        }
        domainRequestHandlingPolicy.setTransactionLifeInSeconds(apiRequestHandlingPolicy.getTransactionLifetime());
        domainRequestHandlingPolicy.setRequireTokenForHint(apiRequestHandlingPolicy.isRequireTokenForIdentityHint());
        domainRequestHandlingPolicy.setAllowUnsignedLoginHintToken(apiRequestHandlingPolicy.isAllowUnsignedLoginHintToken());
        for (AlternativeLoginHintTokenIssuer apiAlternativeLoginHintTokenIssuer : apiRequestHandlingPolicy.getAlternativeLoginHintTokenIssuers()) {
            domainRequestHandlingPolicy.getAlternativeLoginHintTokenIssuers().add(this.alternativeLoginHintTokenIssuerTranslator.apiToDomain(apiAlternativeLoginHintTokenIssuer));
        }
        domainRequestHandlingPolicy.setRequestHintAttributeContract(new ArrayList());
        if (apiRequestHandlingPolicy.getIdentityHintContract() != null && apiRequestHandlingPolicy.getIdentityHintContract().getExtendedAttributes() != null) {
            List domainExtendedAttributes = apiRequestHandlingPolicy.getIdentityHintContract().getExtendedAttributes().stream().map(apiExtAttribute -> apiExtAttribute.getName()).collect(Collectors.toList());
            domainRequestHandlingPolicy.getRequestHintAttributeContract().addAll(domainExtendedAttributes);
        }
        if (apiRequestHandlingPolicy.getIdentityHintContractFulfillment() != null) {
            domainAttributeMapping = new org.sourceid.saml20.domain.AttributeMapping();
            this.attributeMappingTranslator.apiToDomain(apiRequestHandlingPolicy.getIdentityHintContractFulfillment(), domainAttributeMapping);
            domainRequestHandlingPolicy.setEnhanceRequestHintContractMapping(domainAttributeMapping);
        } else {
            domainAttributeMapping = new org.sourceid.saml20.domain.AttributeMapping();
            domainRequestHandlingPolicy.setEnhanceRequestHintContractMapping(domainAttributeMapping);
        }
        org.sourceid.saml20.domain.AttributeMapping domainHintContractToOOBAuthPluginMapping = new org.sourceid.saml20.domain.AttributeMapping();
        this.attributeMappingTranslator.apiToDomain(apiRequestHandlingPolicy.getIdentityHintMapping(), domainHintContractToOOBAuthPluginMapping);
        domainRequestHandlingPolicy.setHintContractToOOBAuthPluginMapping(domainHintContractToOOBAuthPluginMapping);
        return domainRequestHandlingPolicy;
    }
}

