/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.SaasFieldConfiguration;
import com.pingidentity.admin.api.model.SaasFieldParsing;
import com.pingidentity.admin.api.model.plugin.CharacterCase;
import com.pingidentity.provisioner.mapping.FieldConfig;
import java.util.HashSet;

class SaasFieldConfigurationTranslator {
    SaasFieldConfigurationTranslator() {
    }

    SaasFieldConfiguration domainToApi(FieldConfig domainFieldConfig) {
        SaasFieldConfiguration fieldConfiguration = new SaasFieldConfiguration();
        fieldConfiguration.setAttributeNames(new HashSet<String>(domainFieldConfig.getAttributeNames()));
        fieldConfiguration.setCreateOnly(domainFieldConfig.isCreateOnly());
        fieldConfiguration.setDefaultValue(domainFieldConfig.getDefault());
        fieldConfiguration.setExpression(domainFieldConfig.getScript());
        fieldConfiguration.setParser(this.getParsing(domainFieldConfig));
        fieldConfiguration.setMasked(domainFieldConfig.isMasked());
        fieldConfiguration.setCharacterCase(this.getDomainCase(domainFieldConfig));
        fieldConfiguration.setTrim(domainFieldConfig.isTrim());
        return fieldConfiguration;
    }

    void apiToDomain(SaasFieldConfiguration apiFieldConfig, FieldConfig domainFieldConfig) {
        domainFieldConfig.addAttributeNames(apiFieldConfig.getAttributeNames());
        domainFieldConfig.setCreateOnly(apiFieldConfig.isCreateOnly());
        domainFieldConfig.setDefault(apiFieldConfig.getDefaultValue());
        domainFieldConfig.setScript(apiFieldConfig.getExpression());
        this.apiToDomainParser(apiFieldConfig, domainFieldConfig);
        domainFieldConfig.setMasked(apiFieldConfig.isMasked());
        domainFieldConfig.setTrim(apiFieldConfig.isTrim());
        this.apiToDomainCharCase(apiFieldConfig, domainFieldConfig);
    }

    private CharacterCase getDomainCase(FieldConfig domainFieldConfig) {
        if (domainFieldConfig.isToUpper()) {
            return CharacterCase.UPPER;
        }
        if (domainFieldConfig.isToLower()) {
            return CharacterCase.LOWER;
        }
        return CharacterCase.NONE;
    }

    private void apiToDomainCharCase(SaasFieldConfiguration apiFieldConfig, FieldConfig domainFieldConfig) {
        if (CharacterCase.UPPER == apiFieldConfig.getCharacterCase()) {
            domainFieldConfig.setToUpper(true);
        }
        if (CharacterCase.LOWER == apiFieldConfig.getCharacterCase()) {
            domainFieldConfig.setToLower(true);
        }
    }

    private SaasFieldParsing getParsing(FieldConfig domainFieldConfig) {
        if (domainFieldConfig.isExtractCnFromDn()) {
            return SaasFieldParsing.EXTRACT_CN_FROM_DN;
        }
        if (domainFieldConfig.isExtractUserNameFromEmail()) {
            return SaasFieldParsing.EXTRACT_USERNAME_FROM_EMAIL;
        }
        return SaasFieldParsing.NONE;
    }

    private void apiToDomainParser(SaasFieldConfiguration apiFieldConfig, FieldConfig domainFieldConfig) {
        if (SaasFieldParsing.EXTRACT_USERNAME_FROM_EMAIL == apiFieldConfig.getParser()) {
            domainFieldConfig.setExtractUserNameFromEmail(true);
        }
        if (SaasFieldParsing.EXTRACT_CN_FROM_DN == apiFieldConfig.getParser()) {
            domainFieldConfig.setExtractCnFromDn(true);
        }
    }
}

