/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.ServiceAuthentication;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AppAuthMap;
import org.sourceid.saml20.domain.mgmt.impl.AppAuthMapManagerImpl;

public class ServiceAuthenticationTranslator {
    public static ServiceAuthentication domainToApi(AppAuthMapManagerImpl appAuthMapMgr) {
        ServiceAuthentication apiResponse = new ServiceAuthentication();
        if (appAuthMapMgr.getAttributeQueryMap().isActive()) {
            ServiceAuthentication.ServiceModel attrQuery = new ServiceAuthentication.ServiceModel();
            attrQuery.setId(appAuthMapMgr.getAttributeQueryMap().getId());
            attrQuery.setSharedSecret(null);
            attrQuery.setEncryptedSharedSecret(appAuthMapMgr.getAttributeQueryMap().getSharedSecret());
            apiResponse.setAttributeQuery(attrQuery);
        }
        if (appAuthMapMgr.getJmxMap().isActive()) {
            ServiceAuthentication.ServiceModel jmx = new ServiceAuthentication.ServiceModel();
            jmx.setId(appAuthMapMgr.getJmxMap().getId());
            jmx.setSharedSecret(null);
            jmx.setEncryptedSharedSecret(appAuthMapMgr.getJmxMap().getSharedSecret());
            apiResponse.setJmx(jmx);
        }
        if (appAuthMapMgr.getConnectionManagementMap().isActive()) {
            ServiceAuthentication.ServiceModel connManagement = new ServiceAuthentication.ServiceModel();
            connManagement.setId(appAuthMapMgr.getConnectionManagementMap().getId());
            connManagement.setSharedSecret(null);
            connManagement.setEncryptedSharedSecret(appAuthMapMgr.getConnectionManagementMap().getSharedSecret());
            apiResponse.setConnectionManagement(connManagement);
        }
        if (appAuthMapMgr.getSsoDirectoryServiceMap().isActive()) {
            ServiceAuthentication.ServiceModel ssoDirService = new ServiceAuthentication.ServiceModel();
            String domainId = appAuthMapMgr.getSsoDirectoryServiceMap().getId();
            domainId = StringUtils.isBlank((String)domainId) ? "" : domainId;
            ssoDirService.setId(domainId);
            ssoDirService.setSharedSecret(null);
            String domainSharedSecret = appAuthMapMgr.getSsoDirectoryServiceMap().getSharedSecret();
            domainSharedSecret = StringUtils.isBlank((String)domainSharedSecret) ? "" : domainSharedSecret;
            ssoDirService.setEncryptedSharedSecret(domainSharedSecret);
            apiResponse.setSsoDirectoryService(ssoDirService);
        }
        return apiResponse;
    }

    public static void apiToDomain(ServiceAuthentication apiRequest, AppAuthMapManagerImpl appAuthMapMgr) {
        AppAuthMap attrQueryDomain = new AppAuthMap(new HashMap());
        AppAuthMap jmxDomain = new AppAuthMap(new HashMap());
        AppAuthMap connMgmtDomain = new AppAuthMap(new HashMap());
        AppAuthMap ssoDirServiceDomain = new AppAuthMap(new HashMap());
        boolean isEncryptedSharedSecret = false;
        if (apiRequest == null) {
            attrQueryDomain.deactivate();
            jmxDomain.deactivate();
            connMgmtDomain.deactivate();
            ssoDirServiceDomain.deactivate();
            appAuthMapMgr.saveAttributeQueryMap(attrQueryDomain);
            appAuthMapMgr.saveJmxMap(jmxDomain);
            appAuthMapMgr.saveConnectionManagementMap(connMgmtDomain);
            appAuthMapMgr.saveSsoDirectoryServiceMap(ssoDirServiceDomain);
        } else {
            ServiceAuthentication.ServiceModel attributeQueryApi = apiRequest.getAttributeQuery();
            if (attributeQueryApi != null) {
                attrQueryDomain.activate();
                attrQueryDomain.setId(attributeQueryApi.getId());
                String sharedSecret = attributeQueryApi.getSharedSecret();
                if (StringUtils.isBlank((String)sharedSecret)) {
                    sharedSecret = attributeQueryApi.getEncryptedSharedSecret();
                    isEncryptedSharedSecret = true;
                }
                attrQueryDomain.setSharedSecret(sharedSecret);
                attrQueryDomain.setConfirmSharedSecret(sharedSecret);
            } else {
                attrQueryDomain.deactivate();
            }
            appAuthMapMgr.saveAttributeQueryMap(attrQueryDomain, isEncryptedSharedSecret);
            ServiceAuthentication.ServiceModel jmxApi = apiRequest.getJmx();
            isEncryptedSharedSecret = false;
            if (jmxApi != null) {
                jmxDomain.activate();
                jmxDomain.setId(jmxApi.getId());
                String sharedSecret = jmxApi.getSharedSecret();
                if (StringUtils.isBlank((String)sharedSecret)) {
                    sharedSecret = jmxApi.getEncryptedSharedSecret();
                    isEncryptedSharedSecret = true;
                }
                jmxDomain.setSharedSecret(sharedSecret);
                jmxDomain.setConfirmSharedSecret(sharedSecret);
            } else {
                jmxDomain.deactivate();
            }
            appAuthMapMgr.saveJmxMap(jmxDomain, isEncryptedSharedSecret);
            ServiceAuthentication.ServiceModel connMgmtApi = apiRequest.getConnectionManagement();
            isEncryptedSharedSecret = false;
            if (connMgmtApi != null) {
                connMgmtDomain.activate();
                connMgmtDomain.setId(connMgmtApi.getId());
                String sharedSecret = connMgmtApi.getSharedSecret();
                if (StringUtils.isBlank((String)sharedSecret)) {
                    sharedSecret = connMgmtApi.getEncryptedSharedSecret();
                    isEncryptedSharedSecret = true;
                }
                connMgmtDomain.setSharedSecret(sharedSecret);
                connMgmtDomain.setConfirmSharedSecret(sharedSecret);
            } else {
                connMgmtDomain.deactivate();
            }
            appAuthMapMgr.saveConnectionManagementMap(connMgmtDomain, isEncryptedSharedSecret);
            ServiceAuthentication.ServiceModel ssoDirServiceApi = apiRequest.getSsoDirectoryService();
            isEncryptedSharedSecret = false;
            if (ssoDirServiceApi != null) {
                ssoDirServiceDomain.activate();
                ssoDirServiceDomain.setId(ssoDirServiceApi.getId());
                String sharedSecret = ssoDirServiceApi.getSharedSecret();
                if (StringUtils.isBlank((String)sharedSecret)) {
                    sharedSecret = ssoDirServiceApi.getEncryptedSharedSecret();
                    isEncryptedSharedSecret = StringUtils.isNotBlank((String)sharedSecret);
                }
                ssoDirServiceDomain.setSharedSecret(sharedSecret);
                ssoDirServiceDomain.setConfirmSharedSecret(sharedSecret);
            } else {
                ssoDirServiceDomain.deactivate();
            }
            appAuthMapMgr.saveSsoDirectoryServiceMap(ssoDirServiceDomain, isEncryptedSharedSecret);
        }
    }
}

