/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SpAdapterMapping;
import com.pingidentity.admin.api.model.plugin.SpAdapter;
import com.pingidentity.admin.api.validator.SpAdapterValidator;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.plugin.SpAdapterTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import java.util.List;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.impl.SpAdapterManagerImpl;

public class SpAdapterMappingTranslator {
    private ValidatorContext validatorContext;

    public SpAdapterMappingTranslator(ValidatorContext validatorContext) {
        this.validatorContext = validatorContext;
    }

    public void apiToDomain(IdpConnection apiConn, Collection<TargetAttributeMapping> domainMappings) {
        List<SpAdapterMapping> adapterMappings = apiConn.getIdpBrowserSso().getAdapterMappings();
        domainMappings.clear();
        for (SpAdapterMapping apiMapping : adapterMappings) {
            TargetAttributeMapping domainMapping = new TargetAttributeMapping();
            AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator();
            mappingTranslator.apiToDomain(apiMapping, (AttributeMapping)domainMapping);
            domainMappings.add(domainMapping);
            domainMapping.setRestrictVirtualServerIds(apiMapping.isRestrictVirtualEntityIds());
            if (apiMapping.isRestrictVirtualEntityIds()) {
                domainMapping.setRestrictedVirtualServerIds(apiMapping.getRestrictedVirtualEntityIds());
            }
            if (apiMapping.hasAdapterOverride()) {
                SpAdapter adapterOverride = apiMapping.getAdapterOverrideSettings();
                SpAdapterValidator spAdapterValidator = new SpAdapterValidator(adapterOverride, false, this.validatorContext);
                spAdapterValidator.validate();
                SpAdapterTranslator spAdapterTranslator = new SpAdapterTranslator();
                AuthnAdapterInstance domainOverrideAdapterInstance = spAdapterTranslator.apiToDomain(adapterOverride, spAdapterValidator);
                String parentAdapterId = adapterOverride.getParentRef().getId();
                String connectionId = apiConn.getEntityId();
                String adapterRefGeneratedId = adapterOverride.getId();
                domainMapping.setAdapterInstanceId(adapterRefGeneratedId);
                domainOverrideAdapterInstance.setId(adapterRefGeneratedId);
                domainOverrideAdapterInstance.setParentId(parentAdapterId);
                domainOverrideAdapterInstance.setConnectionId(connectionId);
                domainMapping.setConnectionOverrideInstance(domainOverrideAdapterInstance);
                continue;
            }
            domainMapping.setAdapterInstanceId(apiMapping.getSpAdapterRef().getId());
        }
    }

    public void domainToApi(Collection<TargetAttributeMapping> domainMappings, List<SpAdapterMapping> adapterMappings) {
        adapterMappings.clear();
        for (TargetAttributeMapping domainMapping : domainMappings) {
            AuthnAdapterInstance domainAdapterOverride;
            ResourceLink resourceId = new ResourceLink();
            String adapterId = domainMapping.getAdapterInstanceId();
            if (adapterId != null) {
                resourceId.setId(adapterId);
                resourceId.setLocation(ApiUtil.getResourceUrl("/sp/adapters", adapterId));
            }
            SpAdapterMapping spAdapterMapping = new SpAdapterMapping();
            spAdapterMapping.setSpAdapterRef(resourceId);
            adapterMappings.add(spAdapterMapping);
            AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator(adapterId, (PluginManager<?, ?>)new SpAdapterManagerImpl());
            mappingTranslator.domainToApi((AttributeMapping)domainMapping, spAdapterMapping);
            spAdapterMapping.setRestrictVirtualEntityIds(domainMapping.isRestrictVirtualServerIds());
            if (domainMapping.isRestrictVirtualServerIds()) {
                spAdapterMapping.setRestrictedVirtualEntityIds(domainMapping.getRestrictedVirtualServerIds());
            }
            if ((domainAdapterOverride = domainMapping.getConnectionOverrideInstance()) == null) continue;
            SpAdapterTranslator spAdapterTranslator = new SpAdapterTranslator();
            SpAdapter apiAdapterOverride = spAdapterTranslator.domainToApi((ConfigurablePluginInstance)domainAdapterOverride);
            apiAdapterOverride.setPluginDescriptorRef(null);
            apiAdapterOverride.setName(null);
            spAdapterMapping.setSpAdapterRef(null);
            spAdapterMapping.setAdapterOverrideSettings(apiAdapterOverride);
        }
    }

    static String getAdapterIdForApplicationUrl(List<SpAdapterMapping> adapterMappings) {
        if (adapterMappings != null && adapterMappings.size() == 1) {
            SpAdapterMapping spAdapterMapping = adapterMappings.get(0);
            if (spAdapterMapping.hasAdapterOverride()) {
                return spAdapterMapping.getAdapterOverrideSettings().getParentRef().getId();
            }
            return spAdapterMapping.getSpAdapterRef().getId();
        }
        return null;
    }
}

