/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.AssertionLifetime;
import com.pingidentity.admin.api.model.BaseBrowserSso;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.EncryptionPolicy;
import com.pingidentity.admin.api.model.ProtocolMessageCustomization;
import com.pingidentity.admin.api.model.SloServiceEndpoint;
import com.pingidentity.admin.api.model.SpBrowserSso;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.SpSsoServiceEndpoint;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.admin.rest.translator.AuthenticationPolicyContractAssertionMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.BaseBrowserSsoTranslator;
import com.pingidentity.pf.admin.rest.translator.IdpAdapterMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.SpConnectionAttributeContractTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.WsTrustVersion;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.util.SSOApplicationUrlUtil;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.domain.trans.DomainTranslator;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class SpBrowserSsoTranslator
extends BaseBrowserSsoTranslator {
    private static final Set<Protocol> SUPPORTED_DOMAIN_PROTOCOLS = new HashSet<Protocol>();
    private static final Set<Binding> SUPPORTED_SSO_BINDINGS = new HashSet<Binding>();
    private ValidatorContext validatorContext;

    public SpBrowserSsoTranslator(ValidatorContext validatorContext) {
        this.validatorContext = validatorContext;
    }

    public void apiToDomain(SpConnection apiConn, org.sourceid.saml20.domain.SpConnection domainConn) {
        SpBrowserSso browserSso = apiConn.getSpBrowserSso();
        if (browserSso == null) {
            this.apiToDomain(Collections.emptySet(), domainConn.getEnabledProfiles());
        } else {
            Protocol domainProtocol = Protocol.valueOf((String)apiConn.getSpBrowserSso().getProtocol().name());
            domainConn.setProtocol(domainProtocol);
            if (domainProtocol != Protocol.SAML20) {
                this.populateEnabledProfilesAndIncomingBindings(apiConn.getSpBrowserSso(), Role.SP);
            }
            this.apiToDomain(browserSso.getEnabledProfiles(), domainConn.getEnabledProfiles());
            this.apiToDomain(browserSso.getIncomingBindings(), domainConn.getIncomingBindings());
            this.apiToDomain(browserSso.getMessageCustomizations(), domainConn.getMessageCustomizationHooks());
            this.apiToDomain(browserSso.getSsoServiceEndpoints(), domainProtocol, domainConn.getAssertionConsumerServiceEndpoints());
            this.apiToDomain(browserSso.getSloServiceEndpoints(), domainProtocol, domainConn.getSingleLogoutServices(), browserSso);
            domainConn.setWantAssertionsSigned(browserSso.isSignAssertions() == null ? false : browserSso.isSignAssertions());
            domainConn.setSignResponseAsRequired(!browserSso.getProtocol().equals((Object)com.pingidentity.admin.api.model.Protocol.SAML20) ? Boolean.TRUE : browserSso.isSignResponseAsRequired());
            if (domainProtocol != Protocol.WSFED) {
                domainConn.setAuthnRequestsSigned(browserSso.isRequireSignedAuthnRequests() == null ? false : browserSso.isRequireSignedAuthnRequests());
                if (this.isArtifactEnabled(browserSso)) {
                    domainConn.setAlwaysSignArtifactResponse(browserSso.isAlwaysSignArtifactResponse() == null ? false : browserSso.isAlwaysSignArtifactResponse());
                }
            }
            if (domainProtocol == Protocol.SAML20 || WsFedTokenType.SAML20 == browserSso.getWsFedTokenType()) {
                this.apiToDomain(browserSso.getEncryptionPolicy(), domainConn.getEncryptionSettings().getEncryptionPolicy());
                domainConn.getEncryptionSettings().getDecryptionPolicy().setSloSubjectNameIDEncrypted(browserSso.getEncryptionPolicy().isSloSubjectNameIDEncrypted());
            }
            this.apiToDomain(browserSso.getUrlWhitelistEntries(), (ConnectionBase)domainConn);
            domainConn.setDefaultTargetResource(browserSso.getDefaultTargetUrl());
            AssertionLifetime assertionLifetime = apiConn.getSpBrowserSso().getAssertionLifetime();
            domainConn.setAssertionValidityAfterMinutes(assertionLifetime.getMinutesAfter());
            domainConn.setAssertionValidityBeforeMinutes(assertionLifetime.getMinutesBefore());
            this.apiToDomainArtifact(browserSso, (ConnectionBase)domainConn);
            SpConnectionAttributeContractTranslator acTranslator = new SpConnectionAttributeContractTranslator();
            IdpAdapterMappingTranslator adapterTranslator = new IdpAdapterMappingTranslator(this.validatorContext);
            AuthenticationPolicyContractAssertionMappingTranslator authenticationPolicyContractAssertionMappingTranslator = new AuthenticationPolicyContractAssertionMappingTranslator();
            acTranslator.apiToDomain(apiConn, domainConn);
            ArrayList<AdapterToAssertionMapping> newMappings = new ArrayList<AdapterToAssertionMapping>();
            adapterTranslator.apiToDomain(apiConn, newMappings);
            domainConn.setAdapterMappings(newMappings);
            ArrayList<C2cContractToAssertionMapping> newDomainMappings = new ArrayList<C2cContractToAssertionMapping>();
            authenticationPolicyContractAssertionMappingTranslator.apiToDomain(apiConn, newDomainMappings);
            domainConn.setC2cMappings(newDomainMappings);
        }
    }

    public void domainToApi(org.sourceid.saml20.domain.SpConnection domainConn, SpConnection apiConn) {
        EnabledProfiles domainProfiles = domainConn.getEnabledProfiles();
        Protocol domainProtocol = domainConn.getProtocol();
        if ((domainProfiles.isIdpInitiatedSSOEnabled() || domainProfiles.isSpInitiatedSSOEnabled()) && SUPPORTED_DOMAIN_PROTOCOLS.contains(domainProtocol) && this.isBrowserSSOProfileEnabled(domainProtocol)) {
            SpBrowserSso browserSso = new SpBrowserSso();
            apiConn.setSpBrowserSso(browserSso);
            com.pingidentity.admin.api.model.Protocol protocol = com.pingidentity.admin.api.model.Protocol.valueOf(domainProtocol.name());
            browserSso.setProtocol(protocol);
            if (domainConn.getWsFedSettings() != null) {
                WsFedTokenType wsTokenType = WsFedTokenType.valueOf(domainConn.getWsFedSettings().getTokenType().name());
                browserSso.setWsFedTokenType(wsTokenType);
                browserSso.setWsTrustVersion(WsTrustVersion.getWsTrustVersion((String)domainConn.getWsFedSettings().getWsTrustVersion()));
            }
            if (domainProtocol == Protocol.SAML20) {
                this.domainToApi(domainProfiles, browserSso.getEnabledProfiles());
                if (domainConn.isSpSsoSelected() || domainConn.isAnySloSelected()) {
                    HashSet<Binding> bindings = new HashSet<Binding>();
                    this.domainToApi(domainConn.getIncomingBindings(), bindings);
                    browserSso.setIncomingBindings(bindings);
                }
            } else {
                browserSso.setEnabledProfiles(null);
                browserSso.setIncomingBindings(null);
            }
            if (!domainConn.getMessageCustomizationHooks().isEmpty() && ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
                browserSso.setMessageCustomizations(new ArrayList<ProtocolMessageCustomization>());
                this.domainToApi(domainConn.getMessageCustomizationHooks(), browserSso.getMessageCustomizations());
            }
            browserSso.setDefaultTargetUrl(domainConn.getDefaultTargetResource());
            AssertionLifetime assertionLifetime = new AssertionLifetime(domainConn.getAssertionValidityBeforeMinutes(), domainConn.getAssertionValidityAfterMinutes());
            browserSso.setAssertionLifetime(assertionLifetime);
            if (protocol == com.pingidentity.admin.api.model.Protocol.WSFED) {
                browserSso.setSignAssertions(null);
                browserSso.setRequireSignedAuthnRequests(null);
                if (WsTrustTokenType.SAML20 == domainConn.getWsFedSettings().getTokenType()) {
                    browserSso.setEncryptionPolicy(new EncryptionPolicy());
                    this.domainToApi(domainConn.getEncryptionSettings().getEncryptionPolicy(), browserSso.getEncryptionPolicy());
                    browserSso.getEncryptionPolicy().setSloSubjectNameIDEncrypted(domainConn.getEncryptionSettings().getDecryptionPolicy().isSloSubjectNameIDEncrypted());
                }
            } else {
                if (protocol == com.pingidentity.admin.api.model.Protocol.SAML10 || protocol == com.pingidentity.admin.api.model.Protocol.SAML11) {
                    browserSso.setRequireSignedAuthnRequests(null);
                } else {
                    browserSso.setRequireSignedAuthnRequests(domainConn.isAuthnRequestsSigned());
                }
                browserSso.setSignAssertions(domainConn.isWantAssertionsSigned());
                if (protocol == com.pingidentity.admin.api.model.Protocol.SAML20) {
                    browserSso.setSignResponseAsRequired(domainConn.isSignResponseAsRequired());
                } else {
                    browserSso.setSignResponseAsRequired(null);
                }
            }
            if (protocol == com.pingidentity.admin.api.model.Protocol.SAML20) {
                browserSso.setEncryptionPolicy(new EncryptionPolicy());
                this.domainToApi(domainConn.getEncryptionSettings().getEncryptionPolicy(), browserSso.getEncryptionPolicy());
                browserSso.getEncryptionPolicy().setSloSubjectNameIDEncrypted(domainConn.getEncryptionSettings().getDecryptionPolicy().isSloSubjectNameIDEncrypted());
            }
            this.domainToApi(domainConn.getAssertionConsumerServiceEndpoints(), domainConn.getProtocol(), browserSso);
            this.domainToApi(domainConn.getSingleLogoutServices(), domainConn.getProtocol(), (BaseBrowserSso)browserSso);
            this.domainToApiArtifact((ConnectionBase)domainConn, browserSso);
            if (this.isArtifactEnabled((ConnectionBase)domainConn)) {
                browserSso.setAlwaysSignArtifactResponse(domainConn.isAlwaysSignArtifactResponse());
            }
            this.domainToApi(domainConn.getRedirectValidationWhitelist(), browserSso);
            SpConnectionAttributeContractTranslator acTranslator = new SpConnectionAttributeContractTranslator();
            IdpAdapterMappingTranslator adapterTranslator = new IdpAdapterMappingTranslator(this.validatorContext);
            acTranslator.domainToApi(domainConn, apiConn);
            adapterTranslator.domainToApi(domainConn.getAdapterMappings(), browserSso.getAdapterMappings());
            AuthenticationPolicyContractAssertionMappingTranslator authenticationPolicyContractAssertionMappingTranslator = new AuthenticationPolicyContractAssertionMappingTranslator();
            authenticationPolicyContractAssertionMappingTranslator.domainToApi(domainConn.getC2cMappings(), browserSso.getAuthenticationPolicyContractAssertionMappings());
            boolean setSsoApplicationURL = SSOApplicationUrlUtil.displaySpConnectionSsoURL((Protocol)domainProtocol, (boolean)browserSso.isIdpSsoSelected());
            if (setSsoApplicationURL) {
                String ssoUrl = SSOApplicationUrlUtil.getSSOUrl((boolean)false, (boolean)true, (String)apiConn.getEntityId(), null);
                browserSso.setSsoApplicationEndpoint(ssoUrl);
            }
        }
    }

    private void apiToDomain(List<SloServiceEndpoint> sloEndpoints, Protocol protocol, EndpointGroup sloServices, SpBrowserSso browserSso) {
        super.apiToDomain(sloEndpoints, protocol, sloServices);
        if (protocol == Protocol.WSFED) {
            ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>();
            for (SpSsoServiceEndpoint item : browserSso.getSsoServiceEndpoints()) {
                allEndpoints.add(new Endpoint("wsfed:prp:http:get", item.getUrl()));
            }
            sloServices.setEndpoints(allEndpoints);
        }
    }

    private void apiToDomain(List<SpSsoServiceEndpoint> consumerEndpoints, Protocol protocol, IndexedEndpoints domainSsoEndpointGroup) {
        if (consumerEndpoints == null || consumerEndpoints.isEmpty()) {
            return;
        }
        DomainTranslator bindingTranslator = DomainTranslator.getTranslator((Protocol)protocol);
        Integer index = 0;
        for (SpSsoServiceEndpoint ssoEndpoint : consumerEndpoints) {
            String newBinding;
            if (protocol == Protocol.WSFED) {
                newBinding = "wsfed:prp:http:post";
            } else if (protocol == Protocol.SAML10 || protocol == Protocol.SAML11) {
                newBinding = bindingTranslator.toBindingUri(ssoEndpoint.getBinding().getGuiName());
            } else {
                newBinding = bindingTranslator.toBindingUri(ssoEndpoint.getBinding().getGuiName());
                index = ssoEndpoint.getIndex();
            }
            String newLocation = ssoEndpoint.getUrl();
            domainSsoEndpointGroup.setEndpoint(index.intValue(), new Endpoint(newBinding, newLocation));
            if (ssoEndpoint.getIsDefault() != null && ssoEndpoint.getIsDefault().booleanValue() || protocol != Protocol.SAML20 && index == 0) {
                domainSsoEndpointGroup.setDefault(index.intValue());
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
    }

    private void domainToApi(IndexedEndpoints domainSsoEndpointGroup, Protocol protocol, SpBrowserSso idpBrowserSso) {
        LinkedList<SpSsoServiceEndpoint> endpoints = new LinkedList<SpSsoServiceEndpoint>();
        DomainTranslator bindingTranslator = DomainTranslator.getTranslator((Protocol)protocol);
        for (Map.Entry indexedEndpoint : domainSsoEndpointGroup.getEndpointsMap().entrySet()) {
            Endpoint endpoint = (Endpoint)indexedEndpoint.getValue();
            Integer index = (Integer)indexedEndpoint.getKey();
            Boolean isDefault = index.equals(domainSsoEndpointGroup.getDefaultIndex());
            String bindingUri = endpoint.getBinding();
            String bindingName = bindingTranslator.toBindingGuiName(bindingUri);
            Binding bindingModel = Binding.fromGuiName(bindingName);
            if (protocol != Protocol.SAML20) {
                index = null;
                isDefault = null;
                if (protocol == Protocol.WSFED) {
                    bindingModel = null;
                }
            }
            if ((bindingModel == null || !SUPPORTED_SSO_BINDINGS.contains((Object)bindingModel)) && protocol != Protocol.WSFED) continue;
            SpSsoServiceEndpoint spSsoServiceEndpoint = new SpSsoServiceEndpoint();
            if (bindingModel != null) {
                spSsoServiceEndpoint.setBinding(bindingModel);
                spSsoServiceEndpoint.setIndex(index);
            }
            spSsoServiceEndpoint.setUrl(endpoint.getLocation());
            spSsoServiceEndpoint.setIsDefault(isDefault);
            endpoints.add(spSsoServiceEndpoint);
        }
        idpBrowserSso.setSsoServiceEndpoints(endpoints);
    }

    private void apiToDomain(EncryptionPolicy apiEncryptPolicy, org.sourceid.saml20.domain.EncryptionPolicy domainEncryptPolicy) {
        domainEncryptPolicy.setEncryptAssertion(apiEncryptPolicy.isEncryptAssertion());
        domainEncryptPolicy.setEncryptAttributeList(apiEncryptPolicy.getEncryptedAttributes());
        domainEncryptPolicy.setEncryptSubjectNameID(this.doesListContainSamlSubject(apiEncryptPolicy.getEncryptedAttributes()));
        domainEncryptPolicy.setSloEncryptSubjectNameID(apiEncryptPolicy.isEncryptSloSubjectNameId());
    }

    private void domainToApi(org.sourceid.saml20.domain.EncryptionPolicy domainDecryptPolicy, EncryptionPolicy apiDecryptPolicy) {
        apiDecryptPolicy.setEncryptAssertion(domainDecryptPolicy.isEncryptAssertion());
        apiDecryptPolicy.setEncryptAttributeList(domainDecryptPolicy.getEncryptAttributeList());
        apiDecryptPolicy.setEncryptSloSubjectNameId(domainDecryptPolicy.isSloEncryptSubjectNameID());
    }

    private boolean doesListContainSamlSubject(List<String> encryptAttributeList) {
        if (encryptAttributeList != null && !encryptAttributeList.isEmpty()) {
            String samlSubjectNameId = AssertionMapKeys.getNameIdValueKey();
            for (String attrName : encryptAttributeList) {
                if (!samlSubjectNameId.equals(attrName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBrowserSSOProfileEnabled(Protocol protocol) {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableProtocolIdP(protocol);
    }

    static {
        SUPPORTED_DOMAIN_PROTOCOLS.add(Protocol.SAML20);
        SUPPORTED_DOMAIN_PROTOCOLS.add(Protocol.WSFED);
        SUPPORTED_DOMAIN_PROTOCOLS.add(Protocol.SAML10);
        SUPPORTED_DOMAIN_PROTOCOLS.add(Protocol.SAML11);
        SUPPORTED_SSO_BINDINGS.add(Binding.ARTIFACT);
        SUPPORTED_SSO_BINDINGS.add(Binding.POST);
    }
}

