/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.SpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.SpBrowserSsoAttributeContract;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.SpSamlIdentityMapping;
import com.pingidentity.admin.api.model.SpWsFedIdentityMapping;
import com.pingidentity.admin.api.model.WsFedTokenType;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AssertionAttributeContract;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.websso.Protocol;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class SpConnectionAttributeContractTranslator {
    public void apiToDomain(SpConnection spConn, org.sourceid.saml20.domain.SpConnection domainConn) {
        SpBrowserSsoAttributeContract apiContract = spConn.getSpBrowserSso().getAttributeContract();
        Object domainContract = null;
        if (this.isSAML(spConn)) {
            if (spConn.getBrowserSso().getProtocol() == com.pingidentity.admin.api.model.Protocol.SAML10) {
                domainContract = new AttributeContract();
                if (apiContract.getCoreAttributes().get(0) == null || StringUtils.isBlank((String)apiContract.getCoreAttributes().get(0).getNameFormat())) {
                    domainConn.setNameIdFormat(SpSamlIdentityMapping.STANDARD.getNameIdFormatUri());
                } else {
                    domainConn.setNameIdFormat(apiContract.getCoreAttributes().get(0).getNameFormat());
                }
            } else if (spConn.getSpBrowserSso().getSpSamlIdentityMapping().equals((Object)SpSamlIdentityMapping.TRANSIENT)) {
                domainConn.setNameIdFormat(SpSamlIdentityMapping.TRANSIENT.getNameIdFormatUri());
                domainContract = new AssertionAttributeContract(false, true);
                if (apiContract.getExtendedAttributes().size() > 0) {
                    domainConn.setIncludeAdditionalTransientAttributes(true);
                }
            } else if (spConn.getSpBrowserSso().getSpSamlIdentityMapping().equals((Object)SpSamlIdentityMapping.PSEUDONYM)) {
                domainConn.setNameIdFormat(SpSamlIdentityMapping.PSEUDONYM.getNameIdFormatUri());
                domainContract = new AssertionAttributeContract(true, false);
                if (apiContract.getExtendedAttributes().size() > 0) {
                    domainConn.setIncludeAdditionalAttributes(true);
                }
            } else {
                domainContract = new AssertionAttributeContract();
                if (apiContract.getCoreAttributes().get(0) == null || StringUtils.isBlank((String)apiContract.getCoreAttributes().get(0).getNameFormat())) {
                    domainConn.setNameIdFormat(SpSamlIdentityMapping.STANDARD.getNameIdFormatUri());
                } else {
                    domainConn.setNameIdFormat(apiContract.getCoreAttributes().get(0).getNameFormat());
                }
            }
        } else if (spConn.getSpBrowserSso().getProtocol() == com.pingidentity.admin.api.model.Protocol.WSFED) {
            domainContract = spConn.getSpBrowserSso().getWsFedTokenType() == WsFedTokenType.JWT ? new AttributeContract() : new AssertionAttributeContract();
            if (spConn.getSpBrowserSso().getSpWsFedIdentityMapping() != null) {
                domainConn.setNameIdFormat(spConn.getSpBrowserSso().getSpWsFedIdentityMapping().getNameIdFormatUri());
            }
        }
        for (SpBrowserSsoAttribute mutableAttr : apiContract.getExtendedAttributes()) {
            String attrName = mutableAttr.getName();
            domainContract.addMutableAttributeName(attrName);
            domainContract.addMutableAttributeInfo(attrName, mutableAttr.getNameFormat());
        }
        domainConn.setAttributeContract(domainContract);
    }

    private boolean isSAML(SpConnection spConn) {
        return spConn.getSpBrowserSso().getProtocol() == com.pingidentity.admin.api.model.Protocol.SAML20 || spConn.getSpBrowserSso().getProtocol() == com.pingidentity.admin.api.model.Protocol.SAML10 || spConn.getSpBrowserSso().getProtocol() == com.pingidentity.admin.api.model.Protocol.SAML11;
    }

    public void domainToApi(org.sourceid.saml20.domain.SpConnection domainConn, SpConnection apiConn) {
        SpBrowserSsoAttributeContract apiContract = apiConn.getSpBrowserSso().getAttributeContract();
        AttributeContract domainContract = domainConn.getAttributeContract();
        if (domainConn.getProtocol() == Protocol.WSFED && (domainConn.getWsFedSettings().getTokenType() == WsTrustTokenType.SAML11 || domainConn.getWsFedSettings().getTokenType() == WsTrustTokenType.SAML20)) {
            apiConn.getSpBrowserSso().setSpWsFedIdentityMapping(SpWsFedIdentityMapping.fromFormatUri(domainConn.getNameIdFormat()));
        }
        if (domainConn.getProtocol() != Protocol.WSFED) {
            apiConn.getSpBrowserSso().setSpSamlIdentityMapping(SpSamlIdentityMapping.fromFormatUri(domainConn.getNameIdFormat()));
        }
        for (String immutableAttrName : domainContract.getImmutableAttributeNames()) {
            SpBrowserSsoAttribute immutableAttr = new SpBrowserSsoAttribute();
            immutableAttr.setName(immutableAttrName);
            if (domainConn.getProtocol() != Protocol.WSFED) {
                immutableAttr.setNameFormat(domainConn.getNameIdFormat() != null ? domainConn.getNameIdFormat() : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            }
            apiContract.getCoreAttributes().add(immutableAttr);
        }
        for (String mutableAttrName : domainContract.getMutableAttributeNames()) {
            SpBrowserSsoAttribute mutableAttr = new SpBrowserSsoAttribute();
            mutableAttr.setName(mutableAttrName);
            if (domainConn.getProtocol() != Protocol.SAML10) {
                mutableAttr.setNameFormat(domainConn.getAttributeContract().getMutableAttributeNameFormat(mutableAttrName));
            }
            apiContract.getExtendedAttributes().add(mutableAttr);
        }
    }
}

