/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.SpUrlMapping;
import com.pingidentity.admin.api.model.SpUrlMappings;
import com.pingidentity.pf.admin.rest.translator.SpUrlMappingTranslator;
import java.util.List;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.UrlToTargetMapping;
import org.sourceid.saml20.domain.UrlToTargetMappings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.TargetSessionId;

public class SpUrlMappingsTranslator {
    private final SpUrlMappingTranslator translator = new SpUrlMappingTranslator();

    public void apiToDomain(SpUrlMappings apiMappings, UrlToTargetMappings domainMappings) {
        List urlToConnectionMap = domainMappings.getMappings();
        urlToConnectionMap.clear();
        for (SpUrlMapping apiMapping : apiMappings.getItems()) {
            UrlToTargetMapping domainMapping = new UrlToTargetMapping();
            this.translator.apiToDomain(apiMapping, domainMapping);
            urlToConnectionMap.add(domainMapping);
        }
    }

    public void domainToApi(UrlToTargetMappings domainMappings, SpUrlMappings apiMappings) {
        apiMappings.clear();
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        boolean fedHubEnabled = localSettings.isEnableFederationHub();
        for (UrlToTargetMapping domainMapping : domainMappings.getMappings()) {
            if (!fedHubEnabled && domainMapping.getTargetType() == TargetSessionId.TargetSessionType.SP_CONN) continue;
            SpUrlMapping apiMapping = new SpUrlMapping();
            this.translator.domainToApi(domainMapping, apiMapping);
            apiMappings.add(apiMapping);
        }
    }
}

