/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.TokenToTokenMapping;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.Map;
import java.util.Set;
import org.sourceid.a2a.domain.Token2TokenMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class TokenToTokenMappingTranslator {
    public static TokenToTokenMapping domainToApi(Token2TokenMapping domainMapping) {
        TokenToTokenMapping apiMapping = new TokenToTokenMapping();
        apiMapping.setId(ApiUtil.combineId(domainMapping.getSourceId(), domainMapping.getTargetId()));
        apiMapping.setSourceId(domainMapping.getSourceId());
        apiMapping.setTargetId(domainMapping.getTargetId());
        AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator();
        mappingTranslator.domainToApi((AttributeMapping)domainMapping, apiMapping);
        apiMapping.setDefaultTargetResource(domainMapping.getDefaultTargetResource());
        apiMapping.setLicenseConnectionGroupAssignment(domainMapping.getLicenseConnectionGroupAssignment());
        return apiMapping;
    }

    public static Token2TokenMapping apiToDomain(TokenToTokenMapping apiMapping) {
        Token2TokenMapping domainMapping = new Token2TokenMapping();
        domainMapping.setSourceId(apiMapping.getSourceId());
        domainMapping.setTargetId(apiMapping.getTargetId());
        AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator();
        mappingTranslator.apiToDomain(apiMapping, (AttributeMapping)domainMapping);
        domainMapping.setDefaultTargetResource(apiMapping.getDefaultTargetResource());
        domainMapping.setLicenseConnectionGroupAssignment(apiMapping.getLicenseConnectionGroupAssignment());
        return domainMapping;
    }

    public static void cleanupContractFulfillmentMapping(TokenToTokenMapping apiMapping) {
        ConfigurablePluginInstance tokenGenerator = MgmtFactory.getTokenGeneratorManager().getInstance(apiMapping.getTargetId());
        Set attributeContract = tokenGenerator.getAttributeContract().getAllAttributeNames();
        Map<String, AttributeFulfillmentValue> contractFulfillmentMappings = apiMapping.getAttributeContractFulfillment();
        contractFulfillmentMappings.entrySet().removeIf(entry -> !attributeContract.contains(entry.getKey()));
    }
}

