/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.UsernamePasswordCredentials;
import com.pingidentity.admin.api.model.WsTrustStsSettings;
import com.pingidentity.crypto.Cert;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.WsTrustBasicAuthManager;
import org.sourceid.wstrust.mgmt.WsTrustClientCertAuthManager;
import org.sourceid.wstrust.model.BasicAuthUser;

public class WsTrustStsSettingsTranslator {
    private static final WsTrustBasicAuthManager BASIC_AUTH_MANAGER = MgmtFactory.getWsTrustBasicAuthManager();
    private static final WsTrustClientCertAuthManager CLIENT_CERT_AUTH_MANAGER = MgmtFactory.getWsTrustClientCertAuthManager();

    public WsTrustStsSettings domainToApi() {
        WsTrustStsSettings apiWsTrustStsSettings = new WsTrustStsSettings();
        apiWsTrustStsSettings.setBasicAuthnEnabled(BASIC_AUTH_MANAGER.isAuthenticationEnabled());
        apiWsTrustStsSettings.setUsers(this.convertToUsernamePasswordCredentials(BASIC_AUTH_MANAGER.getUsers()));
        apiWsTrustStsSettings.setClientCertAuthnEnabled(CLIENT_CERT_AUTH_MANAGER.isAuthenticationEnabled());
        apiWsTrustStsSettings.setRestrictByIssuerCert(CLIENT_CERT_AUTH_MANAGER.isRestrictByIssuerCert());
        apiWsTrustStsSettings.setRestrictBySubjectDn(CLIENT_CERT_AUTH_MANAGER.isRestrictBySubjectDn());
        apiWsTrustStsSettings.setSubjectDns(CLIENT_CERT_AUTH_MANAGER.getAcceptableSubjectDnList());
        apiWsTrustStsSettings.setIssuerCerts(this.getResourceLinks());
        return apiWsTrustStsSettings;
    }

    private List<UsernamePasswordCredentials> convertToUsernamePasswordCredentials(List<BasicAuthUser> users) {
        ArrayList<UsernamePasswordCredentials> usernamePasswordCredentials = new ArrayList<UsernamePasswordCredentials>();
        for (BasicAuthUser user : users) {
            UsernamePasswordCredentials temp = new UsernamePasswordCredentials();
            temp.setUsername(user.getUsername());
            temp.setPassword(user.getPassword());
            temp.setEncryptedPassword(user.getEncryptedPassword());
            usernamePasswordCredentials.add(temp);
        }
        return usernamePasswordCredentials;
    }

    private List<ResourceLink> getResourceLinks() {
        Set activeCerts = CLIENT_CERT_AUTH_MANAGER.getCertsInUse();
        ArrayList<ResourceLink> resourceLinks = new ArrayList<ResourceLink>();
        for (Cert cert : activeCerts) {
            ResourceLink temp = new ResourceLink(cert.getId(), ApiUtil.getResourceUrl("serverSettings", "wsTrustStsSettings", cert.getId()));
            resourceLinks.add(temp);
        }
        return resourceLinks;
    }

    public void apiToDomain(WsTrustStsSettings wsTrustStsSettings) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            BASIC_AUTH_MANAGER.setAuthenticationEnabled(wsTrustStsSettings.isBasicAuthnEnabled());
            BASIC_AUTH_MANAGER.setUsers(this.convertToBasicAuthUsers(wsTrustStsSettings.getUsers()));
            CLIENT_CERT_AUTH_MANAGER.setAuthenticationEnabled(wsTrustStsSettings.isClientCertAuthnEnabled());
            CLIENT_CERT_AUTH_MANAGER.setRestrictByIssuerCert(wsTrustStsSettings.isRestrictByIssuerCert());
            CLIENT_CERT_AUTH_MANAGER.setRestrictBySubjectDn(wsTrustStsSettings.isRestrictBySubjectDn());
            CLIENT_CERT_AUTH_MANAGER.setAcceptableIssuerCertAliases(this.extractCertIdsFromResourceLinks(wsTrustStsSettings.getIssuerCerts()));
            CLIENT_CERT_AUTH_MANAGER.setAcceptableSubjectDnList(wsTrustStsSettings.getSubjectDns());
            auditLoggerScope.log(AdminAuditLogger.Component.SERVER_SETTINGS, AdminAuditLogger.Event.MODIFY);
        }
    }

    private List<BasicAuthUser> convertToBasicAuthUsers(List<UsernamePasswordCredentials> users) {
        ArrayList<BasicAuthUser> basicAuthUsers = new ArrayList<BasicAuthUser>();
        for (UsernamePasswordCredentials user : users) {
            BasicAuthUser temp = new BasicAuthUser();
            temp.setUsername(user.getUsername());
            if (user.getPassword() != null) {
                temp.setPassword(user.getPassword());
            }
            if (user.getEncryptedPassword() != null) {
                temp.setEncryptedPassword(user.getEncryptedPassword());
            }
            basicAuthUsers.add(temp);
        }
        return basicAuthUsers;
    }

    private List<String> extractCertIdsFromResourceLinks(List<ResourceLink> resourceLinks) {
        return resourceLinks.stream().map(ResourceLink::getId).collect(Collectors.toList());
    }
}

