/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal;

import com.pingidentity.admin.api.model.ReplicationStatus;
import com.pingidentity.common.util.HostAddressUtils;
import com.pingidentity.pf.admin.rest.translator.internal.model.ClusterNode;
import com.pingidentity.pf.admin.rest.translator.internal.model.ClusterNodeAttribute;
import com.pingidentity.pf.admin.rest.translator.internal.model.ClusterNodeGroup;
import com.pingidentity.pf.admin.rest.translator.internal.model.IntegerAttributeWrapper;
import com.pingidentity.pf.admin.rest.translator.internal.model.StringArrayAttributeWrapper;
import com.pingidentity.pf.admin.rest.translator.internal.model.StringAttributeWrapper;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;

public class ClusterNodesTranslator {
    private static final Log log = LogFactory.getLog(ClusterNodesTranslator.class);

    public List<ClusterNodeGroup> getClusterNodeGroups() {
        NodeIndexRegistry nodeIndex = (NodeIndexRegistry)GlobalRegistry.getService(NodeIndexRegistry.class);
        ArrayList<ClusterNodeGroup> clusterNodeGroups = new ArrayList<ClusterNodeGroup>();
        HashMap<String, List<Object>> groupToNodes = new HashMap<String, List<Object>>();
        for (Node node : nodeIndex.getNodes()) {
            List<Object> clusterNodes;
            if (node == null) {
                log.debug((Object)"Unexpected null cluster node returned from node registry. Skipping...");
                continue;
            }
            String nodeAddress = "";
            if (node.getAddress() != null) {
                nodeAddress = node.getAddress().toString();
                try {
                    nodeAddress = HostAddressUtils.getIpAddress((String)nodeAddress);
                }
                catch (UnknownHostException e) {
                    log.debug((Object)"Node address could not be converted to base IP address for display, defaulting to defined address.");
                }
            }
            String nodeGroup = "";
            if (node.getNodeGroupId() != null) {
                nodeGroup = node.getNodeGroupId();
            }
            ClusterNode clusterNode = new ClusterNode(String.valueOf(node.getIndex()), nodeGroup);
            clusterNode.addAttribute(new ClusterNodeAttribute("Node Index", new IntegerAttributeWrapper(node.getIndex())));
            clusterNode.addAttribute(new ClusterNodeAttribute("Version", new StringAttributeWrapper(node.getVersion())));
            clusterNode.addAttribute(new ClusterNodeAttribute("IP Address", new StringAttributeWrapper(nodeAddress)));
            if (!node.isConsole() && node.getNodeTags() != null && !node.getNodeTags().equals("")) {
                StringArrayAttributeWrapper nodeTags = new StringArrayAttributeWrapper(node.getNodeTags().split(" "));
                clusterNode.addAttribute(new ClusterNodeAttribute("Tags", nodeTags));
            }
            if (node.getConfigPublishDate() != null) {
                StringAttributeWrapper configurationTimestamp = new StringAttributeWrapper(node.getConfigPublishDate().toString());
                clusterNode.addAttribute(new ClusterNodeAttribute("Configuration Timestamp", configurationTimestamp));
            }
            if (node.getReplicationStatus() != null) {
                StringAttributeWrapper clusterNodeReplicationStatus = new StringAttributeWrapper(ClusterNodesTranslator.getClusterNodeReplicationStatus(node).toString());
                clusterNode.addAttribute(new ClusterNodeAttribute("Replication Status", clusterNodeReplicationStatus));
            }
            if (groupToNodes.containsKey(nodeGroup)) {
                clusterNodes = new ArrayList((Collection)groupToNodes.get(nodeGroup));
                clusterNodes.add(clusterNode);
            } else {
                clusterNodes = Arrays.asList(clusterNode);
            }
            groupToNodes.put(nodeGroup, clusterNodes);
        }
        for (Map.Entry entry : groupToNodes.entrySet()) {
            ClusterNodeGroup clusterNodeGroup = new ClusterNodeGroup((String)entry.getKey(), (List)entry.getValue());
            clusterNodeGroups.add(clusterNodeGroup);
        }
        return clusterNodeGroups;
    }

    public static ReplicationStatus getClusterNodeReplicationStatus(Node node) {
        if (node.getReplicationStatus().equals((Object)Node.ReplicationStatus.IDLE)) {
            Date lastReplicationDate = MgmtFactory.getMediator().getConfigPublishDate();
            if (node.getConfigPublishDate() == null || lastReplicationDate == null || node.getConfigPublishDate().before(lastReplicationDate)) {
                return ReplicationStatus.OUT_OF_DATE;
            }
            return ReplicationStatus.SUCCEEDED;
        }
        switch (node.getReplicationStatus()) {
            case FAILED: {
                return ReplicationStatus.FAILED;
            }
            case RETRIEVING: {
                return ReplicationStatus.RETRIEVING;
            }
            case APPLYING: {
                return ReplicationStatus.APPLYING;
            }
        }
        return ReplicationStatus.SUCCEEDED;
    }
}

