/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal;

import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavNode;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.applications.Applications;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.authentication.Authentication;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.security.Security;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.system.System;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.util.MenuAuthUtil;
import org.sourceid.util.license.PingLicense;

public class NavTreeTranslator {
    private final PingLicense license;

    public NavTreeTranslator(PingLicense license) {
        this.license = license;
    }

    public List<NavNode> getNavTree(AdministrativeUser currentUser) {
        ArrayList<NavNode> navTree = new ArrayList<NavNode>();
        if (MenuAuthUtil.isPassiveAdminNode()) {
            navTree.add(new System(currentUser, this.license));
            return navTree;
        }
        if (MenuAuthUtil.isAdminVisible((AdministrativeUser)currentUser)) {
            navTree.add(new Authentication(currentUser, this.license));
            navTree.add(new Applications(currentUser, this.license));
        }
        if (MenuAuthUtil.isAdminVisible((AdministrativeUser)currentUser) || currentUser.isCryptoManager()) {
            navTree.add(new Security(currentUser, this.license));
        }
        if (MenuAuthUtil.isSystemVisible((AdministrativeUser)currentUser)) {
            navTree.add(new System(currentUser, this.license));
        }
        return navTree;
    }
}

