/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal;

import com.pingidentity.admin.api.model.ReplicationStatus;
import com.pingidentity.pf.admin.rest.translator.internal.ClusterNodesTranslator;
import com.pingidentity.util.InitialSetupConfigStore;
import java.util.LinkedList;
import java.util.List;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.service.util.NodeIndexRegistry;

public class ReplicationInfoTranslator {
    private static final String REPLICATION_REQUIRED_ID = "replicationRequired";
    private static final String REPLICATION_FAILURE_ID = "replicationFailure";
    private final AdministrativeUser currentUser;
    private final InitialSetupConfigStore licenseConfigStore = new InitialSetupConfigStore();

    public ReplicationInfoTranslator(AdministrativeUser currentUser) {
        this.currentUser = currentUser;
    }

    public List<String> getReplicationInfo() {
        LinkedList<String> replicationInfo = new LinkedList<String>();
        if (this.currentUser.isAdmin()) {
            if (this.isReplicationFailure()) {
                replicationInfo.add(REPLICATION_FAILURE_ID);
            }
            if (this.isClusterConfigurationStale()) {
                replicationInfo.add(REPLICATION_REQUIRED_ID);
            }
        }
        return replicationInfo;
    }

    private boolean isReplicationFailure() {
        Mediator mediator = MgmtFactory.getMediator();
        if (!mediator.isStandalone() && mediator.isConsole() && this.licenseConfigStore.hasAcceptedLicenseAgreement()) {
            NodeIndexRegistry nodeIndex = (NodeIndexRegistry)GlobalRegistry.getService(NodeIndexRegistry.class);
            return nodeIndex.getNodes().stream().anyMatch(node -> {
                ReplicationStatus replicationStatus = ClusterNodesTranslator.getClusterNodeReplicationStatus(node);
                return ReplicationStatus.FAILED.equals((Object)replicationStatus) || ReplicationStatus.OUT_OF_DATE.equals((Object)replicationStatus);
            });
        }
        return false;
    }

    private boolean isClusterConfigurationStale() {
        Mediator mediator = MgmtFactory.getMediator();
        if (!mediator.isStandalone() && mediator.isConsole() && this.licenseConfigStore.hasAcceptedLicenseAgreement()) {
            mediator.reloadConfigChangeDate();
            return mediator.getClusterReplicationRequiredStatus();
        }
        return false;
    }
}

