/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal;

import com.pingidentity.pf.admin.rest.translator.internal.NavTreeTranslator;
import com.pingidentity.pf.admin.rest.translator.internal.constants.DefaultPreferences;
import com.pingidentity.pf.admin.rest.translator.internal.model.ShortcutIds;
import com.pingidentity.pf.admin.rest.translator.internal.model.ShortcutLink;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.util.license.LicenseManager;

public class UserInfoTranslator {
    public Map<String, List<ShortcutLink>> getAllShortcutsAvailableForUser(AdministrativeUser user) {
        HashMap<String, List<ShortcutLink>> availableShortcutsByParent = new HashMap<String, List<ShortcutLink>>();
        NavTreeTranslator translator = new NavTreeTranslator(LicenseManager.getLicense());
        List<NavNode> primaryNodes = translator.getNavTree(user);
        for (NavNode primaryNode : primaryNodes) {
            ArrayList shortcutLinks = new ArrayList();
            for (NavNode secondaryNode : primaryNode.getChildren()) {
                shortcutLinks.addAll(secondaryNode.getChildren().stream().map(n -> new ShortcutLink(n.getLabel(), secondaryNode.getIcon(), n.getId())).collect(Collectors.toList()));
            }
            availableShortcutsByParent.put(primaryNode.getLabel(), shortcutLinks);
        }
        return availableShortcutsByParent;
    }

    public ShortcutIds getDefaultShortcutsForUser(AdministrativeUser user) {
        return DefaultPreferences.getDefaultShortcutsForUser(user);
    }
}

