/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal;

import com.pingidentity.pf.admin.rest.translator.internal.UserInfoTranslator;
import com.pingidentity.pf.admin.rest.translator.internal.constants.DefaultPreferences;
import com.pingidentity.pf.admin.rest.translator.internal.model.ShortcutIds;
import com.pingidentity.pf.admin.rest.translator.internal.model.ShortcutLink;
import com.pingidentity.pf.admin.rest.translator.internal.model.UserPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.AdminAuthManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.UserPreferencesManager;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.UserKey;
import org.sourceid.saml20.domain.mgmt.impl.UserPreference;

public class UserPreferencesTranslator {
    private final Log log = LogFactory.getLog(this.getClass());

    public UserPreferences getUserShortcutPreferences(AdministrativeUser user) {
        boolean returnDefaultShortcuts;
        ShortcutIds availableShortcutIds;
        UserKey userKey = this.getUserPrefsKey(user);
        UserPreferencesManager userPreferencesManager = MgmtFactory.getUserPreferencesManager();
        UserPreference userPreference = userPreferencesManager.getPreferenceForUser(userKey);
        List shortcuts = userPreference.getShortcuts();
        UserPreferences userPreferences = this.domainToApi(shortcuts, availableShortcutIds = this.getAvailableShortcutIds(user));
        boolean bl = returnDefaultShortcuts = userPreferences.getShortcuts() == null || userPreferences.getShortcuts().getItems() == null || userPreferences.getShortcuts().getItems().size() == 0;
        if (returnDefaultShortcuts) {
            userPreferences.setShortcuts(DefaultPreferences.getDefaultShortcutsForUser(user));
        }
        return userPreferences;
    }

    public UserPreferences saveUserShortcutPreferences(AdministrativeUser user, UserPreferences userPreferences, ShortcutIds availableShortcutIds) {
        UserKey userKey = this.getUserPrefsKey(user);
        UserPreferencesManager userPreferencesManager = MgmtFactory.getUserPreferencesManager();
        UserPreference domainUserPrefs = this.apiToDomain(userKey, userPreferences);
        userPreferencesManager.addUserPreference(domainUserPrefs);
        UserPreference savedUserPreference = userPreferencesManager.getPreferenceForUser(userKey);
        List savedShortcutsForUser = savedUserPreference.getShortcuts();
        return this.domainToApi(savedShortcutsForUser, availableShortcutIds);
    }

    public UserPreference apiToDomain(UserKey userKey, UserPreferences userPreferences) {
        return new UserPreference(userKey, userPreferences.getShortcuts().getItems());
    }

    public UserPreferences domainToApi(List<String> shortcuts, ShortcutIds availableShortcutIds) {
        ArrayList<String> apiUserPreferenceShortcuts = new ArrayList<String>();
        if (shortcuts != null) {
            for (String shortcut : shortcuts) {
                if (availableShortcutIds.getItems().contains(shortcut)) {
                    apiUserPreferenceShortcuts.add(shortcut);
                    continue;
                }
                this.log.debug((Object)("Ignoring configured shortcut not available to user: " + shortcut));
            }
        }
        return new UserPreferences(new ShortcutIds((List<String>)apiUserPreferenceShortcuts));
    }

    private UserKey getUserPrefsKey(AdministrativeUser user) {
        String configuredAuth = AdminAuthManager.getInstance().getAuthMethod();
        return new UserKey(user.getUserName(), configuredAuth, user.isLocalAccount());
    }

    public ShortcutIds getAvailableShortcutIds(AdministrativeUser user) {
        UserInfoTranslator userInfoTranslator = new UserInfoTranslator();
        Map<String, List<ShortcutLink>> availableShortcuts = userInfoTranslator.getAllShortcutsAvailableForUser(user);
        List<String> availableShortcutIds = availableShortcuts.values().stream().flatMap(Collection::stream).map(ShortcutLink::getId).collect(Collectors.toList());
        return new ShortcutIds(availableShortcutIds);
    }
}

