/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal.constants;

import com.pingidentity.pf.admin.rest.translator.internal.model.ShortcutIds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class DefaultPreferences {
    private static final String administrativeAccounts = "administrativeAccounts";
    private static final String trustedCAs = "certificates";
    private static final String sslServerCertificates = "serverCerts";
    private static final String sslClientKeysAndCertificates = "sslClientCerts";
    private static final String signingAndDecryptionKeysAndCertificates = "dsigSigningCerts";
    private static final String idpAdapters = "idpAdapterManager";
    private static final String authnPolicies1 = "authnPolicies1";
    private static final String spConnections = "spConnections";
    private static final String dataStores = "dataSources";
    private static final String credentialValidators = "credentialValidators";
    private static final String onLoadApcToPersistentGrantMappings = "onLoadApcToPersistentGrantMappings";
    private static final String onLoadClientManagement = "onLoadClientManagement";
    private static final String onAccessTokenMapping = "onAccessTokenMapping";
    private static final String onLoadPolicyManagement = "onLoadPolicyManagement";
    private static final String extendedProperties = "extendedProperties";

    private DefaultPreferences() {
    }

    private static List<String> getDefaultUserAdminShortcuts() {
        return Collections.singletonList(administrativeAccounts);
    }

    private static List<String> getDefaultCryptoAdminShortcuts() {
        ArrayList<String> cryptoAdminShortcuts = new ArrayList<String>();
        cryptoAdminShortcuts.add(trustedCAs);
        cryptoAdminShortcuts.add(sslServerCertificates);
        cryptoAdminShortcuts.add(sslClientKeysAndCertificates);
        cryptoAdminShortcuts.add(signingAndDecryptionKeysAndCertificates);
        return cryptoAdminShortcuts;
    }

    public static ShortcutIds getDefaultShortcutsForUser(AdministrativeUser user) {
        List<Object> defaultShortcuts = new ArrayList();
        if (user.hasCryptoAdminRoleOnly()) {
            defaultShortcuts = DefaultPreferences.getDefaultCryptoAdminShortcuts();
        } else if (user.hasUserAdminRoleOnly()) {
            defaultShortcuts = DefaultPreferences.getDefaultUserAdminShortcuts();
        } else if (user.hasUserAndCryptoAdminRolesOnly()) {
            defaultShortcuts = Stream.concat(DefaultPreferences.getDefaultCryptoAdminShortcuts().stream(), DefaultPreferences.getDefaultUserAdminShortcuts().stream()).collect(Collectors.toList());
        } else {
            defaultShortcuts.add(idpAdapters);
            defaultShortcuts.add(authnPolicies1);
            defaultShortcuts.add(onLoadApcToPersistentGrantMappings);
            defaultShortcuts.add(spConnections);
            defaultShortcuts.add(onLoadClientManagement);
            defaultShortcuts.add(onAccessTokenMapping);
            defaultShortcuts.add(onLoadPolicyManagement);
            defaultShortcuts.add(dataStores);
            defaultShortcuts.add(credentialValidators);
            defaultShortcuts.add(extendedProperties);
        }
        return new ShortcutIds((List<String>)defaultShortcuts);
    }
}

