/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal.navigation.system;

import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavNode;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavReactLeaf;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavSecondary;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavTapestryLeaf;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.util.license.PingLicense;

public class ExternalSystems
extends NavSecondary {
    public ExternalSystems(AdministrativeUser currentUser, PingLicense license) {
        super(currentUser, license, "system/external-systems", "External Systems", "pf-system-external-systems");
    }

    @Override
    public List<NavNode> getChildren() {
        ArrayList<NavNode> children = new ArrayList<NavNode>();
        if (this.getCurrentUser().isAdmin() || this.getCurrentUser().isAuditor()) {
            children.add(new NavReactLeaf(this.getCurrentUser(), this.getLicense(), "system/external-systems/pingone-connections", "PingOne Connections"));
        }
        if (this.getCurrentUser().isAdmin() && !MgmtFactory.getPingOneAdminService().isAssociated()) {
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "pingOneSetup", "Connect to PingOne for Enterprise"));
        }
        if (MgmtFactory.getPingOneAdminService().isAssociated()) {
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "pingOneSettings", "PingOne for Enterprise Settings"));
        }
        children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "onLoadCaptchaProviders", "CAPTCHA and Risk Providers"));
        children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "smsProviderSettings", "SMS Provider Settings"));
        children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "notificationSenders", "Notification Publishers"));
        children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "onLoadSecretManagers", "Secret Managers"));
        return children;
    }

    public boolean isReact() {
        return true;
    }
}

