/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal.navigation.system;

import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavNode;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavReactLeaf;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavSecondary;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavTapestryLeaf;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.util.MenuAuthUtil;
import org.sourceid.util.license.PingLicense;

public class Server
extends NavSecondary {
    public Server(AdministrativeUser currentUser, PingLicense license) {
        super(currentUser, license, "server", "Server", "pf-system-server");
    }

    @Override
    public List<NavNode> getChildren() {
        ArrayList<NavNode> children = new ArrayList<NavNode>();
        if (MenuAuthUtil.isPassiveAdminNode()) {
            children.add(new NavReactLeaf(this.getCurrentUser(), this.getLicense(), "system/server/cluster-management", "Cluster Management"));
            return children;
        }
        if (MenuAuthUtil.isAdminVisible((AdministrativeUser)this.getCurrentUser())) {
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "protocolSettings", "Protocol Settings"));
        }
        if (MenuAuthUtil.isAcctManagementVisible((AdministrativeUser)this.getCurrentUser())) {
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "administrativeAccounts", "Administrative Accounts"));
        }
        children.add(new NavReactLeaf(this.getCurrentUser(), this.getLicense(), "system/server/license", "License"));
        if (MenuAuthUtil.isAdminFunctionsVisible((AdministrativeUser)this.getCurrentUser())) {
            if (MenuAuthUtil.isAuthorizedForConfigurationArchiveManagement((AdministrativeUser)this.getCurrentUser())) {
                children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "miscConfigUtils", "Configuration Archive"));
            }
            if (!MgmtFactory.getMediator().isStandalone() && MenuAuthUtil.isAdminVisible((AdministrativeUser)this.getCurrentUser())) {
                children.add(new NavReactLeaf(this.getCurrentUser(), this.getLicense(), "system/server/cluster-management", "Cluster Management"));
            }
            if (MenuAuthUtil.isAdminVisible((AdministrativeUser)this.getCurrentUser())) {
                children.add(new NavReactLeaf(this.getCurrentUser(), this.getLicense(), "system/server/virtual-hostnames", "Virtual Host Names"));
                children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "extendedProperties", "Extended Properties"));
                if (MgmtFactory.getLogSettingsManager().isShowLogSettingsPage()) {
                    children.add(new NavReactLeaf(this.getCurrentUser(), this.getLicense(), "system/server/log-settings", "Log Settings"));
                }
                children.add(new NavReactLeaf(this.getCurrentUser(), this.getLicense(), "system/server/audit-log-settings", "Audit Log Settings"));
                children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "generalSettings", "General Settings"));
            }
            if (MenuAuthUtil.isCollectSupportDataVisible((AdministrativeUser)this.getCurrentUser())) {
                children.add(new NavReactLeaf(this.getCurrentUser(), this.getLicense(), "system/server/collect-support-data", "Collect Support Data"));
            }
        }
        return children;
    }
}

