/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.localidentity;

import com.pingidentity.admin.api.model.localidentity.CheckboxGroupLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.CheckboxLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.DateLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.DropDownLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.EmailLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.HiddenLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.LocalIdentityFieldType;
import com.pingidentity.admin.api.model.localidentity.PhoneLocalIdentityField;
import com.pingidentity.admin.api.model.localidentity.TextLocalIdentityField;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.localidentity.fieldtypes.CheckboxField;
import com.pingidentity.localidentity.fieldtypes.CheckboxGroupField;
import com.pingidentity.localidentity.fieldtypes.DateField;
import com.pingidentity.localidentity.fieldtypes.DropDownField;
import com.pingidentity.localidentity.fieldtypes.EmailField;
import com.pingidentity.localidentity.fieldtypes.HiddenField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldData;
import com.pingidentity.localidentity.fieldtypes.PhoneField;
import com.pingidentity.localidentity.fieldtypes.TextField;
import java.util.ArrayList;
import java.util.List;

public class LocalIdentityFieldConfigTranslator {
    public com.pingidentity.admin.api.model.localidentity.FieldConfig domainToApi(FieldConfig domainFieldConfig) {
        com.pingidentity.admin.api.model.localidentity.FieldConfig apiFieldConfig = new com.pingidentity.admin.api.model.localidentity.FieldConfig();
        ArrayList<com.pingidentity.admin.api.model.localidentity.LocalIdentityField> apiFields = new ArrayList<com.pingidentity.admin.api.model.localidentity.LocalIdentityField>();
        apiFieldConfig.setFields(apiFields);
        for (LocalIdentityField domainField : domainFieldConfig.getListOfAllFields()) {
            if (domainField.getData() == null) continue;
            apiFields.add(this.translateDomToApiField(domainField));
        }
        return apiFieldConfig;
    }

    public FieldConfig apiToDomain(com.pingidentity.admin.api.model.localidentity.FieldConfig apiFieldConfig) {
        FieldConfig domainFieldConfig = new FieldConfig();
        ArrayList<LocalIdentityField> domainFields = new ArrayList<LocalIdentityField>();
        domainFieldConfig.setFieldList(domainFields);
        for (com.pingidentity.admin.api.model.localidentity.LocalIdentityField apiLocalIdentityField : apiFieldConfig.getFields()) {
            domainFields.add(this.translateApiToDomField(apiLocalIdentityField));
        }
        return domainFieldConfig;
    }

    private com.pingidentity.admin.api.model.localidentity.LocalIdentityField translateDomToApiField(LocalIdentityField domainField) {
        com.pingidentity.admin.api.model.localidentity.LocalIdentityField apiField;
        switch (domainField.getName()) {
            case "Email": {
                apiField = new EmailLocalIdentityField();
                break;
            }
            case "Checkbox": {
                apiField = new CheckboxLocalIdentityField();
                ((CheckboxLocalIdentityField)apiField).setDefaultValue(domainField.getData().getDefaultValue());
                break;
            }
            case "Checkbox Group": {
                apiField = new CheckboxGroupLocalIdentityField();
                ((CheckboxGroupLocalIdentityField)apiField).setOptions(domainField.getData().getOptions());
                break;
            }
            case "Date": {
                apiField = new DateLocalIdentityField();
                ((DateLocalIdentityField)apiField).setDefaultValue(domainField.getData().getDefaultValue());
                break;
            }
            case "Dropdown": {
                apiField = new DropDownLocalIdentityField();
                ((DropDownLocalIdentityField)apiField).setDefaultValue(domainField.getData().getDefaultValue());
                ((DropDownLocalIdentityField)apiField).setOptions(domainField.getData().getOptions());
                break;
            }
            case "Phone": {
                apiField = new PhoneLocalIdentityField();
                break;
            }
            case "Text": {
                apiField = new TextLocalIdentityField();
                ((TextLocalIdentityField)apiField).setDefaultValue(domainField.getData().getDefaultValue());
                break;
            }
            case "Hidden": {
                apiField = new HiddenLocalIdentityField();
                break;
            }
            default: {
                apiField = new com.pingidentity.admin.api.model.localidentity.LocalIdentityField();
            }
        }
        apiField.setType(this.translateDomToApiFieldType(domainField.getName()));
        apiField.setId(domainField.getData().getId());
        apiField.setLabel(domainField.getData().getLabel());
        apiField.setProfilePageField(domainField.getData().isProfilePageField());
        apiField.setRegistrationPageField(domainField.getData().isRegistrationPageField());
        apiField.setAttributes(domainField.getAttributes());
        return apiField;
    }

    private LocalIdentityFieldType translateDomToApiFieldType(String name) {
        switch (name) {
            case "Email": {
                return LocalIdentityFieldType.EMAIL;
            }
            case "Checkbox": {
                return LocalIdentityFieldType.CHECKBOX;
            }
            case "Checkbox Group": {
                return LocalIdentityFieldType.CHECKBOX_GROUP;
            }
            case "Date": {
                return LocalIdentityFieldType.DATE;
            }
            case "Dropdown": {
                return LocalIdentityFieldType.DROP_DOWN;
            }
            case "Phone": {
                return LocalIdentityFieldType.PHONE;
            }
            case "Text": {
                return LocalIdentityFieldType.TEXT;
            }
            case "Hidden": {
                return LocalIdentityFieldType.HIDDEN;
            }
        }
        return null;
    }

    private LocalIdentityField translateApiToDomField(com.pingidentity.admin.api.model.localidentity.LocalIdentityField apiLocalIdentityField) {
        DateField domainLocalIdentityField = null;
        String defaultValue = "";
        List<Object> options = new ArrayList();
        switch (apiLocalIdentityField.getType()) {
            case DATE: {
                defaultValue = ((DateLocalIdentityField)apiLocalIdentityField).getDefaultValue();
                break;
            }
            case TEXT: {
                defaultValue = ((TextLocalIdentityField)apiLocalIdentityField).getDefaultValue();
                break;
            }
            case EMAIL: {
                break;
            }
            case PHONE: {
                break;
            }
            case CHECKBOX: {
                defaultValue = ((CheckboxLocalIdentityField)apiLocalIdentityField).getDefaultValue();
                break;
            }
            case DROP_DOWN: {
                defaultValue = ((DropDownLocalIdentityField)apiLocalIdentityField).getDefaultValue();
                defaultValue = defaultValue == null ? "" : defaultValue;
                options = ((DropDownLocalIdentityField)apiLocalIdentityField).getOptions();
                break;
            }
            case CHECKBOX_GROUP: {
                options = ((CheckboxGroupLocalIdentityField)apiLocalIdentityField).getOptions();
                break;
            }
            case HIDDEN: {
                break;
            }
        }
        LocalIdentityFieldData domainLocalIdentityFieldData = new LocalIdentityFieldData(apiLocalIdentityField.getId(), apiLocalIdentityField.getLabel(), defaultValue, apiLocalIdentityField.getAttributes(), options, apiLocalIdentityField.isRegistrationPageField(), apiLocalIdentityField.isProfilePageField());
        switch (apiLocalIdentityField.getType()) {
            case DATE: {
                domainLocalIdentityField = new DateField(domainLocalIdentityFieldData);
                break;
            }
            case TEXT: {
                domainLocalIdentityField = new TextField(domainLocalIdentityFieldData);
                break;
            }
            case EMAIL: {
                domainLocalIdentityField = new EmailField(domainLocalIdentityFieldData);
                break;
            }
            case PHONE: {
                domainLocalIdentityField = new PhoneField(domainLocalIdentityFieldData);
                break;
            }
            case CHECKBOX: {
                domainLocalIdentityField = new CheckboxField(domainLocalIdentityFieldData);
                break;
            }
            case DROP_DOWN: {
                domainLocalIdentityField = new DropDownField(domainLocalIdentityFieldData);
                break;
            }
            case CHECKBOX_GROUP: {
                domainLocalIdentityField = new CheckboxGroupField(domainLocalIdentityFieldData);
                break;
            }
            case HIDDEN: {
                domainLocalIdentityField = new HiddenField(domainLocalIdentityFieldData);
                break;
            }
        }
        return domainLocalIdentityField;
    }
}

