/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.localidentity;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.localidentity.LocalIdentityAuthSource;
import com.pingidentity.admin.api.model.localidentity.LocalIdentityAuthSourceUpdatePolicy;
import com.pingidentity.admin.api.model.localidentity.ProfileConfig;
import com.pingidentity.admin.api.model.localidentity.RegistrationConfig;
import com.pingidentity.localidentity.EmailVerificationConfig;
import com.pingidentity.localidentity.ExecuteWorkflowSetting;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.attrupdates.AuthSourceUpdatePolicy;
import com.pingidentity.localidentity.attrupdates.AuthSourceUpdatePolicyImpl;
import com.pingidentity.localidentity.attrupdates.DefaultAuthSourceUpdatePolicy;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSourceImpl;
import com.pingidentity.localidentity.type.DefaultEmailVerificationConfig;
import com.pingidentity.pf.admin.rest.translator.localidentity.LocalIdentityDataStoreConfigTranslator;
import com.pingidentity.pf.admin.rest.translator.localidentity.LocalIdentityEmailVerificationConfigTranslator;
import com.pingidentity.pf.admin.rest.translator.localidentity.LocalIdentityFieldConfigTranslator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class LocalIdentityProfileTranslator {
    public com.pingidentity.admin.api.model.localidentity.LocalIdentityProfile domainToApi(LocalIdentityProfile domainObject) {
        com.pingidentity.admin.api.model.localidentity.LocalIdentityProfile apiObject = new com.pingidentity.admin.api.model.localidentity.LocalIdentityProfile();
        apiObject.setId(domainObject.getId());
        apiObject.setName(domainObject.getName());
        apiObject.setApcId(new ResourceLink(domainObject.getContractId(), ApiUtil.getResourceUrl("/authenticationPolicyContracts", domainObject.getContractId())));
        apiObject.setAuthSources(this.translatedDomToApiLocIdentityAuthSources(domainObject.getAuthSources()));
        apiObject.setAuthSourceUpdatePolicy(this.getTranslatedUpdatePolicy(domainObject.getAuthSources()));
        apiObject.setRegistrationEnabled(domainObject.isRegistrationEnabled());
        apiObject.setProfileEnabled(domainObject.isProfileEnabled());
        if (!apiObject.isProfileEnabled() && !apiObject.isRegistrationEnabled()) {
            apiObject.setAuthSourceUpdatePolicy(null);
        }
        if (domainObject.getRegistrationConfig() != null) {
            apiObject.setRegistrationConfig(this.translateDomToApiRegistrationConfig(domainObject.getRegistrationConfig()));
        }
        if (domainObject.getProfileConfig() != null) {
            apiObject.setProfileConfig(this.translateDomToApiProfileConfig(domainObject.getProfileConfig()));
        }
        if (domainObject.getFieldConfig() != null) {
            apiObject.setFieldConfig(this.translateDomToApiFieldConfig(domainObject.getFieldConfig()));
        }
        if (domainObject.getEmailOwnershipVerificationConfig() != null && (domainObject.isRegistrationEnabled() || domainObject.isProfileEnabled())) {
            apiObject.setEmailVerificationConfig(this.translateDomToApiEmailVerificationConfig(domainObject.getEmailOwnershipVerificationConfig()));
        }
        if (domainObject.getDataStoreConfig() != null) {
            LocalIdentityDataStoreConfigTranslator dataStoreConfigTranslator = new LocalIdentityDataStoreConfigTranslator();
            apiObject.setDataStoreConfig(dataStoreConfigTranslator.domainToApi(domainObject.getDataStoreConfig()));
        }
        return apiObject;
    }

    private LocalIdentityAuthSourceUpdatePolicy getTranslatedUpdatePolicy(List<com.pingidentity.localidentity.authsource.LocalIdentityAuthSource> authSources) {
        Object domainUpdatePolicy = authSources == null || authSources.isEmpty() ? new DefaultAuthSourceUpdatePolicy() : authSources.get(0).getUpdatePolicy();
        LocalIdentityAuthSourceUpdatePolicy apiUpdatePolicy = new LocalIdentityAuthSourceUpdatePolicy();
        apiUpdatePolicy.setStoreAttributes(domainUpdatePolicy.isStoreAttributes());
        apiUpdatePolicy.setRetainAttributes(domainUpdatePolicy.isRetainAttributes());
        apiUpdatePolicy.setUpdateAttributes(domainUpdatePolicy.isUpdateAttributes());
        apiUpdatePolicy.setUpdateInterval(domainUpdatePolicy.getUpdateInterval());
        return apiUpdatePolicy;
    }

    public LocalIdentityProfile apiToDomain(com.pingidentity.admin.api.model.localidentity.LocalIdentityProfile apiObject, List<com.pingidentity.localidentity.authsource.LocalIdentityAuthSource> domAuthSources) {
        LocalIdentityProfile domainObject = new LocalIdentityProfile();
        domainObject.setId(apiObject.getId());
        domainObject.setName(apiObject.getName());
        domainObject.setContractId(apiObject.getApcId().getId());
        LocalIdentityAuthSourceUpdatePolicy updatePolicy = apiObject.getAuthSourceUpdatePolicy();
        domainObject.setAuthSources(this.translateApiToDomainLocIdentityAuthSources(apiObject.getAuthSources(), updatePolicy, domAuthSources));
        domainObject.setRegistrationEnabled(apiObject.isRegistrationEnabled());
        domainObject.setProfileEnabled(apiObject.isProfileEnabled());
        if (this.doTranslateRegistrationConfig(apiObject.isRegistrationEnabled()) && apiObject.getRegistrationConfig() != null) {
            domainObject.setRegistrationConfig(this.translateApiToDomainRegistrationConfig(apiObject.getRegistrationConfig()));
        }
        if (this.doTranslateProfileConfig(apiObject.isProfileEnabled()) && apiObject.getProfileConfig() != null) {
            domainObject.setProfileConfig(this.translateApiToDomainProfileConfig(apiObject.getProfileConfig()));
        }
        if (this.doTranslateFieldConfig(apiObject.isRegistrationEnabled(), apiObject.isProfileEnabled()) && apiObject.getFieldConfig() != null) {
            domainObject.setFieldConfig(this.translateApiToDomainFieldConfig(apiObject.getFieldConfig()));
        }
        if (this.doTranslateEmailVerifConfig(apiObject.isRegistrationEnabled(), apiObject.isProfileEnabled(), apiObject.getEmailVerificationConfig())) {
            domainObject.setEmailOwnershipVerificationConfig(this.translateApiToDomEmailVerificationConfig(apiObject.getEmailVerificationConfig()));
        } else {
            domainObject.setEmailOwnershipVerificationConfig((EmailVerificationConfig)new DefaultEmailVerificationConfig());
        }
        if (this.doTranslateDataStoreConfig(apiObject.isRegistrationEnabled(), apiObject.isProfileEnabled()) && apiObject.getDataStoreConfig() != null) {
            LocalIdentityDataStoreConfigTranslator dataStoreConfigTranslator = new LocalIdentityDataStoreConfigTranslator();
            domainObject.setDataStoreConfig(dataStoreConfigTranslator.apiToDomain(apiObject.getDataStoreConfig()));
        }
        return domainObject;
    }

    private List<LocalIdentityAuthSource> translatedDomToApiLocIdentityAuthSources(List<com.pingidentity.localidentity.authsource.LocalIdentityAuthSource> domainAuthSources) {
        ArrayList<LocalIdentityAuthSource> apiSources = new ArrayList<LocalIdentityAuthSource>();
        if (domainAuthSources != null && !domainAuthSources.isEmpty()) {
            for (com.pingidentity.localidentity.authsource.LocalIdentityAuthSource domainAuthSource : domainAuthSources) {
                apiSources.add(new LocalIdentityAuthSource(domainAuthSource.getId(), domainAuthSource.getSource()));
            }
        }
        return apiSources;
    }

    private RegistrationConfig translateDomToApiRegistrationConfig(com.pingidentity.localidentity.RegistrationConfig domRegConfig) {
        RegistrationConfig apiRegistrationConfig = new RegistrationConfig();
        apiRegistrationConfig.setCaptchaEnabled(domRegConfig.isCaptchaEnabled());
        if (domRegConfig.isCaptchaEnabled() && StringUtils.isNotBlank((String)domRegConfig.getCaptchaProviderId())) {
            ResourceLink captchaProviderResourceLink = new ResourceLink();
            captchaProviderResourceLink.setId(domRegConfig.getCaptchaProviderId());
            captchaProviderResourceLink.setLocation(ApiUtil.getResourceUrl("/captchaProviders", domRegConfig.getCaptchaProviderId()));
            apiRegistrationConfig.setCaptchaProviderRef(captchaProviderResourceLink);
        }
        apiRegistrationConfig.setTemplateName(domRegConfig.getTemplateName());
        apiRegistrationConfig.setThisIsMyDeviceEnabled(domRegConfig.isThisIsMyDeviceEnabled());
        apiRegistrationConfig.setCreateAuthnSessionAfterRegistration(domRegConfig.isCreateSessionAfterRegistration());
        if (domRegConfig.isCreateSessionAfterRegistration() && StringUtils.isNotBlank((String)domRegConfig.getFieldForUsername())) {
            apiRegistrationConfig.setUsernameField(domRegConfig.getFieldForUsername());
        }
        if (StringUtils.isNotBlank((String)domRegConfig.getRegistrationWorkflowFragmentId())) {
            apiRegistrationConfig.setRegistrationWorkflow(new ResourceLink(domRegConfig.getRegistrationWorkflowFragmentId(), ApiUtil.getResourceUrl("/authenticationPolicies/fragments", domRegConfig.getRegistrationWorkflowFragmentId())));
            ExecuteWorkflowSetting executeWorkflowSetting = domRegConfig.getExecuteWorkflowSetting();
            if (executeWorkflowSetting == null) {
                executeWorkflowSetting = ExecuteWorkflowSetting.AFTER_ACCOUNT_CREATION;
            }
            apiRegistrationConfig.setExecuteWorkflow(executeWorkflowSetting);
        }
        return apiRegistrationConfig;
    }

    private ProfileConfig translateDomToApiProfileConfig(com.pingidentity.localidentity.ProfileConfig domProfileConfig) {
        ProfileConfig apiProfileConfig = new ProfileConfig();
        apiProfileConfig.setDeleteIdentityEnabled(domProfileConfig.isDeleteIdentityEnabled());
        apiProfileConfig.setTemplateName(domProfileConfig.getTemplateName());
        return apiProfileConfig;
    }

    private List<com.pingidentity.localidentity.authsource.LocalIdentityAuthSource> translateApiToDomainLocIdentityAuthSources(List<LocalIdentityAuthSource> apiSources, LocalIdentityAuthSourceUpdatePolicy apiUpdatePolicy, List<com.pingidentity.localidentity.authsource.LocalIdentityAuthSource> currentDomainAuthSources) {
        ArrayList<com.pingidentity.localidentity.authsource.LocalIdentityAuthSource> newDomainSources = new ArrayList<com.pingidentity.localidentity.authsource.LocalIdentityAuthSource>();
        AuthSourceUpdatePolicy updatePolicy = this.translateApiToDomainUpdatePolicy(apiUpdatePolicy);
        if (apiSources != null && !apiSources.isEmpty()) {
            for (LocalIdentityAuthSource apiSource : apiSources) {
                if (StringUtils.isBlank((String)apiSource.getSource())) continue;
                String id = apiSource.getId();
                newDomainSources.add((com.pingidentity.localidentity.authsource.LocalIdentityAuthSource)new LocalIdentityAuthSourceImpl(id, apiSource.getSource(), updatePolicy));
            }
        }
        return newDomainSources;
    }

    private AuthSourceUpdatePolicy translateApiToDomainUpdatePolicy(LocalIdentityAuthSourceUpdatePolicy apiUpdatePolicy) {
        if (apiUpdatePolicy == null) {
            return new DefaultAuthSourceUpdatePolicy();
        }
        return new AuthSourceUpdatePolicyImpl(apiUpdatePolicy.isStoreAttributes(), apiUpdatePolicy.isRetainAttributes(), apiUpdatePolicy.isUpdateAttributes(), apiUpdatePolicy.getUpdateInterval());
    }

    private long getIntervalInSeconds(Double updateInterval) {
        if (updateInterval == null) {
            return 0L;
        }
        Double updateIntervalInSeconds = updateInterval * 24.0 * 60.0 * 60.0;
        return updateIntervalInSeconds.longValue();
    }

    private com.pingidentity.localidentity.RegistrationConfig translateApiToDomainRegistrationConfig(RegistrationConfig apiRegConfig) {
        com.pingidentity.localidentity.RegistrationConfig domainRegConfig = new com.pingidentity.localidentity.RegistrationConfig();
        domainRegConfig.setCaptchaEnabled(apiRegConfig.isCaptchaEnabled());
        domainRegConfig.setCaptchaProviderId(apiRegConfig.getCaptchaProviderRef() == null ? null : apiRegConfig.getCaptchaProviderRef().getId());
        domainRegConfig.setTemplateName(apiRegConfig.getTemplateName());
        domainRegConfig.setCreateSessionAfterRegistration(apiRegConfig.isCreateAuthnSessionAfterRegistration());
        domainRegConfig.setFieldForUsername(apiRegConfig.getUsernameField());
        domainRegConfig.setThisIsMyDeviceEnabled(apiRegConfig.isThisIsMyDeviceEnabled());
        if (apiRegConfig.getRegistrationWorkflow() != null) {
            domainRegConfig.setRegistrationWorkflowFragmentId(apiRegConfig.getRegistrationWorkflow().getId());
            ExecuteWorkflowSetting executeWorkflowSetting = apiRegConfig.getExecuteWorkflow();
            if (executeWorkflowSetting == null) {
                executeWorkflowSetting = com.pingidentity.localidentity.RegistrationConfig.DEFAULT_EXECUTE_WORKFLOW;
            }
            domainRegConfig.setExecuteWorkflowSetting(executeWorkflowSetting.getName());
        }
        return domainRegConfig;
    }

    private com.pingidentity.localidentity.ProfileConfig translateApiToDomainProfileConfig(ProfileConfig apiProfileConfig) {
        com.pingidentity.localidentity.ProfileConfig domainProfileConfig = new com.pingidentity.localidentity.ProfileConfig();
        domainProfileConfig.setDeleteIdentityEnabled(apiProfileConfig.isDeleteIdentityEnabled());
        domainProfileConfig.setTemplateName(apiProfileConfig.getTemplateName());
        return domainProfileConfig;
    }

    private com.pingidentity.admin.api.model.localidentity.FieldConfig translateDomToApiFieldConfig(FieldConfig domainFieldConfig) {
        com.pingidentity.admin.api.model.localidentity.FieldConfig apiFieldConfig = new LocalIdentityFieldConfigTranslator().domainToApi(domainFieldConfig);
        apiFieldConfig.setStripSpaceFromUniqueField(domainFieldConfig.isStripSpaceFromUniqueField());
        return apiFieldConfig;
    }

    private FieldConfig translateApiToDomainFieldConfig(com.pingidentity.admin.api.model.localidentity.FieldConfig apiFieldConfig) {
        FieldConfig domainFieldConfig = new LocalIdentityFieldConfigTranslator().apiToDomain(apiFieldConfig);
        domainFieldConfig.setStripSpaceFromUniqueField(apiFieldConfig.isStripSpaceFromUniqueField());
        return domainFieldConfig;
    }

    private com.pingidentity.admin.api.model.localidentity.EmailVerificationConfig translateDomToApiEmailVerificationConfig(EmailVerificationConfig domEmailVerifConfig) {
        return new LocalIdentityEmailVerificationConfigTranslator().domainToApi(domEmailVerifConfig);
    }

    private EmailVerificationConfig translateApiToDomEmailVerificationConfig(com.pingidentity.admin.api.model.localidentity.EmailVerificationConfig apiEmailVerifConfig) {
        return new LocalIdentityEmailVerificationConfigTranslator().apiToDomain(apiEmailVerifConfig);
    }

    private boolean doTranslateFieldConfig(boolean isRegistrationEnabled, boolean isProfileEnabled) {
        return isRegistrationEnabled || isProfileEnabled;
    }

    private boolean doTranslateDataStoreConfig(boolean isRegistrationEnabled, boolean isProfileEnabled) {
        return isRegistrationEnabled || isProfileEnabled;
    }

    private boolean doTranslateRegistrationConfig(boolean isRegistrationEnabled) {
        return isRegistrationEnabled;
    }

    private boolean doTranslateProfileConfig(boolean isProfileEnabled) {
        return isProfileEnabled;
    }

    private boolean doTranslateEmailVerifConfig(boolean registrationEnabled, boolean profileEnabled, com.pingidentity.admin.api.model.localidentity.EmailVerificationConfig emailVerificationConfig) {
        return (registrationEnabled || profileEnabled) && emailVerificationConfig != null;
    }
}

