/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.IdpAdapterMapping;
import com.pingidentity.admin.api.model.oauth.IdpAdapterMappings;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthIdpAdapterMappingTranslator {
    public IdpAdapterMappings domainToApi(Collection<PluginToUserKeyAttrMapping> domainIdpMappings) {
        ArrayList<IdpAdapterMapping> apiIdpMappings = new ArrayList<IdpAdapterMapping>();
        for (PluginToUserKeyAttrMapping idpMapping : domainIdpMappings) {
            IdpAdapterMapping apiClient = this.domainToApi(idpMapping);
            apiIdpMappings.add(apiClient);
        }
        return new IdpAdapterMappings(apiIdpMappings);
    }

    public IdpAdapterMapping domainToApi(PluginToUserKeyAttrMapping domainAttrMapping) {
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        IdpAdapterMapping apiAdapterMapping = new IdpAdapterMapping();
        apiAdapterMapping.setId(domainAttrMapping.getSourcePluginId());
        HashSet<String> validAttributeContract = MgmtFactory.getAuthzServerManager().getKeyNameContract() == null ? new HashSet() : MgmtFactory.getAuthzServerManager().getKeyNameContract().getAllAttributeNames();
        attributeMappingTranslator.domainToApi((AttributeMapping)domainAttrMapping, apiAdapterMapping, validAttributeContract, false);
        ResourceLink resourceId = new ResourceLink();
        resourceId.setId(domainAttrMapping.getSourcePluginId());
        resourceId.setLocation(ApiUtil.getResourceUrl("/idp/adapters", domainAttrMapping.getSourcePluginId()));
        apiAdapterMapping.setIdpAdapterRef(resourceId);
        return apiAdapterMapping;
    }

    public PluginToUserKeyAttrMapping apiToDomain(IdpAdapterMapping apiMapping) {
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        PluginToUserKeyAttrMapping domainMapping = new PluginToUserKeyAttrMapping(authzServerManager.getKeyNameContract());
        attributeMappingTranslator.apiToDomain(apiMapping, (AttributeMapping)domainMapping);
        domainMapping.setSourcePluginId(apiMapping.getId());
        return domainMapping;
    }
}

