/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.ProcessorPolicyToPersistentGrantMapping;
import com.pingidentity.admin.api.model.oauth.ProcessorPolicyToPersistentGrantMappings;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.TeppToUserKeyAttrMapping;
import org.sourceid.saml20.domain.AttributeMapping;

public class OAuthTeppMappingTranslator {
    private final AuthzServerManager authzServerManager;

    public OAuthTeppMappingTranslator(AuthzServerManager authzServerManager) {
        this.authzServerManager = authzServerManager;
    }

    public ProcessorPolicyToPersistentGrantMappings domainToApi(Collection<TeppToUserKeyAttrMapping> domainTeppMappings) {
        ArrayList<ProcessorPolicyToPersistentGrantMapping> apiTeppMappings = new ArrayList<ProcessorPolicyToPersistentGrantMapping>();
        for (TeppToUserKeyAttrMapping teppMapping : domainTeppMappings) {
            ProcessorPolicyToPersistentGrantMapping apiMapping = this.domainToApi(teppMapping);
            apiTeppMappings.add(apiMapping);
        }
        return new ProcessorPolicyToPersistentGrantMappings(apiTeppMappings);
    }

    public ProcessorPolicyToPersistentGrantMapping domainToApi(TeppToUserKeyAttrMapping domainAttrMapping) {
        ProcessorPolicyToPersistentGrantMapping apiTeppMapping = new ProcessorPolicyToPersistentGrantMapping();
        apiTeppMapping.setId(domainAttrMapping.getTeppId());
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        HashSet<String> validAttributeContract = this.authzServerManager.getKeyNameContract() == null ? new HashSet() : this.authzServerManager.getKeyNameContract().getAllAttributeNames();
        attributeMappingTranslator.domainToApi((AttributeMapping)domainAttrMapping, apiTeppMapping, validAttributeContract, false);
        ResourceLink resourceId = new ResourceLink();
        resourceId.setId(domainAttrMapping.getTeppId());
        resourceId.setLocation(ApiUtil.getResourceUrl("/oauth/tokenExchange/processor/policies", domainAttrMapping.getTeppId()));
        apiTeppMapping.setProcessorPolicyRef(resourceId);
        return apiTeppMapping;
    }

    public TeppToUserKeyAttrMapping apiToDomain(ProcessorPolicyToPersistentGrantMapping apiMapping) {
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        TeppToUserKeyAttrMapping domainMapping = new TeppToUserKeyAttrMapping(this.authzServerManager.getKeyNameContract());
        attributeMappingTranslator.apiToDomain(apiMapping, (AttributeMapping)domainMapping);
        domainMapping.setTeppId(apiMapping.getProcessorPolicyRef().getId());
        return domainMapping;
    }
}

