/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth.exchange;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeGeneratorGroup;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeGeneratorMapping;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicy;

public final class TokenExchangeGeneratorGroupTranslator {
    public Function<TokenExchangeGeneratorPolicy, TokenExchangeGeneratorGroup> toApi() {
        return domain -> {
            TokenExchangeGeneratorGroup api = new TokenExchangeGeneratorGroup();
            api.setId(domain.getId());
            api.setName(domain.getName());
            api.setResourceUris(domain.getResourceUris());
            api.setGeneratorMappings(domain.getMappings().stream().map(domainMapping -> {
                TokenExchangeGeneratorMapping apiMapping = new TokenExchangeGeneratorMapping();
                apiMapping.setDefaultMapping(domain.getDefaultTokenType().equals(domainMapping.getTokenType()));
                apiMapping.setRequestedTokenType(domainMapping.getTokenType());
                apiMapping.setTokenGenerator(this.getTokenGeneratorResourceLink((org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorMapping)domainMapping));
                return apiMapping;
            }).collect(Collectors.toList()));
            return api;
        };
    }

    public Function<TokenExchangeGeneratorGroup, TokenExchangeGeneratorPolicy> toDomain() {
        return api -> {
            TokenExchangeGeneratorPolicy domain = new TokenExchangeGeneratorPolicy();
            domain.setId(api.getId());
            domain.setName(api.getName());
            domain.setResourceUris(api.getResourceUris());
            for (TokenExchangeGeneratorMapping apiMapping : api.getGeneratorMappings()) {
                if (apiMapping.isDefaultMapping()) {
                    domain.setDefaultTokenType(apiMapping.getRequestedTokenType());
                }
                org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorMapping domainMapping = new org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorMapping();
                domainMapping.setTokenType(apiMapping.getRequestedTokenType());
                if (apiMapping.getTokenGenerator() != null) {
                    domainMapping.setTokenGeneratorId(apiMapping.getTokenGenerator().getId());
                }
                domain.addMapping(domainMapping);
            }
            return domain;
        };
    }

    private ResourceLink getTokenGeneratorResourceLink(org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorMapping domainMapping) {
        String tokenGeneratorId = domainMapping.getTokenGeneratorId();
        String resourceUrl = ApiUtil.getResourceUrl("/sp/tokenGenerators", tokenGeneratorId);
        return new ResourceLink(tokenGeneratorId, resourceUrl);
    }
}

