/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.plugin;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.plugin.AccessTokenAttribute;
import com.pingidentity.admin.api.model.plugin.AccessTokenManager;
import com.pingidentity.admin.api.model.plugin.TokenEndpointAttribute;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.PluginInstanceValidator;
import com.pingidentity.pf.admin.rest.translator.plugin.PluginInstanceTranslator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.TokenEndpointAttributeContract;

public class AccessTokenManagerTranslator
extends PluginInstanceTranslator {
    public BearerAccessTokenMgmtPluginInstance apiToDomain(AccessTokenManager apiInstance, PluginInstanceValidator validator) {
        HashSet<String> domainMultiValuedAttrs;
        BearerAccessTokenMgmtPluginInstance domainInstance = (BearerAccessTokenMgmtPluginInstance)this.apiToDomain(apiInstance, validator, PluginEnum.ACCESS_TOKEN_MANAGER);
        if (apiInstance.getAttributeContract() != null) {
            if (this.getBooleanVal(apiInstance.getAttributeContract().isInherited())) {
                domainInstance.setInheritingExtendedContractAttributes(true);
            } else {
                HashSet<String> domainExtAttrs = new HashSet<String>();
                domainMultiValuedAttrs = new HashSet<String>();
                for (AccessTokenAttribute accessTokenAttribute : apiInstance.getAttributeContract().getExtendedAttributes()) {
                    if (accessTokenAttribute.isMultiValued()) {
                        domainMultiValuedAttrs.add(accessTokenAttribute.getName());
                    }
                    domainExtAttrs.add(accessTokenAttribute.getName());
                }
                domainInstance.setExtendedContractAttributes(domainExtAttrs);
                domainInstance.setMultiValuedContractAttributes(domainMultiValuedAttrs);
                domainInstance.setDefaultSubjectAttribute(apiInstance.getAttributeContract().getDefaultSubjectAttribute());
            }
        }
        if (apiInstance.getTokenEndpointAttributeContract() != null) {
            if (apiInstance.getTokenEndpointAttributeContract().getInherited()) {
                domainInstance.setInheritTokenEndpointAttributeContract(true);
            } else {
                HashSet<String> domainAttrs = new HashSet<String>();
                domainMultiValuedAttrs = new HashSet();
                HashMap<String, Set<String>> domainMappedScopes = new HashMap<String, Set<String>>();
                for (TokenEndpointAttribute apiAttr : apiInstance.getTokenEndpointAttributeContract().getAttributes()) {
                    domainAttrs.add(apiAttr.getName());
                    if (apiAttr.isMultiValued()) {
                        domainMultiValuedAttrs.add(apiAttr.getName());
                    }
                    domainMappedScopes.put(apiAttr.getName(), apiAttr.getMappedScopes());
                }
                TokenEndpointAttributeContract tokenEndpointAttributeContract = new TokenEndpointAttributeContract();
                tokenEndpointAttributeContract.setMutableAttributeNames(domainAttrs);
                tokenEndpointAttributeContract.setMultiValued(domainMultiValuedAttrs);
                tokenEndpointAttributeContract.setMappedScopes(domainMappedScopes);
                domainInstance.setTokenEndpointAttributeContract(tokenEndpointAttributeContract);
            }
        }
        if (apiInstance.getSelectionSettings() != null) {
            if (this.getBooleanVal(apiInstance.getSelectionSettings().isInherited())) {
                domainInstance.setInheritSelectionSettings(true);
            } else if (apiInstance.getSelectionSettings().getResourceUris() != null) {
                domainInstance.setOwnResourceUris(apiInstance.getSelectionSettings().getResourceUris());
            }
        }
        if (apiInstance.getAccessControlSettings() != null) {
            if (this.getBooleanVal(apiInstance.getAccessControlSettings().isInherited())) {
                domainInstance.setInheritAccessControlSettings(true);
            } else {
                domainInstance.setOwnRestrictClients(apiInstance.getAccessControlSettings().isRestrictClients());
                if (apiInstance.getAccessControlSettings().isRestrictClients() && apiInstance.getAccessControlSettings().getAllowedClients() != null) {
                    for (ResourceLink allowedClient : apiInstance.getAccessControlSettings().getAllowedClients()) {
                        domainInstance.getAllowedClients().add(allowedClient.getId());
                    }
                }
            }
        }
        if (apiInstance.getSessionValidationSettings() != null) {
            if (this.getBooleanVal(apiInstance.getSessionValidationSettings().isInherited())) {
                domainInstance.setInheritSessionValidationSettings(true);
            } else {
                domainInstance.setIncludeSessionIdentifier(this.getBooleanVal(apiInstance.getSessionValidationSettings().getIncludeSessionId()));
                domainInstance.setCheckSessionRevocationStatus(this.getBooleanVal(apiInstance.getSessionValidationSettings().getCheckSessionRevocationStatus()));
                domainInstance.setCheckSessionValidationStatus(this.getBooleanVal(apiInstance.getSessionValidationSettings().getCheckValidAuthnSession()));
                domainInstance.setUpdateAuthSessionActivity(this.getBooleanVal(apiInstance.getSessionValidationSettings().getUpdateAuthnSessionActivity()));
            }
        }
        return domainInstance;
    }

    public AccessTokenManager domainToApi(BearerAccessTokenMgmtPluginInstance domainInstance, int sequenceNumber) {
        AccessTokenAttribute apiAttr;
        AccessTokenManager atm = (AccessTokenManager)this.domainToApi((ConfigurablePluginInstance)domainInstance, PluginEnum.ACCESS_TOKEN_MANAGER);
        for (String coreAttrName : domainInstance.getAttributeContract().getImmutableAttributeNames()) {
            apiAttr = new AccessTokenAttribute();
            apiAttr.setName(coreAttrName);
            atm.getAttributeContract().getCoreAttributes().add(apiAttr);
        }
        for (Object extAttrName : domainInstance.getAttributeContract().getMutableAttributeNames()) {
            apiAttr = new AccessTokenAttribute();
            apiAttr.setName((String)extAttrName);
            if (domainInstance.getMultiValuedContractAttributes() != null && domainInstance.getMultiValuedContractAttributes().contains(extAttrName)) {
                apiAttr.setMultiValued(true);
            }
            atm.getAttributeContract().getExtendedAttributes().add(apiAttr);
        }
        if (domainInstance.isInheritingExtendedContractAttributes()) {
            atm.getAttributeContract().setInherited(domainInstance.isInheritingExtendedContractAttributes());
        }
        TokenEndpointAttributeContract domainTokenEndpointAttrContract = domainInstance.getTokenEndpointAttributeContract();
        for (String tokenEndpointAttrName : domainTokenEndpointAttrContract.getMutableAttributeNames()) {
            TokenEndpointAttribute apiAttr2 = new TokenEndpointAttribute();
            apiAttr2.setName(tokenEndpointAttrName);
            if (domainTokenEndpointAttrContract.getMultiValued() != null && domainTokenEndpointAttrContract.getMultiValued().contains(tokenEndpointAttrName)) {
                apiAttr2.setMultiValued(true);
            }
            if (domainTokenEndpointAttrContract.getMappedScopes() != null && domainTokenEndpointAttrContract.getMappedScopes().containsKey(tokenEndpointAttrName)) {
                apiAttr2.setMappedScopes((Set)domainTokenEndpointAttrContract.getMappedScopes().get(tokenEndpointAttrName));
            }
            atm.getTokenEndpointAttributeContract().getAttributes().add(apiAttr2);
        }
        if (domainInstance.isInheritTokenEndpointAttributeContract() && StringUtils.isNotBlank((String)domainInstance.getParentId())) {
            atm.getTokenEndpointAttributeContract().setInherited(true);
        }
        if (domainInstance.isInheritSelectionSettings()) {
            atm.getSelectionSettings().setInherited(true);
        }
        atm.getSelectionSettings().setResourceUris(domainInstance.getResourceUris());
        if (domainInstance.isInheritAccessControlSettings()) {
            atm.getAccessControlSettings().setInherited(true);
        }
        if (domainInstance.getParentId() != null) {
            atm.getSessionValidationSettings().setInherited(domainInstance.isInheritSessionValidationSettings());
        } else {
            atm.getSessionValidationSettings().setInherited(null);
        }
        atm.getSessionValidationSettings().setIncludeSessionId(domainInstance.findEffectiveIncludeSessionIdentifier());
        atm.getSessionValidationSettings().setCheckSessionRevocationStatus(domainInstance.findEffectiveRevocationStatus());
        atm.getSessionValidationSettings().setCheckValidAuthnSession(domainInstance.findEffectiveSessionValidationStatus());
        atm.getSessionValidationSettings().setUpdateAuthnSessionActivity(domainInstance.findEffectiveUpdateSessionStatus());
        String defaultSubjectAttr = domainInstance.findEffectiveDefaultSubjectAttribute();
        if (StringUtils.isNotBlank((String)defaultSubjectAttr)) {
            atm.getAttributeContract().setDefaultSubjectAttribute(defaultSubjectAttr);
        }
        atm.getAccessControlSettings().setRestrictClients(domainInstance.isRestrictClients());
        for (String clientId : domainInstance.getAllowedClients()) {
            ResourceLink oauthClientLink = new ResourceLink(clientId, ApiUtil.getResourceUrl("/oauth/clients", clientId));
            atm.getAccessControlSettings().getAllowedClients().add(oauthClientLink);
        }
        atm.setSequenceNumber(sequenceNumber);
        return atm;
    }
}

