/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.plugin;

import com.pingidentity.admin.api.model.plugin.FilterableSelectionFieldDescriptor;
import com.pingidentity.admin.api.model.plugin.HashedTextFieldDescriptor;
import com.pingidentity.admin.api.model.plugin.OptionValue;
import com.pingidentity.admin.api.model.plugin.PluginConfigDescriptor;
import com.pingidentity.admin.api.model.plugin.RadioGroupFieldDescriptor;
import com.pingidentity.admin.api.model.plugin.SelectFieldDescriptor;
import com.pingidentity.admin.api.model.plugin.TableDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextAreaFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.UploadFileFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class PluginConfigDescriptorTranslator {
    private static final Log log = LogFactory.getLog(PluginConfigDescriptorTranslator.class);

    public PluginConfigDescriptor domainToApi(GuiConfigDescriptor domainDesc) {
        PluginConfigDescriptor apiDesc = new PluginConfigDescriptor();
        apiDesc.setDescription(domainDesc.getDescription());
        apiDesc.setFields(this.translateFields((List<FieldDescriptor>)domainDesc.getFields(), domainDesc.getAdvancedFields()));
        apiDesc.setTables(this.translateTables(domainDesc.getTables()));
        apiDesc.setActionDescriptors(this.translateActions(domainDesc.getActions()));
        return apiDesc;
    }

    PluginConfigDescriptor domainToApi(List<FieldDescriptor> fields) {
        PluginConfigDescriptor apiDesc = new PluginConfigDescriptor();
        apiDesc.setFields(this.translateFields(fields, false));
        return apiDesc;
    }

    private List<com.pingidentity.admin.api.model.plugin.FieldDescriptor> translateFields(List<FieldDescriptor> basicFields, List<FieldDescriptor> advancedFields) {
        ArrayList<com.pingidentity.admin.api.model.plugin.FieldDescriptor> result = new ArrayList<com.pingidentity.admin.api.model.plugin.FieldDescriptor>();
        result.addAll(this.translateFields(basicFields, false));
        result.addAll(this.translateFields(advancedFields, true));
        return result;
    }

    private List<com.pingidentity.admin.api.model.plugin.FieldDescriptor> translateFields(List<FieldDescriptor> fields, boolean isAdvance) {
        ArrayList<com.pingidentity.admin.api.model.plugin.FieldDescriptor> result = new ArrayList<com.pingidentity.admin.api.model.plugin.FieldDescriptor>();
        if (fields != null) {
            for (FieldDescriptor domainField : fields) {
                com.pingidentity.admin.api.model.plugin.FieldDescriptor translated = this.translateField(domainField);
                if (translated == null) continue;
                translated.setAdvanced(isAdvance);
                result.add(translated);
            }
        }
        return result;
    }

    private com.pingidentity.admin.api.model.plugin.FieldDescriptor translateField(FieldDescriptor domainField) {
        if (domainField instanceof TextFieldDescriptor) {
            return this.translateTextField((TextFieldDescriptor)domainField);
        }
        if (domainField instanceof TextAreaFieldDescriptor) {
            return this.translateTextAreaField((TextAreaFieldDescriptor)domainField);
        }
        if (domainField instanceof CheckBoxFieldDescriptor) {
            return this.translateCheckBoxField((CheckBoxFieldDescriptor)domainField);
        }
        if (domainField instanceof org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor) {
            return this.translateRadioGroupField((org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor)domainField);
        }
        if (domainField instanceof org.sourceid.saml20.adapter.gui.SelectFieldDescriptor) {
            return this.translateSelectField((org.sourceid.saml20.adapter.gui.SelectFieldDescriptor)domainField);
        }
        if (domainField instanceof UploadFileFieldDescriptor) {
            return this.translateUploadFileField((UploadFileFieldDescriptor)domainField);
        }
        if (domainField instanceof org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor) {
            return this.translateHashedTextField((org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor)domainField);
        }
        if (domainField instanceof org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor) {
            return this.translateFilterableField((org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor)domainField);
        }
        log.warn((Object)("Unrecognized plugin field type: " + domainField.getClass()));
        return null;
    }

    private FilterableSelectionFieldDescriptor translateFilterableField(org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor domainField) {
        FilterableSelectionFieldDescriptor result = new FilterableSelectionFieldDescriptor();
        this.translateFieldDescriptor((FieldDescriptor)domainField, result);
        return result;
    }

    private com.pingidentity.admin.api.model.plugin.TextFieldDescriptor translateTextField(TextFieldDescriptor domainField) {
        com.pingidentity.admin.api.model.plugin.TextFieldDescriptor result = new com.pingidentity.admin.api.model.plugin.TextFieldDescriptor();
        this.translateFieldDescriptor((FieldDescriptor)domainField, result);
        result.setEncrypted(domainField.isEncrypted());
        result.setSize(domainField.getSize());
        return result;
    }

    private HashedTextFieldDescriptor translateHashedTextField(org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor domainField) {
        HashedTextFieldDescriptor result = new HashedTextFieldDescriptor();
        this.translateFieldDescriptor((FieldDescriptor)domainField, result);
        result.setSize(domainField.getSize());
        return result;
    }

    private com.pingidentity.admin.api.model.plugin.TextAreaFieldDescriptor translateTextAreaField(TextAreaFieldDescriptor domainField) {
        com.pingidentity.admin.api.model.plugin.TextAreaFieldDescriptor result = new com.pingidentity.admin.api.model.plugin.TextAreaFieldDescriptor();
        this.translateFieldDescriptor((FieldDescriptor)domainField, result);
        result.setRows(domainField.getRows());
        result.setColumns(domainField.getColumns());
        return result;
    }

    private RadioGroupFieldDescriptor translateRadioGroupField(org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor domainField) {
        RadioGroupFieldDescriptor result = new RadioGroupFieldDescriptor();
        this.translateFieldDescriptor((FieldDescriptor)domainField, result);
        result.setOptionValues(this.translateOptionValues(domainField.getOptionValues()));
        return result;
    }

    private SelectFieldDescriptor translateSelectField(org.sourceid.saml20.adapter.gui.SelectFieldDescriptor domainField) {
        SelectFieldDescriptor result = new SelectFieldDescriptor();
        this.translateFieldDescriptor((FieldDescriptor)domainField, result);
        result.setOptionValues(this.translateOptionValues(domainField.getOptionValues()));
        return result;
    }

    private com.pingidentity.admin.api.model.plugin.UploadFileFieldDescriptor translateUploadFileField(UploadFileFieldDescriptor domainField) {
        com.pingidentity.admin.api.model.plugin.UploadFileFieldDescriptor result = new com.pingidentity.admin.api.model.plugin.UploadFileFieldDescriptor();
        this.translateFieldDescriptor((FieldDescriptor)domainField, result);
        return result;
    }

    private com.pingidentity.admin.api.model.plugin.CheckBoxFieldDescriptor translateCheckBoxField(CheckBoxFieldDescriptor domainField) {
        com.pingidentity.admin.api.model.plugin.CheckBoxFieldDescriptor result = new com.pingidentity.admin.api.model.plugin.CheckBoxFieldDescriptor();
        this.translateFieldDescriptor((FieldDescriptor)domainField, result);
        return result;
    }

    private List<OptionValue> translateOptionValues(List<AbstractSelectionFieldDescriptor.OptionValue> domainValues) {
        ArrayList<OptionValue> result = new ArrayList<OptionValue>();
        for (AbstractSelectionFieldDescriptor.OptionValue domainValue : domainValues) {
            if (domainValue.getName() == null || domainValue.getName().equals(org.sourceid.saml20.adapter.gui.SelectFieldDescriptor.SELECT_ONE.getName())) continue;
            result.add(new OptionValue(domainValue.getName(), domainValue.getValue()));
        }
        return result;
    }

    private List<TableDescriptor> translateTables(List<org.sourceid.saml20.adapter.gui.TableDescriptor> domainTables) {
        ArrayList<TableDescriptor> result = new ArrayList<TableDescriptor>();
        for (org.sourceid.saml20.adapter.gui.TableDescriptor domainTable : domainTables) {
            result.add(this.translateTableDescriptor(domainTable));
        }
        return result;
    }

    private TableDescriptor translateTableDescriptor(org.sourceid.saml20.adapter.gui.TableDescriptor domainTable) {
        TableDescriptor result = new TableDescriptor();
        result.setName(domainTable.getName());
        result.setDescription(domainTable.getDescription());
        result.setColumns(this.translateFields((List<FieldDescriptor>)domainTable.getRowFields(), Collections.emptyList()));
        result.setLabel(domainTable.getLabel());
        result.setRequireDefaultRow(domainTable.getRequireDefaultRow());
        return result;
    }

    private void translateFieldDescriptor(FieldDescriptor domainField, com.pingidentity.admin.api.model.plugin.FieldDescriptor apiField) {
        apiField.setName(domainField.getName());
        apiField.setDescription(domainField.getDescription());
        apiField.setDefaultValue(domainField.getDefaultValue());
        apiField.setDefaultForLegacyConfig(domainField.getDefaultForLegacyConfig());
        apiField.setRequired(this.isRequiredField(domainField));
        apiField.setLabel(domainField.getLabel());
    }

    private List<com.pingidentity.admin.api.model.plugin.ActionDescriptor> translateActions(List<ActionDescriptor> domainActions) {
        if (domainActions.isEmpty()) {
            return null;
        }
        ArrayList<com.pingidentity.admin.api.model.plugin.ActionDescriptor> apiActions = new ArrayList<com.pingidentity.admin.api.model.plugin.ActionDescriptor>(domainActions.size());
        for (ActionDescriptor domainAction : domainActions) {
            com.pingidentity.admin.api.model.plugin.ActionDescriptor apiAction = new com.pingidentity.admin.api.model.plugin.ActionDescriptor();
            apiAction.setDescription(domainAction.getDescription());
            apiAction.setDownload(domainAction.isDownload());
            apiAction.setDownloadContentType(domainAction.getDownloadContentType());
            apiAction.setDownloadFileName(domainAction.getDownloadFilename());
            apiAction.setName(domainAction.getName());
            apiActions.add(apiAction);
            apiAction.setParameters(this.translateFields((List<FieldDescriptor>)domainAction.getParameters(), false));
        }
        return apiActions;
    }

    private boolean isRequiredField(FieldDescriptor descriptor) {
        for (FieldDescriptor.FieldValidationWrapper validationWrapper : descriptor.getValidationChain()) {
            if (!(validationWrapper.getValidator() instanceof RequiredFieldValidator)) continue;
            return true;
        }
        return false;
    }
}

