/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.plugin;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.plugin.PluginConfiguration;
import com.pingidentity.admin.api.model.plugin.PluginInstance;
import com.pingidentity.admin.api.translator.plugin.PluginConfigTranslator;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.PluginInstanceValidator;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.util.List;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.internal.ConfigOverrideMetadata;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;

public class PluginInstanceTranslator {
    private final PluginConfigTranslator configTranslator = new PluginConfigTranslator();

    public PluginInstance domainToApi(ConfigurablePluginInstance domainInstance, PluginEnum pluginType) {
        PluginConfiguration apiConfig;
        PluginInstance apiInstance = pluginType.newApiInstance();
        apiInstance.setId(domainInstance.getId());
        apiInstance.setName(domainInstance.getName());
        String typeId = null;
        switch (pluginType) {
            case CUSTOM_DATA_SOURCE: {
                CustomDataSource customDataSource = (CustomDataSource)domainInstance;
                typeId = customDataSource.getDriverClassName();
                break;
            }
            default: {
                typeId = domainInstance.getDescriptor().getPluginClassName();
            }
        }
        String pluginDescriptorUrl = ApiUtil.getResourceUrl(pluginType.getDescriptorsResourcePath(), typeId);
        apiInstance.setPluginDescriptorRef(new ResourceLink(typeId, pluginDescriptorUrl));
        String parentId = domainInstance.getParentId();
        if (parentId != null) {
            String parentUrl = ApiUtil.getResourceUrl(pluginType.getInstancesResourcePath(), parentId);
            apiInstance.setParentRef(new ResourceLink(parentId, parentUrl));
        }
        GuiConfigDescriptor guiDesc = domainInstance.getGuiDescriptor();
        if (domainInstance.getParentId() != null) {
            Configuration compositeConfig = ConfigurationUtil.createAdminCompositeConfiguration((ConfigurablePluginInstance)domainInstance);
            ConfigOverrideMetadata overrideMetadata = ConfigurationUtil.createConfigOverrideMetadata((Configuration)domainInstance.getConfiguration(), (Configuration)compositeConfig, (GuiConfigDescriptor)guiDesc);
            compositeConfig = ConfigurationUtil.sanitize((Configuration)compositeConfig);
            apiConfig = this.configTranslator.domainToApi(compositeConfig, guiDesc, overrideMetadata);
        } else {
            Configuration domainConfig = ConfigurationUtil.sanitize((Configuration)domainInstance.getConfiguration());
            apiConfig = this.configTranslator.domainToApi(domainConfig, guiDesc);
        }
        if (domainInstance.getLastModified() != null) {
            apiInstance.setLastModified(domainInstance.getLastModified().getTime());
        }
        apiInstance.setConfiguration(apiConfig);
        return apiInstance;
    }

    public ConfigurablePluginInstance apiToDomain(PluginInstance apiInstance, PluginInstanceValidator validator, PluginEnum pluginType) {
        ConfigurablePluginInstance domainInstance = pluginType.getPluginManager().newInstance();
        domainInstance.setId(apiInstance.getId());
        domainInstance.setName(apiInstance.getName());
        domainInstance.setDescriptor(validator.getPluginDescriptor());
        domainInstance.setParentId(validator.getParentId());
        domainInstance.setConfiguration(validator.getDomainConfiguration());
        this.fixAdvancedFields(domainInstance);
        return domainInstance;
    }

    protected boolean getBooleanVal(Boolean b) {
        if (b == null) {
            return false;
        }
        return b;
    }

    protected void fixAdvancedFields(ConfigurablePluginInstance plugin) {
        Configuration config = plugin.getConfiguration();
        List advancedFields = plugin.getConfiguration().getAdvancedFields().getFields();
        List fields = config.getFields();
        fields.addAll(advancedFields);
        Configuration newConfig = new Configuration(fields, config.getTables(), advancedFields);
        plugin.setConfiguration(newConfig);
    }
}

