/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.plugin;

import com.pingidentity.admin.api.model.plugin.SpAdapter;
import com.pingidentity.admin.api.model.plugin.SpAdapterAttribute;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.PluginInstanceValidator;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.pf.admin.rest.translator.plugin.PluginInstanceTranslator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;

public class SpAdapterTranslator
extends PluginInstanceTranslator {
    public AuthnAdapterInstance apiToDomain(SpAdapter apiInstance, PluginInstanceValidator validator) {
        boolean isTargetApplicationInfoInherited;
        AuthnAdapterInstance domainInstance = (AuthnAdapterInstance)this.apiToDomain(apiInstance, validator, PluginEnum.SP_ADAPTER);
        boolean isInherited = this.getBooleanVal(apiInstance.getAttributeContract().isInherited());
        if (!isInherited) {
            if (domainInstance.getDescriptor().isSupportsExtendedContract() && apiInstance.getAttributeContract().getExtendedAttributes() != null) {
                HashSet<String> domainExtAttrs = new HashSet<String>();
                for (SpAdapterAttribute extApiAttr : apiInstance.getAttributeContract().getExtendedAttributes()) {
                    domainExtAttrs.add(extApiAttr.getName());
                }
                domainInstance.setExtendedContractAttributes(domainExtAttrs);
            }
        } else {
            domainInstance.setInheritingExtendedContractAttributes(true);
        }
        if (!(isTargetApplicationInfoInherited = this.getBooleanVal(apiInstance.getTargetApplicationInfo().getInherited()))) {
            String applicationName = apiInstance.getTargetApplicationInfo().getApplicationName();
            domainInstance.setApplicationName(applicationName);
            String applicationIconUrlStr = apiInstance.getTargetApplicationInfo().getApplicationIconUrl();
            if (StringUtils.isNotBlank((String)applicationIconUrlStr)) {
                URL applicationIconUrl;
                try {
                    applicationIconUrl = new URL(applicationIconUrlStr);
                }
                catch (MalformedURLException e) {
                    applicationIconUrl = null;
                }
                domainInstance.setApplicationIconUrl(applicationIconUrl);
            }
        } else {
            domainInstance.setInheritingTargetApplicationInfo(true);
        }
        return domainInstance;
    }

    public SpAdapter domainToApi(ConfigurablePluginInstance domainInstance) {
        String applicationIconUrl;
        boolean inheriting;
        SpAdapter apiAdapter = (SpAdapter)this.domainToApi(domainInstance, PluginEnum.SP_ADAPTER);
        for (Object coreAttr : domainInstance.getAttributeContract().getImmutableAttributeNames()) {
            SpAdapterAttribute apiAttr = new SpAdapterAttribute();
            apiAttr.setName((String)coreAttr);
            apiAdapter.getAttributeContract().getCoreAttributes().add(apiAttr);
        }
        if (domainInstance.getDescriptor().isSupportsExtendedContract()) {
            LinkedList<SpAdapterAttribute> apiExtAttrs = new LinkedList<SpAdapterAttribute>();
            for (String extAttr : domainInstance.getAttributeContract().getMutableAttributeNames()) {
                SpAdapterAttribute apiAttr = new SpAdapterAttribute();
                apiAttr.setName(extAttr);
                apiExtAttrs.add(apiAttr);
            }
            apiAdapter.getAttributeContract().setExtendedAttributes(apiExtAttrs);
        }
        if (inheriting = domainInstance.isInheritingExtendedContractAttributes()) {
            apiAdapter.getAttributeContract().setInherited(Boolean.TRUE);
        }
        AuthnAdapterInstance tmp = (AuthnAdapterInstance)domainInstance;
        boolean inheritingTargetApplicationInfo = tmp.isInheritingTargetApplicationInfo();
        String applicationName = tmp.getApplicationName();
        String string = applicationIconUrl = tmp.getApplicationIconUrl() != null ? tmp.getApplicationIconUrl().toExternalForm() : null;
        if (inheritingTargetApplicationInfo) {
            apiAdapter.getTargetApplicationInfo().setInherited(true);
            applicationName = ConfigurationUtil.findEffectiveApplicationName((AuthnAdapterInstance)tmp);
            applicationIconUrl = ConfigurationUtil.findEffectiveApplicationIconUrlStr((AuthnAdapterInstance)tmp);
        }
        apiAdapter.getTargetApplicationInfo().setApplicationName(applicationName);
        apiAdapter.getTargetApplicationInfo().setApplicationIconUrl(applicationIconUrl);
        return apiAdapter;
    }
}

