/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.pingfederate.migration.util.SimpleFileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class TcpUdpXmlFileCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(TcpUdpXmlFileCustomAction.class);
    private String sourceVersion;
    private String destinationVersion;
    private Map<String, String> deprecatedProtocols = new HashMap<String, String>();
    private Map<String, List<String>> deprecatedAttributes = new HashMap<String, List<String>>();
    private Map<String, String> deprecatedProtocolWarnings = new HashMap<String, String>();

    public TcpUdpXmlFileCustomAction(String sourceVersion, String destinationVersion) {
        this.sourceVersion = sourceVersion;
        this.destinationVersion = destinationVersion;
        this.initDeprecatedProtocolsAndSettings();
    }

    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File sourceConfig = new File(sourceFileParentDir, fileName);
        File sourceDefaultConfig = new File(sourceDefaultFileParentDir, fileName);
        File destinationConfig = new File(destinationFileParentDir, fileName);
        File backupDestinationConfig = new File(destinationFileParentDir, this.getBackupDestinationFilename(fileName));
        try {
            boolean defaultsChangedBetweenVersions;
            boolean sourceModifiedFromDefault = !FileUtils.contentEquals((File)sourceConfig, (File)sourceDefaultConfig);
            boolean bl = defaultsChangedBetweenVersions = !FileUtils.contentEquals((File)sourceDefaultConfig, (File)destinationConfig);
            if (sourceModifiedFromDefault) {
                this.copySourceToDestination(sourceConfig, destinationConfig, backupDestinationConfig);
                this.removeDeprecatedProtocolsAndAttributes(destinationConfig, backupDestinationConfig);
                if (defaultsChangedBetweenVersions) {
                    log.warn("The default settings in " + fileName + " have been changed in PingFederate " + this.destinationVersion + ". Manual updates may be required. Please see \"PingFederate Upgrade Utility User Guide\" for more details.");
                }
                this.checkDiscoveryProtocolMigration(fileName, sourceConfig);
            }
        }
        catch (MigrationException | IOException | ParserConfigurationException | SAXException e) {
            throw new FileCustomActionException("Unable to migrate " + LogHelper.getInstance().getCleanPath(sourceConfig.getPath()), e);
        }
    }

    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        return false;
    }

    public boolean copyIfSourceDefaultMissing() {
        return false;
    }

    private void copySourceToDestination(File sourceConfig, File destinationConfig, File backupDestinationConfig) throws IOException {
        FileUtils.moveFile((File)destinationConfig, (File)backupDestinationConfig);
        log.info("Rename " + LogHelper.getInstance().getCleanPath(destinationConfig.getPath()) + " to " + LogHelper.getInstance().getCleanPath(backupDestinationConfig.getPath()));
        FilesUtils.copyfile((File)sourceConfig, (File)destinationConfig);
    }

    private String getBackupDestinationFilename(String fileName) {
        Object extension = FilenameUtils.getExtension((String)fileName);
        if (!((String)extension).isEmpty()) {
            extension = "." + (String)extension;
        }
        return FilenameUtils.removeExtension((String)fileName) + "-default-" + this.destinationVersion + (String)extension;
    }

    private void removeDeprecatedProtocolsAndAttributes(File destinationConfig, File backupDestinationConfig) throws IOException, ParserConfigurationException, SAXException, MigrationException {
        Document destinationDoc;
        DocumentBuilder parser = XmlBeansUtil.getDocumentBuilder();
        try {
            destinationDoc = parser.parse(destinationConfig);
        }
        catch (IOException | SAXException e) {
            log.warn("File " + LogHelper.getInstance().getCleanPath(destinationConfig.getPath()) + " could not be parsed. It may be in an older format. Deprecated protocols and attributes will not be automatically replaced or removed.");
            return;
        }
        Document backupDestinationDoc = parser.parse(backupDestinationConfig);
        Element destinationRoot = this.getElement(destinationDoc, "config");
        if (destinationRoot == null) {
            log.warn("File " + LogHelper.getInstance().getCleanPath(destinationConfig.getPath()) + " is missing 'config' element at root");
            return;
        }
        boolean docWasChanged = false;
        NodeList children = destinationRoot.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            String currentProtocol = childElement.getTagName();
            if (this.deprecatedProtocols.containsKey(currentProtocol)) {
                String replacementProtocol = this.deprecatedProtocols.get(currentProtocol);
                Element replacementElement = this.getElement(backupDestinationDoc, replacementProtocol);
                if (replacementElement == null) {
                    log.warn("Replacement protocol " + replacementProtocol + " not found in " + LogHelper.getInstance().getCleanPath(backupDestinationConfig.getPath()));
                } else {
                    this.replaceElement(destinationDoc, destinationRoot, childElement, replacementElement);
                    log.info("Replace " + currentProtocol + " with " + replacementProtocol + " in " + LogHelper.getInstance().getCleanPath(destinationConfig.getPath()));
                    docWasChanged = true;
                }
            } else if (this.deprecatedAttributes.containsKey(currentProtocol)) {
                List<String> attrsToRemove = this.deprecatedAttributes.get(currentProtocol);
                for (String attr : attrsToRemove) {
                    if (!childElement.hasAttribute(attr)) continue;
                    childElement.removeAttribute(attr);
                    log.info("Remove " + currentProtocol + " deprecated attribute '" + attr + "' in " + LogHelper.getInstance().getCleanPath(destinationConfig.getPath()));
                    docWasChanged = true;
                }
            }
            if (this.deprecatedProtocolWarnings.containsKey(currentProtocol)) {
                String warnMsg = this.deprecatedProtocolWarnings.get(currentProtocol);
                log.warn(warnMsg);
            }
            if (Version.compare((String)this.sourceVersion, (String)"10.0.0") >= 0 || !currentProtocol.equals("TCP") && !currentProtocol.equals("TCP_NIO2") && !currentProtocol.equals("UDP")) continue;
            int maxThreads = 0;
            String maxThreadsStr = childElement.getAttribute("thread_pool.max_threads");
            if (!StringUtils.isBlank((String)maxThreadsStr)) {
                try {
                    maxThreads = Integer.parseInt(maxThreadsStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (maxThreads >= 40) continue;
            childElement.setAttribute("thread_pool.max_threads", "40");
            log.info("Update " + currentProtocol + " attribute 'thread_pool.max_threads' in " + LogHelper.getInstance().getCleanPath(destinationConfig.getPath()));
            docWasChanged = true;
        }
        if (docWasChanged) {
            this.saveDocument(destinationDoc, destinationConfig);
        }
    }

    private void saveDocument(Document doc, File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            DOMImplementation domImplementation = doc.getImplementation();
            DOMImplementationLS domImplementationLS = (DOMImplementationLS)domImplementation.getFeature("LS", "3.0");
            LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
            lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            lsSerializer.getDomConfig().setParameter("xml-declaration", Boolean.FALSE);
            LSOutput lsOutput = domImplementationLS.createLSOutput();
            lsOutput.setEncoding(StandardCharsets.UTF_8.name());
            lsOutput.setCharacterStream(writer);
            lsSerializer.write(doc, lsOutput);
        }
    }

    private void replaceElement(Document document, Element parent, Element element, Element replacement) {
        Node replacementNode = document.importNode(replacement, true);
        parent.replaceChild(replacementNode, element);
    }

    private Element getElement(Document document, String tagname) {
        NodeList nodeList = document.getElementsByTagName(tagname);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private void initDeprecatedProtocolsAndSettings() {
        this.deprecatedProtocols.put("MERGE2", "MERGE3");
        this.deprecatedProtocols.put("pbcast.NAKACK", "pbcast.NAKACK2");
        this.deprecatedProtocols.put("UNICAST", "UNICAST3");
        this.deprecatedAttributes.put("UDP", Arrays.asList("max_bundle_timeout", "thread_pool.queue_enabled", "thread_pool.queue_max_size", "thread_pool.rejection_policy", "oob_thread_pool.enabled", "oob_thread_pool.min_threads", "oob_thread_pool.max_threads", "oob_thread_pool.keep_alive_time", "oob_thread_pool.queue_enabled", "oob_thread_pool.queue_max_size", "oob_thread_pool.rejection_policy"));
        this.deprecatedAttributes.put("TCP", Arrays.asList("use_send_queues", "max_bundle_timeout", "thread_pool.queue_enabled", "thread_pool.queue_max_size", "thread_pool.rejection_policy", "oob_thread_pool.enabled", "oob_thread_pool.min_threads", "oob_thread_pool.max_threads", "oob_thread_pool.keep_alive_time", "oob_thread_pool.queue_enabled", "oob_thread_pool.queue_max_size", "oob_thread_pool.rejection_policy"));
        this.deprecatedAttributes.put("TCP_NIO2", Arrays.asList("max_bundle_timeout", "thread_pool.queue_enabled", "thread_pool.queue_max_size", "thread_pool.rejection_policy", "oob_thread_pool.enabled", "oob_thread_pool.min_threads", "oob_thread_pool.max_threads", "oob_thread_pool.keep_alive_time", "oob_thread_pool.queue_enabled", "oob_thread_pool.queue_max_size", "oob_thread_pool.rejection_policy"));
        this.deprecatedAttributes.put("UNICAST3", Arrays.asList("max_msg_batch_size"));
        this.deprecatedAttributes.put("pbcast.GMS", Arrays.asList("view_bundling"));
        this.deprecatedAttributes.put("pbcast.STABLE", Arrays.asList("stability_delay"));
        this.deprecatedProtocolWarnings.put("S3_PING", "S3_PING discovery method has been deprecated due to AWS deprecation of SigV2 signing method. When running in AWS, the suggested replacement is NATIVE_S3_PING. See the JGroups documentation for alternatives when running in other environments.");
    }

    private void checkDiscoveryProtocolMigration(String fileName, File sourceConfig) throws IOException {
        String rawTcpXml;
        if ("tcp.xml".equals(fileName) && sourceConfig.exists() && !(rawTcpXml = SimpleFileUtil.readFileToString(sourceConfig)).contains("${DISCOVERY_TAG}")) {
            log.info("Cluster discovery protocol may now be migrated to jgroups.properties. Please see \"PingFederate Server Clustering Guide\" for more details.");
        }
    }
}

