/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.file.custom.archivefile;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.pingfederate.migration.file.custom.archivefile.ArchiveFileCustomAction;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeepLatestJarCustomAction
extends ArchiveFileCustomAction {
    private static final Logger log = LogManager.getLogger(KeepLatestJarCustomAction.class);

    public KeepLatestJarCustomAction(String mode) {
        super(mode);
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        block9: {
            File sourceFile = new File(sourceFileParentDir, fileName);
            try {
                String baseFileName = this.getFileNameWithoutVersion(fileName);
                Collection jarFiles = FileUtils.listFiles((File)destinationFileParentDir, (IOFileFilter)new WildcardFileFilter(baseFileName + "*.jar"), null);
                if (jarFiles.size() == 0) {
                    FilesUtils.copyfile((File)sourceFile, (File)new File(destinationFileParentDir, fileName));
                    break block9;
                }
                if (jarFiles.size() == 1) {
                    Version destinationVersion;
                    Version sourceVersion;
                    String sourceVersionStr = this.extractVersion(fileName);
                    File destinationJar = (File)jarFiles.iterator().next();
                    String destinationFileName = destinationJar.getName();
                    String destinationVersionStr = this.extractVersion(destinationFileName);
                    try {
                        sourceVersion = new Version(sourceVersionStr, true);
                        destinationVersion = new Version(destinationVersionStr, true);
                    }
                    catch (MigrationException e) {
                        log.warn("Cannot determine version for at least one of: " + LogHelper.getInstance().getCleanPath(sourceFile) + ", " + LogHelper.getInstance().getCleanPath(destinationJar) + ". Source file will not be migrated.");
                        return;
                    }
                    int compareResult = sourceVersion.compareTo(destinationVersion);
                    if (compareResult < 0) {
                        log.info(LogHelper.getInstance().getCleanPath(sourceFile) + " will not be migrated as " + LogHelper.getInstance().getCleanPath(destinationJar) + " is a later version");
                    } else if (compareResult != 0 && compareResult > 0) {
                        log.info("Replacing " + LogHelper.getInstance().getCleanPath(destinationJar) + " with " + LogHelper.getInstance().getCleanPath(sourceFile));
                        FilesUtils.deleteFile((File)destinationJar);
                        FilesUtils.copyfile((File)sourceFile, (File)new File(destinationFileParentDir, fileName));
                    }
                    break block9;
                }
                throw new FileCustomActionException("More than one matching jar was found in " + LogHelper.getInstance().getCleanPath(destinationFileParentDir) + ". Unable to migrate " + LogHelper.getInstance().getCleanPath(sourceFile) + ".");
            }
            catch (IOException e) {
                throw new FileCustomActionException("Unable to migrate " + LogHelper.getInstance().getCleanPath(sourceFile), (Throwable)e);
            }
        }
    }

    public String getFileNameWithoutVersion(String fileName) {
        if (fileName.contains("-")) {
            return StringUtils.substringBeforeLast((String)fileName, (String)"-");
        }
        return StringUtils.substringBeforeLast((String)fileName, (String)".");
    }

    protected String extractVersion(String fileName) {
        String versionNumberAndSuffix = StringUtils.substringAfterLast((String)fileName, (String)"-");
        Object versionNumber = StringUtils.substringBeforeLast((String)versionNumberAndSuffix, (String)".");
        if (StringUtils.countMatches((String)versionNumber, (String)".") == 1) {
            versionNumber = (String)versionNumber + ".0";
        }
        return versionNumber;
    }
}

