/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.prompts;

import com.pingidentity.pingfederate.migration.prompts.Prompt;
import com.pingidentity.pingfederate.migration.prompts.SimplePrompt;
import com.pingidentity.pingfederate.migration.util.DocsHelper;

public final class ReleaseNotePrompt
implements Prompt {
    private static final String QUESTION = "Have you read the relevant release notes between the source and target versions? (y/n) [n] ";
    private static final String EXPECTED_ANSWER = "y";
    private final Prompt prompt;

    public ReleaseNotePrompt() {
        Prompt.FailureHandler failureHandler = () -> {
            System.out.println();
            System.out.println("Please review the current and the previous release notes to ensure your upgrade completes successfully.");
            System.out.println();
            System.out.printf("Current release notes: %s%n", DocsHelper.getDocumentationUrl("PingFed-ReleaseNotes"));
            System.out.printf("Previous release notes: %s%n", DocsHelper.getDocumentationUrl("PingFed-PreviousReleaseNotes"));
            System.out.println();
            System.exit(1);
        };
        this.prompt = new SimplePrompt(QUESTION, EXPECTED_ANSWER, failureHandler);
    }

    @Override
    public boolean prompt() {
        return this.prompt.prompt();
    }
}

