/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingfederate.migration.util.hivemodule;

import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.MigrationException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class HivemoduleHelper {
    private static final Logger log = LogManager.getLogger(HivemoduleHelper.class);
    protected LogHelper logHelper = LogHelper.getInstance();
    protected final String PROXY_INTER_REQ_STATE_MGMT_CLASS = "org.sourceid.saml20.service.impl.proxy.InterRequestStateMgmtProxy";
    protected final String COOKIE_INTER_REQ_STATE_MGMT_CLASS = "org.sourceid.saml20.service.impl.cookie.InterReqStateMgmtCookieImpl";
    protected final String INTER_REQ_STATE_MGMT_INTERFACE = "InterRequestStateMgmt";
    protected final String deprecatedServiceUsageMessage = "Cookie based \"Inter-Request State-Management\" (org.sourceid.saml20.service.impl.cookie.InterReqStateMgmtCookieImpl) has been deprecated as of PingFederate 9.2 and may be removed in future releases. It is recommended to use the Inter-Request State-Management proxy implementation (org.sourceid.saml20.service.impl.proxy.InterRequestStateMgmtProxy) instead.";
    protected static final String HIVEMODULE_XML = "hivemodule.xml";
    protected String sourceVersion;

    public static Map<String, XmlObject> buildServicePointMapFromHivemoduleXML(XmlObject hivemoduleXmlDoc) {
        HashMap<String, XmlObject> servicePointsMap = new HashMap<String, XmlObject>();
        XmlCursor docCurser = hivemoduleXmlDoc.newCursor();
        if (docCurser.hasNextToken()) {
            do {
                docCurser.toNextToken();
                if (!docCurser.isStart() || !docCurser.getName().getLocalPart().equals("service-point")) continue;
                XmlObject servicePointObject = docCurser.getObject();
                servicePointsMap.put(HivemoduleHelper.getServicePointIdFromXML(servicePointObject), servicePointObject);
            } while (docCurser.hasNextToken());
        }
        return servicePointsMap;
    }

    public static String getClassFromServicePoint(XmlObject servicePoint) {
        QName classQName = new QName("class");
        String className = null;
        XmlCursor servicePointCursor = servicePoint.newCursor();
        if (!HivemoduleHelper.sendToTagWithClassAttribute(servicePointCursor)) {
            log.debug("Unable to find expected tag with 'class' attribute in service point.");
        } else {
            className = servicePointCursor.getAttributeText(classQName);
        }
        return className;
    }

    protected String getInterfaceFromServicePoint(XmlObject servicePoint) {
        QName interfaceQName = new QName("interface");
        XmlCursor servicePointCursor = servicePoint.newCursor();
        return servicePointCursor.getAttributeText(interfaceQName);
    }

    protected boolean setClassInServicePoint(XmlObject servicePoint, String className) {
        QName classQName = new QName("class");
        boolean success = false;
        XmlCursor servicePointCursor = servicePoint.newCursor();
        if (!HivemoduleHelper.sendToTagWithClassAttribute(servicePointCursor)) {
            log.debug("Unable to find expected tag with 'class' attribute in service point.");
        } else {
            success = servicePointCursor.setAttributeText(classQName, className);
        }
        return success;
    }

    protected boolean setInterfaceInServicePoint(XmlObject servicePoint, String interfaceName) {
        XmlCursor servicePointCursor;
        QName interfaceQName = new QName("interface");
        boolean success = false;
        if (interfaceName != null && !(success = (servicePointCursor = servicePoint.newCursor()).setAttributeText(interfaceQName, interfaceName))) {
            log.debug("Unable to find expected tag with 'interface' attribute in service point.");
        }
        return success;
    }

    public static String getServicePointIdFromXML(XmlObject servicePointXML) {
        XmlCursor cursor = servicePointXML.newCursor();
        return cursor.getAttributeText(new QName("id"));
    }

    protected String servicePointCustomAction(String servicePointId) {
        String result = null;
        if (StringUtils.equals((String)servicePointId, (String)"ClientManager")) {
            try {
                if (Version.compare((String)this.sourceVersion, (String)"6.8.0") >= 0 && Version.compare((String)this.sourceVersion, (String)"7.1.0") < 0) {
                    result = "org.sourceid.oauth20.domain.ClientManagerJdbcImpl";
                }
            }
            catch (MigrationException e) {
                log.error("Failed to parse source PF version: " + this.sourceVersion, (Throwable)e);
            }
        }
        return result;
    }

    protected String servicePointCustomInterface(String servicePointId, String sourceInterfaceName, String destinationInterfaceName, String sourceClassName, String destinationClassName) {
        if (StringUtils.equals((String)servicePointId, (String)"ClientStorageManager")) {
            try {
                if (Version.compare((String)this.sourceVersion, (String)"8.3.0") >= 0 && !StringUtils.equals((String)sourceClassName, (String)destinationClassName) && !StringUtils.equals((String)sourceInterfaceName, (String)destinationInterfaceName)) {
                    return sourceInterfaceName;
                }
            }
            catch (MigrationException e) {
                log.error("Failed to parse source PF version: " + this.sourceVersion, (Throwable)e);
            }
        }
        return null;
    }

    public static boolean sendToTagWithClassAttribute(XmlCursor servicePointCursor) {
        QName createInstanceQName = new QName("create-instance");
        QName invokeFactoryQName = new QName("invoke-factory");
        QName constructQName = new QName("construct");
        return servicePointCursor.toChild(createInstanceQName) || servicePointCursor.toChild(invokeFactoryQName) && servicePointCursor.toChild(constructQName);
    }
}

