/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import com.pingidentity.adapters.pingone.risk.PingOneRiskManagementAdapterConfiguration;
import com.pingidentity.adapters.pingone.risk.RiskService;
import com.pingidentity.adapters.pingone.risk.api.ApiResponseException;
import com.pingidentity.adapters.pingone.risk.api.RiskServiceException;
import com.pingidentity.adapters.pingone.risk.api.TokenServiceException;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.LogEvent;
import java.util.Map;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;

public class GetRiskPolicySetsAction
implements ActionDescriptor.Action {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(GetRiskPolicySetsAction.class);
    private static final String UNABLE_TO_GET_RISK_POLICY_SETS = "Unable to get risk policies. ";
    private static final String AVAILABLE_RISK_POLICY_SETS = "The following risk policies are available: \n\n%s";
    private static final String STATUS_LINE_MESSAGE = "PingOne Risk Management returned HTTP status %s %s. ";
    private static final String CHECK_CONFIGURATION_MESSAGE = "Please check the value of the 'PingOne Environment' field";
    private static final String LEGACY_CHECK_CONFIGURATION_MESSAGE = "Please check the values of the 'Environment ID', 'PingFederate Connection Client ID', 'PingFederate Connection Client Secret', and 'Region' fields";
    private static final String CHECK_PROXY_CONFIGURATION_MESSAGE = " as well as proxy configuration, if applicable.";

    public String actionInvoked(Configuration configuration) {
        String result;
        RiskService riskService = RiskService.configureRiskService(configuration);
        try {
            result = "";
            Map<String, String> riskPolicySetNames = riskService.getRiskPolicyNames();
            StringBuilder riskPolicySets = new StringBuilder();
            riskPolicySetNames.forEach((key, value) -> riskPolicySets.append("\"").append((String)value).append("\"").append(" - ").append("\"").append((String)key).append("\"\n"));
            result = result + String.format(AVAILABLE_RISK_POLICY_SETS, riskPolicySets.toString());
        }
        catch (RiskServiceException | TokenServiceException e) {
            LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.GET_RISK_POLICY_SETS_ACTION_FAILURE, e);
            result = UNABLE_TO_GET_RISK_POLICY_SETS;
            if (e.getCause() instanceof ApiResponseException) {
                ApiResponseException apiResponseException = (ApiResponseException)e.getCause();
                int statusCode = apiResponseException.getStatusCode();
                String reasonPhrase = apiResponseException.getReasonPhrase();
                result = result + String.format(STATUS_LINE_MESSAGE, statusCode, reasonPhrase);
            }
            result = PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration) ? result + CHECK_CONFIGURATION_MESSAGE : result + LEGACY_CHECK_CONFIGURATION_MESSAGE;
            result = e.getCause() instanceof ApiResponseException ? result + "." : result + CHECK_PROXY_CONFIGURATION_MESSAGE;
        }
        return result;
    }
}

