/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import com.pingidentity.adapters.pingone.risk.ValidatorUtil;
import java.util.function.Predicate;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.EnhancedRowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class OptionalUserAttributesValidator
implements EnhancedRowValidator {
    public void validate(FieldList fieldsInRow, Configuration configuration) throws ValidationException {
        Table optionalUserAttributesTable = configuration.getTable("Additional User Attributes (optional)");
        String userAttribute = fieldsInRow.getFieldValue("PingOne Risk Management Attribute");
        if (SelectFieldDescriptor.SELECT_ONE.getValue().equals(userAttribute)) {
            throw new ValidationException("'PingOne Risk Management Attribute' is required.");
        }
        Predicate<Row> isDuplicate = row -> row.getFieldValue("PingOne Risk Management Attribute").equals(userAttribute);
        if (ValidatorUtil.duplicates(optionalUserAttributesTable, isDuplicate)) {
            throw new ValidationException("Each 'PingOne Risk Management Attribute' may only be defined once.");
        }
    }

    public void validate(FieldList fieldsInRow) throws ValidationException {
    }
}

