/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import com.pingidentity.adapters.pingone.risk.FallbackConfigurationValidator;
import com.pingidentity.adapters.pingone.risk.GetRiskPolicySetsAction;
import com.pingidentity.adapters.pingone.risk.OptionalUserAttribute;
import com.pingidentity.adapters.pingone.risk.OptionalUserAttributesValidator;
import com.pingidentity.adapters.pingone.risk.ProxyConfigurationValidator;
import com.pingidentity.adapters.pingone.risk.Region;
import com.pingidentity.adapters.pingone.risk.RiskPolicyPreRenderCallback;
import com.pingidentity.adapters.pingone.risk.TestConnectionAction;
import com.pingidentity.adapters.pingone.risk.ValidatorUtil;
import com.pingidentity.adapters.pingone.risk.api.model.Result;
import com.pingidentity.adapters.pingone.risk.configuration.GetRiskPredictorsAction;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.util.JsonPointerValidator;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.risk.validator.PredictorAttributeMappingValidator;
import com.pingidentity.adapters.pingone.risk.validator.TableUniqueKeyValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.EnhancedRowValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class PingOneRiskManagementAdapterConfiguration {
    private static boolean supportsPingOneEnvironmentFieldDescriptor;
    private static final OptionalUserAttributesTable OPTIONAL_USER_ATTRIBUTES_TABLE;
    private static final OptionalPredictorsTable OPTIONAL_PREDICTORS_TABLE;
    private static final ApiResponseMappingsTable API_RESPONSE_MAPPINGS_TABLE;
    public static final EnvIdField ENV_ID_FIELD;
    public static final ClientIdField CLIENT_ID_FIELD;
    public static final ClientSecretField CLIENT_SECRET_FIELD;
    private static final RiskPolicySetIdField RISK_POLICY_SET_NAME_FIELD;
    private static final IncludeDeviceProfileField INCLUDE_DEVICE_PROFILE_FIELD;
    private static final DeviceProfilingMethodField DEVICE_PROFILING_METHOD_FIELD;
    private static final DeviceProfilingTimeoutField DEVICE_PROFILING_TIMEOUT_FIELD;
    private static final CookieNamePrefixField COOKIE_NAME_FIELD;
    private static final FailureModeField FAILURE_MODE_FIELD;
    private static final FallbackValueField FALLBACK_VALUE_FIELD;
    private static final RequestTimeoutField REQUEST_TIMEOUT_FIELD;
    private static final ProxySettingsField PROXY_SETTINGS_RADIO_GROUP_FIELD;
    private static final ProxyHostField PROXY_HOST_FIELD;
    private static final ProxyPortField PROXY_PORT_FIELD;
    private static final TestConnectionActionDescriptor TEST_CONNECTION_ACTION_DESCRIPTOR;
    private static final GetRiskPolicySetsActionDescriptor GET_RISK_POLICY_SETS_ACTION_DESCRIPTOR;
    private static final GetRiskPredictorsActionDescriptor GET_RISK_PREDICTORS_ACTION_DESCRIPTOR;

    public static AdapterConfigurationGuiDescriptor makeAdapterConfigurationGuiDescriptor() {
        return PingOneRiskManagementAdapterConfiguration.makeAdapterConfigurationGuiDescriptor(null);
    }

    public static AdapterConfigurationGuiDescriptor makeAdapterConfigurationGuiDescriptor(Configuration configuration) {
        AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor = new AdapterConfigurationGuiDescriptor();
        adapterConfigurationGuiDescriptor.setDescription("The PingOne Risk Management Adapter sends device profile and transaction information to PingOne Risk Management. PingOne Risk Management evaluates the security risk and returns a risk level for the transaction. This allows PingFederate to make intelligent policy decisions based on risk level.");
        adapterConfigurationGuiDescriptor.addTable((TableDescriptor)OPTIONAL_USER_ATTRIBUTES_TABLE);
        adapterConfigurationGuiDescriptor.addTable((TableDescriptor)OPTIONAL_PREDICTORS_TABLE);
        adapterConfigurationGuiDescriptor.addTable((TableDescriptor)API_RESPONSE_MAPPINGS_TABLE);
        if (supportsPingOneEnvironmentFieldDescriptor) {
            adapterConfigurationGuiDescriptor.addField(PingOneEnvironmentField.newPingOneEnvironmentField());
            if (configuration == null || PingOneEnvironmentField.isConfigured(configuration)) {
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)new PingOneRiskPolicyField(configuration));
                adapterConfigurationGuiDescriptor.addPreRenderCallback((PreRenderCallback)new RiskPolicyPreRenderCallback());
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)EnvIdField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)RegionField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)ClientIdField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)ClientSecretField.hiddenInstance());
                adapterConfigurationGuiDescriptor.addField((FieldDescriptor)RiskPolicySetIdField.hiddenInstance());
            }
        }
        if (!supportsPingOneEnvironmentFieldDescriptor || configuration != null && !PingOneEnvironmentField.isConfigured(configuration)) {
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)ENV_ID_FIELD);
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)new RegionField(configuration));
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)CLIENT_ID_FIELD);
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)CLIENT_SECRET_FIELD);
            adapterConfigurationGuiDescriptor.addField((FieldDescriptor)RISK_POLICY_SET_NAME_FIELD);
        }
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)INCLUDE_DEVICE_PROFILE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)DEVICE_PROFILING_METHOD_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)DEVICE_PROFILING_TIMEOUT_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)COOKIE_NAME_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)FAILURE_MODE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)FALLBACK_VALUE_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)REQUEST_TIMEOUT_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PROXY_SETTINGS_RADIO_GROUP_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PROXY_HOST_FIELD);
        adapterConfigurationGuiDescriptor.addAdvancedField((FieldDescriptor)PROXY_PORT_FIELD);
        adapterConfigurationGuiDescriptor.addValidator((ConfigurationValidator)new ProxyConfigurationValidator());
        adapterConfigurationGuiDescriptor.addValidator((ConfigurationValidator)new FallbackConfigurationValidator());
        adapterConfigurationGuiDescriptor.addValidator(conf -> {
            if (PingOneEnvironmentField.isConfigured(conf)) {
                try {
                    Class<?> pingOneEnvironmentValidatorClass = Class.forName("org.sourceid.saml20.adapter.gui.validation.impl.PingOneEnvironmentValidator");
                    Constructor<?> pingOneEnvironmentValidatorConstructor = pingOneEnvironmentValidatorClass.getConstructor(new Class[0]);
                    Object pingOneEnvironmentValidator = pingOneEnvironmentValidatorConstructor.newInstance(new Object[0]);
                    Method addValidatorMethod = pingOneEnvironmentValidatorClass.getMethod("validate", Field.class);
                    addValidatorMethod.invoke(pingOneEnvironmentValidator, conf.getField("PingOne Environment"));
                    return;
                }
                catch (InvocationTargetException e) {
                    if (!(e.getTargetException() instanceof ValidationException)) return;
                    throw (ValidationException)e.getTargetException();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException reflectiveOperationException) {
                    return;
                }
            } else {
                if (!PingOneEnvironmentField.isConfigured(configuration) && PingOneRiskManagementAdapterConfiguration.legacyPingOneFieldsAreConfigured(conf)) return;
                throw new ValidationException("'PingOne Environment' is required.");
            }
        });
        adapterConfigurationGuiDescriptor.addAction((ActionDescriptor)TEST_CONNECTION_ACTION_DESCRIPTOR);
        adapterConfigurationGuiDescriptor.addAction((ActionDescriptor)GET_RISK_POLICY_SETS_ACTION_DESCRIPTOR);
        adapterConfigurationGuiDescriptor.addAction((ActionDescriptor)GET_RISK_PREDICTORS_ACTION_DESCRIPTOR);
        return adapterConfigurationGuiDescriptor;
    }

    public static boolean containsField(AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor, String fieldName) {
        return adapterConfigurationGuiDescriptor.getFields().stream().anyMatch(it -> fieldName.equals(it.getName()));
    }

    public static FieldDescriptor getField(AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor, String name) {
        return adapterConfigurationGuiDescriptor.getFields().stream().filter(it -> name.equals(it.getName())).findFirst().orElse(null);
    }

    public static boolean supportsPingOneEnvironmentFieldDescriptor() {
        return supportsPingOneEnvironmentFieldDescriptor;
    }

    public static boolean legacyPingOneFieldsAreConfigured(Configuration configuration) {
        return EnvIdField.isConfigured(configuration) && RegionField.isConfigured(configuration) && ClientIdField.isConfigured(configuration) && ClientSecretField.isConfigured(configuration);
    }

    static {
        try {
            Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
            supportsPingOneEnvironmentFieldDescriptor = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPingOneEnvironmentFieldDescriptor = false;
        }
        OPTIONAL_USER_ATTRIBUTES_TABLE = new OptionalUserAttributesTable();
        OPTIONAL_PREDICTORS_TABLE = new OptionalPredictorsTable();
        API_RESPONSE_MAPPINGS_TABLE = new ApiResponseMappingsTable();
        ENV_ID_FIELD = new EnvIdField();
        CLIENT_ID_FIELD = new ClientIdField();
        CLIENT_SECRET_FIELD = new ClientSecretField();
        RISK_POLICY_SET_NAME_FIELD = new RiskPolicySetIdField();
        INCLUDE_DEVICE_PROFILE_FIELD = new IncludeDeviceProfileField();
        DEVICE_PROFILING_METHOD_FIELD = new DeviceProfilingMethodField();
        DEVICE_PROFILING_TIMEOUT_FIELD = new DeviceProfilingTimeoutField();
        COOKIE_NAME_FIELD = new CookieNamePrefixField();
        FAILURE_MODE_FIELD = new FailureModeField();
        FALLBACK_VALUE_FIELD = new FallbackValueField();
        REQUEST_TIMEOUT_FIELD = new RequestTimeoutField();
        PROXY_SETTINGS_RADIO_GROUP_FIELD = new ProxySettingsField();
        PROXY_HOST_FIELD = new ProxyHostField();
        PROXY_PORT_FIELD = new ProxyPortField();
        TEST_CONNECTION_ACTION_DESCRIPTOR = new TestConnectionActionDescriptor();
        GET_RISK_POLICY_SETS_ACTION_DESCRIPTOR = new GetRiskPolicySetsActionDescriptor();
        GET_RISK_PREDICTORS_ACTION_DESCRIPTOR = new GetRiskPredictorsActionDescriptor();
    }

    public static class GetRiskPredictorsActionDescriptor
    extends ActionDescriptor {
        private GetRiskPredictorsActionDescriptor() {
            super("Get risk predictors", "Get available risk predictor attributes from PingOne Risk.", (ActionDescriptor.Action)new GetRiskPredictorsAction());
        }
    }

    public static class GetRiskPolicySetsActionDescriptor
    extends ActionDescriptor {
        private GetRiskPolicySetsActionDescriptor() {
            super("Get risk policies", "Get available risk policies from PingOne Risk Management.", (ActionDescriptor.Action)new GetRiskPolicySetsAction());
        }
    }

    public static class TestConnectionActionDescriptor
    extends ActionDescriptor {
        private TestConnectionActionDescriptor() {
            super("Test PingOne Risk Management connection", "Perform a test connection to PingOne Risk Management to validate your configuration.", (ActionDescriptor.Action)new TestConnectionAction());
        }
    }

    public static class ProxyPortField
    extends TextFieldDescriptor {
        private ProxyPortField() {
            super("Custom Proxy Port", "The proxy server port to use when 'Proxy Settings' is set to 'Custom'.");
            this.addValidator((FieldValidator)new IntegerValidator(1, 65535), true);
        }

        public static int getProxyPort(Configuration configuration) {
            return configuration.getIntFieldValue("Custom Proxy Port");
        }
    }

    public static class ProxyHostField
    extends TextFieldDescriptor {
        private ProxyHostField() {
            super("Custom Proxy Host", "The proxy server hostname to use when 'Proxy Settings' is set to 'Custom'.");
        }

        public static String getProxyHost(Configuration configuration) {
            return configuration.getFieldValue("Custom Proxy Host");
        }
    }

    public static class ProxySettingsField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"No Proxy", "System Defaults", "Custom"};

        private ProxySettingsField() {
            super("Proxy Settings", "Defines proxy settings for outbound HTTP requests.", OPTION_VALUES);
            this.setDefaultValue("System Defaults");
        }

        public static String getProxySettings(Configuration configuration) {
            return configuration.getFieldValue("Proxy Settings");
        }
    }

    public static class RequestTimeoutField
    extends TextFieldDescriptor {
        private RequestTimeoutField() {
            super("API Request Timeout", "The amount of time in milliseconds that PingFederate allows when establishing a connection with PingOne or waiting for a response to a request. The default value is '2000'. A value of 0 disables the timeout.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.addValidator((FieldValidator)new IntegerValidator(0, Integer.MAX_VALUE));
            this.setDefaultValue("2000");
        }

        public static int getRequestTimeout(Configuration configuration) {
            return configuration.getIntFieldValue("API Request Timeout");
        }
    }

    public static class FallbackValueField
    extends TextFieldDescriptor {
        private FallbackValueField() {
            super("Fallback Policy Decision Value", "The risk result (for example, \"MEDIUM\", \"HIGH\", or \"unknown\") to use in the authentication policy when the PingOne Risk Management service is unavailable or an error occurs, and 'Failure Mode' is set to 'Continue with fallback policy decision'.");
            this.setDefaultValue(Result.Level.MEDIUM.toString());
        }

        public static String getFallbackValue(Configuration configuration) {
            return configuration.getFieldValue("Fallback Policy Decision Value");
        }
    }

    public static class FailureModeField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"Continue with fallback policy decision", "Fail"};

        private FailureModeField() {
            super("Failure Mode", "When PingOne Risk Management is unavailable or an error occurs, this setting determines whether the user's sign-on attempt should fail or continue with a pre-determined policy decision.", OPTION_VALUES);
            this.setDefaultValue("Continue with fallback policy decision");
        }

        public static String getFailureMode(Configuration configuration) {
            return configuration.getFieldValue("Failure Mode");
        }
    }

    public static class CookieNamePrefixField
    extends TextFieldDescriptor {
        private CookieNamePrefixField() {
            super("Cookie Name Prefix", "The name prefix of the cookie(s) that contains the device profile captured by a previous adapter. Applies only if 'Device Profiling Method' is 'Captured by a previous adapter'. The default value is pingone.risk.device.profile.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.setDefaultValue("pingone.risk.device.profile");
        }

        public static String getCookieNamePrefix(Configuration configuration) {
            return configuration.getFieldValue("Cookie Name Prefix");
        }
    }

    public static class DeviceProfilingTimeoutField
    extends TextFieldDescriptor {
        private DeviceProfilingTimeoutField() {
            super("Device Profiling Timeout", "The amount of time in milliseconds that PingFederate waits for the device profiling script to collect device details. Applies only if 'Device Profiling Method' is 'Captured by this adapter'.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.setDefaultValue("5000");
        }

        public static int getDeviceProfilingTimeout(Configuration configuration) {
            return configuration.getIntFieldValue("Device Profiling Timeout");
        }
    }

    public static class DeviceProfilingMethodField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"Captured by this adapter", "Captured by a previous adapter"};

        private DeviceProfilingMethodField() {
            super("Device Profiling Method", "When 'Include Device Profile' is enabled, this setting determines whether the adapter will collect the device profile itself, or look for a device profile provided by another adapter that appears earlier in the authentication flow.\nIf you manually added the device profiling script to an authentication page, select 'Captured by a previous adapter'.\nOtherwise, select 'Captured by this adapter'.", OPTION_VALUES);
            this.setDefaultValue("Captured by this adapter");
        }

        public static String getDeviceProfilingMethod(Configuration configuration) {
            return configuration.getFieldValue("Device Profiling Method");
        }
    }

    public static class IncludeDeviceProfileField
    extends CheckBoxFieldDescriptor {
        public IncludeDeviceProfileField() {
            super("Include Device Profile", "When enabled, PingFederate will include a device profile in the risk evaluation.");
            this.setDefaultValue(true);
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static boolean isIncludeDeviceProfile(Configuration configuration) {
            return configuration.getBooleanFieldValue("Include Device Profile");
        }
    }

    public static class RiskPolicySetIdField
    extends TextFieldDescriptor {
        private RiskPolicySetIdField(String description) {
            super("Risk Policy ID", description);
        }

        public RiskPolicySetIdField() {
            this("The risk policy used by PingOne for the risk evaluation. Overrides the environment and global default policy selections.");
        }

        public static RiskPolicySetIdField hiddenInstance() {
            RiskPolicySetIdField riskPolicySetIdField = new RiskPolicySetIdField("The risk policy used by PingOne for the risk evaluation. Overrides the environment and global default policy selections. Deprecated. Replaced by 'PingOne Risk Policy'.");
            riskPolicySetIdField.setHidden(true);
            return riskPolicySetIdField;
        }

        public static String getRiskPolicySetId(Configuration configuration) {
            String value = configuration.getFieldValue("Risk Policy ID");
            return value != null ? value.trim() : null;
        }
    }

    public static class RegionField
    extends SelectFieldDescriptor {
        private static final List<AbstractSelectionFieldDescriptor.OptionValue> OPTION_VALUES = Arrays.stream(Region.values()).map(region -> new AbstractSelectionFieldDescriptor.OptionValue(region.getName(), region.getValue())).collect(Collectors.toList());

        private RegionField(String description) {
            super("Region", description, OPTION_VALUES);
        }

        public RegionField(Configuration configuration) {
            this("The region shown in your environment properties on the PingOne console. This determines which PingOne API service endpoints are used.");
            Region region = RegionField.getRegion(configuration);
            this.setDefaultValue(region.getValue());
            this.setDefaultForLegacyConfig(region.getValue());
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static RegionField hiddenInstance() {
            RegionField regionField = new RegionField("The region shown in your environment properties on the PingOne console. This determines which PingOne API service endpoints are used. Deprecated. Replaced by 'PingOne Environment'.");
            regionField.setHidden(true);
            return regionField;
        }

        public static Region getRegion(Configuration configuration) {
            Region region;
            if (configuration == null) {
                region = Region.getDefault();
            } else {
                String value = configuration.getFieldValue("Region");
                region = Region.fromValue(value);
            }
            return region;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotBlank(configuration.getFieldValue("Region"));
        }
    }

    public static class ClientSecretField
    extends TextFieldDescriptor {
        private ClientSecretField(String description) {
            super("PingFederate Connection Client Secret", description, true);
        }

        public ClientSecretField() {
            this("The client secret for your PingFederate connection in PingOne.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static ClientSecretField hiddenInstance() {
            ClientSecretField clientSecretField = new ClientSecretField("The client secret for your PingFederate connection in PingOne. Deprecated. Replaced by 'PingOne Environment'.");
            clientSecretField.setHidden(true);
            return clientSecretField;
        }

        public static String getClientSecret(Configuration configuration) {
            String value = configuration.getFieldValue("PingFederate Connection Client Secret");
            return value != null ? value.trim() : null;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotBlank(ClientSecretField.getClientSecret(configuration));
        }
    }

    public static class ClientIdField
    extends TextFieldDescriptor {
        private ClientIdField(String description) {
            super("PingFederate Connection Client ID", description);
        }

        public ClientIdField() {
            this("The client ID for your PingFederate connection in PingOne.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static ClientIdField hiddenInstance() {
            ClientIdField clientIdField = new ClientIdField("The client ID for your PingFederate connection in PingOne. Deprecated. Replaced by 'PingOne Environment'.");
            clientIdField.setHidden(true);
            return clientIdField;
        }

        public static String getClientId(Configuration configuration) {
            String value = configuration.getFieldValue("PingFederate Connection Client ID");
            return value != null ? value.trim() : null;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotBlank(ClientIdField.getClientId(configuration));
        }
    }

    public static class EnvIdField
    extends TextFieldDescriptor {
        private EnvIdField(String description) {
            super("Environment ID", description);
        }

        public EnvIdField() {
            this("Your PingOne environment ID.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static EnvIdField hiddenInstance() {
            EnvIdField envIdField = new EnvIdField("Your PingOne environment ID. Deprecated. Replaced by 'PingOne Environment'.");
            envIdField.setHidden(true);
            return envIdField;
        }

        public static String getEnvId(Configuration configuration) {
            String value = configuration.getFieldValue("Environment ID");
            return value != null ? value.trim() : null;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotBlank(EnvIdField.getEnvId(configuration));
        }
    }

    public static class PingOneRiskPolicyField
    extends SelectFieldDescriptor {
        public PingOneRiskPolicyField(Configuration configuration) {
            super("PingOne Risk Policy", "The risk policy used by PingOne for the risk evaluation. Overrides the environment and global default policy selections. This list is populated when you select a PingOne Environment.");
            String defaultValue = PingOneRiskPolicyField.getRiskPolicyId(configuration);
            this.setDefaultValue(defaultValue);
            this.setDefaultForLegacyConfig(defaultValue);
        }

        public static String getRiskPolicyId(Configuration configuration) {
            String value;
            if (configuration == null) {
                value = null;
            } else {
                value = configuration.getFieldValue("PingOne Risk Policy");
                if (value == null) {
                    value = RiskPolicySetIdField.getRiskPolicySetId(configuration);
                }
            }
            return value;
        }
    }

    public static class PingOneEnvironmentField {
        public static FieldDescriptor newPingOneEnvironmentField() {
            try {
                Class<?> pingOneEnvironmentFieldClass = Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
                Constructor<?> pingOneEnvironmentFieldConstructor = pingOneEnvironmentFieldClass.getConstructor(String.class, String.class);
                return (FieldDescriptor)pingOneEnvironmentFieldConstructor.newInstance("PingOne Environment", "Your PingOne environment. Create connections in System > External Systems > PingOne Connections.");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String getPingOneEnvironment(Configuration configuration) {
            return configuration.getFieldValue("PingOne Environment");
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotEmpty(PingOneEnvironmentField.getPingOneEnvironment(configuration));
        }
    }

    public static class ApiResponseMappingsTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new LocalAttributeField(), new ApiAttributeMappingField()});

        public ApiResponseMappingsTable() {
            super("PingOne Risk API Response Mappings (optional)", "Define local attributes to include in the attribute contract, and map them to a value from the PingOne Risk Management response payload using JSON Pointer (RFC 6901) syntax. Click 'Add a new row ...' to add multiple entries.", ROW);
            this.addValidator((RowValidator)new EnhancedRowValidator(){

                public void validate(FieldList fieldsInRow, Configuration configuration) throws ValidationException {
                    String localAttribute;
                    Predicate<Row> isDuplicate;
                    Table optionalIdwAttributesTable = configuration.getTable("PingOne Risk API Response Mappings (optional)");
                    if (ValidatorUtil.duplicates(optionalIdwAttributesTable, isDuplicate = arg_0 -> 1.lambda$validate$0(localAttribute = fieldsInRow.getFieldValue("Local Attribute"), arg_0))) {
                        throw new ValidationException("Local attributes must be unique.");
                    }
                }

                public void validate(FieldList fieldList) throws ValidationException {
                }

                private static /* synthetic */ boolean lambda$validate$0(String localAttribute, Row row) {
                    return localAttribute.equals(row.getFieldValue("Local Attribute"));
                }
            });
        }

        public static Map<String, String> getApiResponseMappings(Configuration configuration) {
            return configuration.getTable("PingOne Risk API Response Mappings (optional)").getRows().stream().collect(Collectors.toMap(row -> row.getFieldValue("Local Attribute"), row -> row.getFieldValue("PingOne Risk API Attribute Mapping")));
        }
    }

    public static class ApiAttributeMappingField
    extends TextFieldDescriptor {
        private ApiAttributeMappingField() {
            super("PingOne Risk API Attribute Mapping", null);
            this.addValidator(new JsonPointerValidator());
        }
    }

    public static class LocalAttributeField
    extends TextFieldDescriptor {
        private LocalAttributeField() {
            super("Local Attribute", null);
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }
    }

    public static class OptionalPredictorsTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new LocalPredictorAttributeField(), new RiskPredictorNameField()});

        private OptionalPredictorsTable() {
            super("Additional Risk Predictors (optional)", "Optionally, you can send risk predictors to PingOne Risk for evaluation. To populate these PingOne Risk Predictors, map them to attributes that are passed to this adapter instance from any source that appears earlier in your PingFederate authentication policy. ", ROW);
            this.addValidator((RowValidator)new TableUniqueKeyValidator("Additional Risk Predictors (optional)", "Incoming Attribute Name"));
            this.addValidator((RowValidator)new TableUniqueKeyValidator("Additional Risk Predictors (optional)", "PingOne Risk Attribute"));
            this.addValidator((RowValidator)new PredictorAttributeMappingValidator("Additional Risk Predictors (optional)", "PingOne Risk Attribute"));
        }

        public static Map<String, String> getOptionalPredictorsMapping(Configuration configuration) {
            if (null != configuration.getTable("Additional Risk Predictors (optional)")) {
                return configuration.getTable("Additional Risk Predictors (optional)").getRows().stream().collect(Collectors.toMap(row -> row.getFieldValue("Incoming Attribute Name"), row -> row.getFieldValue("PingOne Risk Attribute")));
            }
            return Collections.emptyMap();
        }
    }

    public static class RiskPredictorNameField
    extends TextFieldDescriptor {
        private RiskPredictorNameField() {
            super("PingOne Risk Attribute", "The PingOne Risk attribute that will be assessed in the risk policy, such as ${event.isManaged}. ");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }
    }

    public static class LocalPredictorAttributeField
    extends TextFieldDescriptor {
        private LocalPredictorAttributeField() {
            super("Incoming Attribute Name", "The PingFederate authentication policy attribute used to populate the PingOne Risk attribute.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }
    }

    public static class OptionalUserAttributesTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new IncomingAttributeNameField(), new UserAttributeField()});

        private OptionalUserAttributesTable() {
            super("Additional User Attributes (optional)", "Optionally, you can send additional attributes to PingOne Risk Management for verification. To populate these parameters, map them to attributes that are passed to this adapter instance from any source that appears earlier in your PingFederate authentication policy.", ROW);
            this.addValidator((RowValidator)new OptionalUserAttributesValidator());
        }

        public static Map<String, OptionalUserAttribute> getOptionalUserAttributesMapping(Configuration configuration) {
            return configuration.getTable("Additional User Attributes (optional)").getRows().stream().collect(Collectors.toMap(row -> row.getFieldValue("Incoming Attribute Name"), row -> OptionalUserAttribute.fromValue(row.getFieldValue("PingOne Risk Management Attribute"))));
        }
    }

    public static class UserAttributeField
    extends SelectFieldDescriptor {
        private static final List<AbstractSelectionFieldDescriptor.OptionValue> OPTION_VALUES = Arrays.asList(new AbstractSelectionFieldDescriptor.OptionValue(SelectFieldDescriptor.SELECT_ONE.getName(), SelectFieldDescriptor.SELECT_ONE.getValue()), new AbstractSelectionFieldDescriptor.OptionValue(OptionalUserAttribute.USER_GROUPS.getName(), OptionalUserAttribute.USER_GROUPS.getValue()));

        private UserAttributeField() {
            super("PingOne Risk Management Attribute", null, OPTION_VALUES);
        }
    }

    public static class IncomingAttributeNameField
    extends TextFieldDescriptor {
        private IncomingAttributeNameField() {
            super("Incoming Attribute Name", null);
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }
    }
}

