/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import com.pingidentity.adapters.pingone.risk.ChunkUtil;
import com.pingidentity.adapters.pingone.risk.CompletionStatus;
import com.pingidentity.adapters.pingone.risk.CoreContract;
import com.pingidentity.adapters.pingone.risk.DeviceProfile;
import com.pingidentity.adapters.pingone.risk.FlowType;
import com.pingidentity.adapters.pingone.risk.HttpClientBuilder;
import com.pingidentity.adapters.pingone.risk.LogCleaner;
import com.pingidentity.adapters.pingone.risk.ObjectMappers;
import com.pingidentity.adapters.pingone.risk.OptionalUserAttribute;
import com.pingidentity.adapters.pingone.risk.PingOneRiskManagementAdapterConfiguration;
import com.pingidentity.adapters.pingone.risk.PingOneRiskManagementAdapterTemplateSupport;
import com.pingidentity.adapters.pingone.risk.ReflectivePingOneEnvironmentAccessor;
import com.pingidentity.adapters.pingone.risk.Region;
import com.pingidentity.adapters.pingone.risk.RiskEvaluation;
import com.pingidentity.adapters.pingone.risk.RiskEvent;
import com.pingidentity.adapters.pingone.risk.RiskService;
import com.pingidentity.adapters.pingone.risk.SessionStateSupportWrapper;
import com.pingidentity.adapters.pingone.risk.TokenProviderException;
import com.pingidentity.adapters.pingone.risk.TokenService;
import com.pingidentity.adapters.pingone.risk.api.RiskApiClient;
import com.pingidentity.adapters.pingone.risk.api.RiskServiceException;
import com.pingidentity.adapters.pingone.risk.api.TokenApiClient;
import com.pingidentity.adapters.pingone.risk.api.TokenServiceException;
import com.pingidentity.adapters.pingone.risk.api.authn.PingOneRiskManagementAdapterAuthnApiSupport;
import com.pingidentity.adapters.pingone.risk.api.authn.StateSpec;
import com.pingidentity.adapters.pingone.risk.api.authn.SubmitDeviceProfile;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.commons.codec.binary.Base64;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.fluent.Executor;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.pingidentity.adapters.pingone.risk.util.PredictorAttributeMappingUtil;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.TransactionAwareAuthenticationAdapter;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.exception.AuthnErrorException;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.util.log.AttributeMap;

public class PingOneRiskManagementIdpAdapter
implements IdpAuthenticationAdapterV2,
TransactionAwareAuthenticationAdapter,
AuthnApiPlugin {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(PingOneRiskManagementIdpAdapter.class);
    private static boolean supportsSetMetadata;
    private static boolean supportsPluginServiceAssociation;
    private AuthnApiSupport authnApiSupport = AuthnApiSupport.getDefault();
    private final PingOneRiskManagementAdapterAuthnApiSupport p1RiskManagementAdapterAuthnApiSupport = new PingOneRiskManagementAdapterAuthnApiSupport();
    private final SessionStateSupportWrapper sessionStateSupportWrapper;
    private String instanceId;
    private Map<String, OptionalUserAttribute> optionalUserAttributesMapping;
    private Map<String, String> predictorsMapping;
    private Map<String, String> apiResponseMappings;
    private String pingOneEnvironment;
    private ReflectivePingOneEnvironmentAccessor pingOneEnvironmentAccessor;
    private String envId;
    private String clientId;
    private String clientSecret;
    private String authEndpoint;
    private String apiEndpoint;
    private String riskPolicySetId;
    private boolean includeDeviceProfile;
    private String deviceProfilingMethod;
    private int deviceProfilingTimeout;
    private String cookieNamePrefix;
    private String failureMode;
    private String fallbackValue;
    private int requestTimeout;
    private String proxySettings;
    private String proxyHost;
    private int proxyPort;
    private RiskService riskService;
    private static final String BROWSER_ID_COOKIE_NAME = "pingone.risk.browser.profile";

    public PingOneRiskManagementIdpAdapter() {
        this.sessionStateSupportWrapper = new SessionStateSupportWrapper(new SessionStateSupport());
    }

    public PingOneRiskManagementIdpAdapter(Configuration configuration, SessionStateSupportWrapper sessionStateSupportWrapper, RiskService riskService, AuthnApiSupport authnApiSupport) {
        this.configureInternalState(configuration);
        this.sessionStateSupportWrapper = sessionStateSupportWrapper;
        this.riskService = riskService;
        this.authnApiSupport = authnApiSupport;
    }

    public void configure(Configuration configuration) {
        this.configureInternalState(configuration);
        this.configureRiskService();
    }

    public AuthnAdapterResponse lookupAuthN(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws AuthnAdapterException, IOException {
        AuthnAdapterResponse authnAdapterResponse;
        block6: {
            authnAdapterResponse = new AuthnAdapterResponse();
            String username = RiskEventExtractor.getUsername(inParameters);
            if (StringUtils.isBlank(username)) {
                LOGGER.log(com.pingidentity.adapters.pingone.risk.LogEvent.NO_USERNAME_ERROR);
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                return authnAdapterResponse;
            }
            String status = this.getStatus();
            if (!this.authnApiSupport.isApiRequest(req) || req.getMethod().equals("GET") || this.p1RiskManagementAdapterAuthnApiSupport.isValidP1RiskManagementAdapterAuthnApiPost(req, resp, status)) {
                try {
                    if (this.isSubmitDeviceProfileRequest(req)) {
                        authnAdapterResponse = this.handleSubmitDeviceProfileRequest(req, resp, inParameters);
                        break block6;
                    }
                    authnAdapterResponse = this.handleStatusRequest(req, resp, status, inParameters);
                }
                catch (AuthnErrorException e) {
                    authnAdapterResponse = this.handleAuthnErrorException(req, resp, e);
                }
            } else {
                authnAdapterResponse = new AuthnAdapterResponse();
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            }
        }
        return authnAdapterResponse;
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        IdpAuthnAdapterDescriptor descriptor = new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, "PingOne Risk Management IdP Adapter 1.2.1", this.getContract(), true, PingOneRiskManagementAdapterConfiguration.makeAdapterConfigurationGuiDescriptor(), false){

            public GuiConfigDescriptorBuilder getGuiConfigDescriptorBuilder() {
                return new GuiConfigDescriptorBuilder(){

                    public GuiConfigDescriptor buildNewGuiDescriptor() {
                        return PingOneRiskManagementAdapterConfiguration.makeAdapterConfigurationGuiDescriptor();
                    }

                    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
                        return PingOneRiskManagementAdapterConfiguration.makeAdapterConfigurationGuiDescriptor(configuration);
                    }
                };
            }
        };
        if (supportsSetMetadata && supportsPluginServiceAssociation) {
            try {
                Class<?> pluginMetadataKeysClass = Class.forName("com.pingidentity.sdk.PluginMetadataKeys");
                Class<?> pluginServiceAssociationClass = Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
                Constructor<?> pluginServiceAssociationConstructor = pluginServiceAssociationClass.getConstructor(String.class, String.class);
                descriptor.setMetadata(Collections.singletonMap((String)pluginMetadataKeysClass.getField("PING_ONE_SERVICE_ASSOCIATION").get(null), pluginServiceAssociationConstructor.newInstance("Risk Adapter", pluginServiceAssociationClass.getField("RISK_SERVICE_DISPLAY_NAME").get(null))));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return descriptor;
    }

    public Map lookupAuthN(HttpServletRequest req, HttpServletResponse resp, String spPartnerEntityId, AuthnPolicy authnPolicy, String resumePath) throws AuthnAdapterException, IOException {
        return null;
    }

    public boolean logoutAuthN(Map map, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        return true;
    }

    public Map<String, Object> getAdapterInfo() {
        return null;
    }

    public boolean isDeferAuthenticationSessionRegistration() {
        return false;
    }

    public void onTransactionComplete(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> authnIdentifiersMap, AttributeMap policyResultMap) {
        this.sendTransactionStatus(req, resp, CompletionStatus.SUCCESS);
    }

    public void onTransactionFailure(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> authnIdentifiersMap) {
        this.sendTransactionStatus(req, resp, CompletionStatus.FAILED);
    }

    private void sendTransactionStatus(HttpServletRequest req, HttpServletResponse resp, CompletionStatus completionStatus) {
        String riskEvaluationId = (String)this.sessionStateSupportWrapper.getAttribute(this.instanceId + ".riskEvaluationId", req, resp);
        LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.BEGIN_RISK_FEEDBACK, riskEvaluationId);
        this.sessionStateSupportWrapper.removeAttribute(this.instanceId + ".riskEvaluationId", req, resp);
        try {
            if (StringUtils.isNotBlank(riskEvaluationId)) {
                this.riskService.feedbackRisk(riskEvaluationId, completionStatus);
                LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.SUCCESSFUL_RISK_FEEDBACK, riskEvaluationId, completionStatus.name());
            }
        }
        catch (Exception e) {
            String riskEvaluationId1 = riskEvaluationId;
            riskEvaluationId1 = LogCleaner.clean(riskEvaluationId1);
            LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.RISK_FEEDBACK_ERROR, riskEvaluationId1);
            LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.RISK_FEEDBACK_TRACE, e);
        }
    }

    public PluginApiSpec getApiSpec() {
        List<AuthnStateSpec<?>> authnStateSpecs = PingOneRiskManagementAdapterAuthnApiSupport.getAuthnStateSpecs();
        return new PluginApiSpec(authnStateSpecs);
    }

    private Set<String> getContract() {
        return Arrays.stream(CoreContract.values()).map(CoreContract::toString).collect(Collectors.toSet());
    }

    private void configureInternalState(Configuration configuration) {
        this.instanceId = configuration.getId();
        this.optionalUserAttributesMapping = PingOneRiskManagementAdapterConfiguration.OptionalUserAttributesTable.getOptionalUserAttributesMapping(configuration);
        this.predictorsMapping = PingOneRiskManagementAdapterConfiguration.OptionalPredictorsTable.getOptionalPredictorsMapping(configuration);
        this.apiResponseMappings = PingOneRiskManagementAdapterConfiguration.ApiResponseMappingsTable.getApiResponseMappings(configuration);
        if (PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration)) {
            this.pingOneEnvironment = PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
            this.pingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(this.pingOneEnvironment);
            this.envId = this.pingOneEnvironmentAccessor.getEnvironmentId();
            this.riskPolicySetId = PingOneRiskManagementAdapterConfiguration.PingOneRiskPolicyField.getRiskPolicyId(configuration);
            this.authEndpoint = this.pingOneEnvironmentAccessor.getAuthenticationEndpoint(false);
            this.apiEndpoint = this.pingOneEnvironmentAccessor.getManagementEndpoint();
        } else {
            this.envId = PingOneRiskManagementAdapterConfiguration.EnvIdField.getEnvId(configuration);
            this.clientId = PingOneRiskManagementAdapterConfiguration.ClientIdField.getClientId(configuration);
            this.clientSecret = PingOneRiskManagementAdapterConfiguration.ClientSecretField.getClientSecret(configuration);
            this.riskPolicySetId = PingOneRiskManagementAdapterConfiguration.RiskPolicySetIdField.getRiskPolicySetId(configuration);
            Region region = PingOneRiskManagementAdapterConfiguration.RegionField.getRegion(configuration);
            this.authEndpoint = region.getAuthEndpoint();
            this.apiEndpoint = region.getApiEndpoint();
        }
        this.includeDeviceProfile = PingOneRiskManagementAdapterConfiguration.IncludeDeviceProfileField.isIncludeDeviceProfile(configuration);
        this.deviceProfilingMethod = PingOneRiskManagementAdapterConfiguration.DeviceProfilingMethodField.getDeviceProfilingMethod(configuration);
        this.deviceProfilingTimeout = PingOneRiskManagementAdapterConfiguration.DeviceProfilingTimeoutField.getDeviceProfilingTimeout(configuration);
        this.cookieNamePrefix = PingOneRiskManagementAdapterConfiguration.CookieNamePrefixField.getCookieNamePrefix(configuration);
        this.failureMode = PingOneRiskManagementAdapterConfiguration.FailureModeField.getFailureMode(configuration);
        this.fallbackValue = PingOneRiskManagementAdapterConfiguration.FallbackValueField.getFallbackValue(configuration);
        this.requestTimeout = PingOneRiskManagementAdapterConfiguration.RequestTimeoutField.getRequestTimeout(configuration);
        this.proxySettings = PingOneRiskManagementAdapterConfiguration.ProxySettingsField.getProxySettings(configuration);
        this.proxyHost = PingOneRiskManagementAdapterConfiguration.ProxyHostField.getProxyHost(configuration);
        this.proxyPort = PingOneRiskManagementAdapterConfiguration.ProxyPortField.getProxyPort(configuration);
    }

    private void configureRiskService() {
        CloseableHttpClient httpClient = new HttpClientBuilder().setRequestTimeout(this.requestTimeout).setProxySettings(this.proxySettings).setProxyHost(this.proxyHost).setProxyPort(this.proxyPort).build();
        Executor executor = Executor.newInstance(httpClient);
        TokenService tokenService = new TokenService(() -> {
            try {
                if (this.pingOneEnvironmentAccessor != null) {
                    return this.pingOneEnvironmentAccessor.getAccessToken();
                }
                TokenApiClient tokenApiClient = new TokenApiClient(executor, this.authEndpoint, this.envId, this.clientId, this.clientSecret);
                return tokenApiClient.requestToken().getAccessToken();
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new TokenProviderException("Error requesting access token", e);
            }
        }, this.pingOneEnvironmentAccessor != null ? this.pingOneEnvironment : this.clientId);
        RiskApiClient riskApiClient = new RiskApiClient(executor, this.apiEndpoint, this.envId);
        this.riskService = new RiskService(tokenService, riskApiClient, this.apiResponseMappings, this.riskPolicySetId);
    }

    private boolean isSubmitDeviceProfileRequest(HttpServletRequest req) {
        return this.p1RiskManagementAdapterAuthnApiSupport.isSubmitDeviceProfileRequest(req) || PingOneRiskManagementAdapterTemplateSupport.isSubmitDeviceProfileRequest(req);
    }

    private String getStatus() {
        return StateSpec.DEVICE_PROFILE_REQUIRED.getStatus();
    }

    private AuthnAdapterResponse handleStatusRequest(HttpServletRequest req, HttpServletResponse resp, String status, Map<String, Object> inParameters) throws IOException, AuthnAdapterException, AuthnErrorException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        boolean isApiRequest = this.authnApiSupport.isApiRequest(req);
        if (StateSpec.DEVICE_PROFILE_REQUIRED.getStatus().equals(status)) {
            if (!this.includeDeviceProfile) {
                authnAdapterResponse = this.handleSubmitDeviceProfileRequest(req, resp, inParameters);
            } else if ("Captured by this adapter".equals(this.deviceProfilingMethod)) {
                if (isApiRequest) {
                    this.p1RiskManagementAdapterAuthnApiSupport.writeDeviceProfileRequiredResponse(req, resp, this.deviceProfilingTimeout);
                } else {
                    PingOneRiskManagementAdapterTemplateSupport.renderDeviceProfileTemplate(req, resp, inParameters, this.deviceProfilingTimeout);
                }
            } else {
                authnAdapterResponse = this.handleSubmitDeviceProfileRequest(req, resp, inParameters);
            }
        }
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleSubmitDeviceProfileRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws AuthnErrorException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        boolean isApiRequest = this.authnApiSupport.isApiRequest(req);
        RiskEvent riskEvent = RiskEventExtractor.extract(req, resp, inParameters, this.includeDeviceProfile, this.deviceProfilingMethod, this.cookieNamePrefix, this.optionalUserAttributesMapping, this.predictorsMapping, isApiRequest);
        LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.BEGIN_RISK_EVALUATION, riskEvent.getUsername());
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        try {
            RiskEvaluation riskEvaluation = this.riskService.evaluateRisk(riskEvent);
            String riskEvaluationId = riskEvaluation.getId();
            this.sessionStateSupportWrapper.setAttribute(this.instanceId + ".riskEvaluationId", riskEvaluationId, req, resp, false);
            if (riskEvaluation.getRiskLevel() != null) {
                String username = riskEvent.getUsername();
                if (StringUtils.isNotBlank(riskEvaluation.getRiskValue())) {
                    LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.RISK_EVALUATION_VALUE_INFO, username, riskEvaluation.getRiskLevel(), riskEvaluation.getRiskValue(), riskEvaluation.getId());
                } else {
                    LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.RISK_EVALUATION_LEVEL_INFO, username, riskEvaluation.getRiskLevel(), riskEvaluation.getId());
                }
                attributeMap.put(CoreContract.RISK_LEVEL.toString(), riskEvaluation.getRiskLevel());
            } else {
                LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.NO_RISK_RESULT, riskEvaluationId, riskEvent.getUsername());
                if ("Continue with fallback policy decision".equals(this.failureMode)) {
                    LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.USING_FALLBACK, riskEvent.getUsername(), this.fallbackValue);
                    attributeMap.put(CoreContract.RISK_LEVEL.toString(), this.fallbackValue);
                    attributeMap.put(CoreContract.RISK_VALUE.toString(), this.fallbackValue);
                } else {
                    LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.USING_FAILURE, riskEvent.getUsername());
                    authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                    return authnAdapterResponse;
                }
            }
            String riskValue = riskEvaluation.getRiskValue() != null ? riskEvaluation.getRiskValue() : "";
            attributeMap.put(CoreContract.RISK_VALUE.toString(), riskValue);
            if (!riskEvaluation.getApiResponseAttributes().isEmpty()) {
                attributeMap.putAll(riskEvaluation.getApiResponseAttributes());
            }
            authnAdapterResponse.setAttributeMap(attributeMap);
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
            return authnAdapterResponse;
        }
        catch (RiskServiceException | TokenServiceException e) {
            String username = riskEvent.getUsername();
            username = LogCleaner.clean(username);
            LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.RISK_EVALUATION_ERROR, username);
            LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.RISK_EVALUATION_TRACE, e);
            if ("Continue with fallback policy decision".equals(this.failureMode)) {
                LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.USING_FALLBACK, riskEvent.getUsername(), this.fallbackValue);
                attributeMap.put(CoreContract.RISK_LEVEL.toString(), this.fallbackValue);
                attributeMap.put(CoreContract.RISK_VALUE.toString(), this.fallbackValue);
                authnAdapterResponse.setAttributeMap(attributeMap);
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
            } else {
                LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.USING_FAILURE, riskEvent.getUsername());
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            }
            return authnAdapterResponse;
        }
    }

    private AuthnAdapterResponse handleAuthnErrorException(HttpServletRequest req, HttpServletResponse resp, AuthnErrorException e) throws IOException {
        this.authnApiSupport.writeErrorResponse(req, resp, e.getValidationError());
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    static {
        Method[] methods = PluginDescriptor.class.getMethods();
        if (Arrays.stream(methods).anyMatch(m -> "setMetadata".equals(m.getName()))) {
            supportsSetMetadata = true;
        }
        try {
            Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
            supportsPluginServiceAssociation = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPluginServiceAssociation = false;
        }
    }

    private static class RiskEventExtractor {
        private RiskEventExtractor() {
        }

        public static RiskEvent extract(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean includeDeviceProfile, String deviceProfilingMethod, String cookieNamePrefix, Map<String, OptionalUserAttribute> optionalUserAttributesMapping, Map<String, String> predictorsMapping, boolean isApiRequest) throws AuthnErrorException {
            String ipAddress = RiskEventExtractor.getIpAddress(req);
            String username = RiskEventExtractor.getUsername(inParameters);
            DeviceProfile deviceProfile = null;
            if (includeDeviceProfile) {
                deviceProfile = RiskEventExtractor.getDeviceProfile(req, resp, deviceProfilingMethod, cookieNamePrefix);
            }
            String targetResourceId = RiskEventExtractor.getTargetResourceId(inParameters);
            String targetResourceName = RiskEventExtractor.getTargetResourceName(inParameters);
            String flowType = RiskEventExtractor.getFlowType();
            String sessionId = RiskEventExtractor.getSessionId(inParameters);
            String sharingType = RiskEventExtractor.getSharingType(inParameters);
            String browserId = RiskEventExtractor.getBrowserId(req, resp, isApiRequest);
            Map<OptionalUserAttribute, AttributeValue> optionalUserAttributes = RiskEventExtractor.getOptionalUserAttributes(inParameters, optionalUserAttributesMapping);
            Map<String, AttributeValue> riskPredictors = RiskEventExtractor.getOptionalRiskPredictors(inParameters, predictorsMapping);
            return new RiskEvent.Builder().setIpAddress(ipAddress).setUsername(username).setDeviceProfile(deviceProfile).setTargetResourceId(targetResourceId).setTargetResourceName(targetResourceName).setFlowType(flowType).setSessionId(sessionId).setSharingType(sharingType).setBrowserId(browserId).setOptionalUserAttributes(optionalUserAttributes).setOptionalRiskPredictors(riskPredictors).build();
        }

        private static String getIpAddress(HttpServletRequest req) {
            return req.getRemoteAddr();
        }

        private static Optional<AttributeValue> getFromChainedAttributes(Map<String, Object> inParameters, String key) {
            Map chainedAttributes = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
            if (chainedAttributes != null && !chainedAttributes.isEmpty()) {
                return Optional.ofNullable(AttrValueSupport.make(chainedAttributes.get(key)));
            }
            LOGGER.log(com.pingidentity.adapters.pingone.risk.LogEvent.NO_CHAINED_ATTRIBUTES);
            return Optional.empty();
        }

        private static String getUsername(Map<String, Object> inParameters) {
            return (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        }

        private static DeviceProfile getDeviceProfile(HttpServletRequest req, HttpServletResponse resp, String deviceProfilingMethod, String cookieNamePrefix) throws AuthnErrorException {
            Optional<DeviceProfile> deviceProfile;
            if ("Captured by this adapter".equals(deviceProfilingMethod)) {
                if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                    deviceProfile = RiskEventExtractor.getDeviceProfile(req);
                    if (!deviceProfile.isPresent()) {
                        LOGGER.log(com.pingidentity.adapters.pingone.risk.LogEvent.DEVICE_PROFILE_ERROR_THIS_ADPT_AUTHN_API);
                    }
                } else {
                    String base64EncodedDeviceProfile = req.getParameter("pingone.risk.device.profile");
                    deviceProfile = RiskEventExtractor.getDeviceProfile(base64EncodedDeviceProfile);
                    if (!deviceProfile.isPresent()) {
                        LOGGER.log(com.pingidentity.adapters.pingone.risk.LogEvent.DEVICE_PROFILE_ERROR_THIS_ADPT);
                    }
                }
            } else {
                deviceProfile = RiskEventExtractor.getDeviceProfile(req, resp, cookieNamePrefix);
                if (!deviceProfile.isPresent()) {
                    LOGGER.log(com.pingidentity.adapters.pingone.risk.LogEvent.DEVICE_PROFILE_ERROR_PREV_ADPT);
                }
            }
            return deviceProfile.orElse(null);
        }

        private static Optional<DeviceProfile> getDeviceProfile(HttpServletRequest req) throws AuthnErrorException {
            Optional<DeviceProfile> deviceProfile = Optional.empty();
            try {
                SubmitDeviceProfile submitDeviceProfile = (SubmitDeviceProfile)((Object)AuthnApiSupport.getDefault().deserializeAsModel(req, SubmitDeviceProfile.class));
                deviceProfile = Optional.ofNullable(submitDeviceProfile.getDeviceProfile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return deviceProfile;
        }

        private static Optional<DeviceProfile> getDeviceProfile(HttpServletRequest req, HttpServletResponse resp, String cookieNamePrefix) {
            Cookie[] cookies = req.getCookies();
            String base64EncodedDeviceProfile = ChunkUtil.unchunkFromCookies(cookies, cookieNamePrefix);
            Arrays.stream(cookies).filter(cookie -> cookie.getName().startsWith(cookieNamePrefix)).forEach(cookie -> {
                cookie.setValue("");
                cookie.setPath("/");
                cookie.setMaxAge(0);
                resp.addCookie(cookie);
            });
            return RiskEventExtractor.getDeviceProfile(base64EncodedDeviceProfile);
        }

        private static Optional<DeviceProfile> getDeviceProfile(String base64EncodedDeviceProfile) {
            Optional<DeviceProfile> deviceProfile = Optional.empty();
            try {
                String rawDeviceProfile = new String(Base64.decodeBase64(base64EncodedDeviceProfile));
                deviceProfile = Optional.of(ObjectMappers.getDefault().readValue(rawDeviceProfile, DeviceProfile.class));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return deviceProfile;
        }

        private static String getTargetResourceId(Map<String, Object> inParameters) {
            String targetResourceId = "";
            String partnerEntityId = (String)inParameters.get("com.pingidentity.adapter.input.parameter.partner.entityid");
            String spAdapterId = (String)inParameters.get("com.pingidentity.adapter.input.parameter.sp.adapter.id");
            String oauthClientId = (String)inParameters.get("com.pingidentity.adapter.input.parameter.oauth.client.id");
            if (StringUtils.isNotBlank(partnerEntityId)) {
                targetResourceId = partnerEntityId;
            } else if (StringUtils.isNotBlank(spAdapterId)) {
                targetResourceId = spAdapterId;
            } else if (StringUtils.isNotBlank(oauthClientId)) {
                targetResourceId = oauthClientId;
            }
            return targetResourceId;
        }

        private static String getTargetResourceName(Map<String, Object> inParameters) {
            return (String)inParameters.get("com.pingidentity.adapter.input.parameter.application.name");
        }

        private static String getFlowType() {
            return FlowType.AUTHENTICATION.name();
        }

        private static String getSessionId(Map<String, Object> inParameters) {
            return (String)inParameters.get("com.pingidentity.adapter.input.parameter.tracking.id");
        }

        private static String getSharingType(Map<String, Object> inParameters) {
            return (String)inParameters.get("com.pingidentity.adapter.input.parameter.device.sharing.type");
        }

        private static String getBrowserId(HttpServletRequest req, HttpServletResponse resp, boolean isApiRequest) {
            Cookie[] cookies = req.getCookies();
            Cookie browserIdCookie = null;
            if (cookies != null) {
                browserIdCookie = Arrays.stream(cookies).filter(cookie -> cookie.getName().equalsIgnoreCase(PingOneRiskManagementIdpAdapter.BROWSER_ID_COOKIE_NAME)).findFirst().orElse(null);
            }
            String browserId = null;
            if (browserIdCookie == null) {
                if (!isApiRequest) {
                    browserId = UUID.randomUUID().toString();
                }
                browserIdCookie = new Cookie(PingOneRiskManagementIdpAdapter.BROWSER_ID_COOKIE_NAME, browserId);
                browserIdCookie.setMaxAge(31557600);
                browserIdCookie.setPath("/");
                browserIdCookie.setHttpOnly(true);
                browserIdCookie.setSecure(true);
                resp.addCookie(browserIdCookie);
            } else {
                browserId = browserIdCookie.getValue();
            }
            return browserId;
        }

        private static Map<OptionalUserAttribute, AttributeValue> getOptionalUserAttributes(Map<String, Object> inParameters, Map<String, OptionalUserAttribute> optionalUserAttributesMapping) {
            EnumMap<OptionalUserAttribute, AttributeValue> optionalUserAttributes = new EnumMap<OptionalUserAttribute, AttributeValue>(OptionalUserAttribute.class);
            for (Map.Entry<String, OptionalUserAttribute> mapping : optionalUserAttributesMapping.entrySet()) {
                Optional<AttributeValue> optionalAttributeValue = RiskEventExtractor.getFromChainedAttributes(inParameters, mapping.getKey());
                if (optionalAttributeValue.isPresent()) {
                    AttributeValue attributeValue = optionalAttributeValue.get();
                    optionalUserAttributes.put(mapping.getValue(), attributeValue);
                    continue;
                }
                LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.MISSING_OPTIONAL_USER_ATTRIBUTE, mapping.getValue().getValue(), mapping.getKey());
            }
            return optionalUserAttributes;
        }

        private static Map<String, AttributeValue> getOptionalRiskPredictors(Map<String, Object> inParameters, Map<String, String> mapping) {
            HashMap<String, AttributeValue> optionalRiskPredictors = new HashMap<String, AttributeValue>();
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                Optional<AttributeValue> optionalAttributeValue = RiskEventExtractor.getFromChainedAttributes(inParameters, entry.getKey());
                if (!optionalAttributeValue.isPresent()) continue;
                AttributeValue attributeValue = optionalAttributeValue.get();
                optionalRiskPredictors.put(PredictorAttributeMappingUtil.getValueAfterEvent(entry.getValue()), attributeValue);
            }
            return optionalRiskPredictors;
        }
    }
}

