/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import com.pingidentity.adapters.pingone.risk.ApiResponseMapper;
import com.pingidentity.adapters.pingone.risk.CompletionStatus;
import com.pingidentity.adapters.pingone.risk.OptionalUserAttribute;
import com.pingidentity.adapters.pingone.risk.RiskEvaluation;
import com.pingidentity.adapters.pingone.risk.RiskEvent;
import com.pingidentity.adapters.pingone.risk.api.Group;
import com.pingidentity.adapters.pingone.risk.api.model.Browser;
import com.pingidentity.adapters.pingone.risk.api.model.Event;
import com.pingidentity.adapters.pingone.risk.api.model.Flow;
import com.pingidentity.adapters.pingone.risk.api.model.Result;
import com.pingidentity.adapters.pingone.risk.api.model.RiskEvaluationRequest;
import com.pingidentity.adapters.pingone.risk.api.model.RiskEvaluationResponse;
import com.pingidentity.adapters.pingone.risk.api.model.Session;
import com.pingidentity.adapters.pingone.risk.api.model.TargetResource;
import com.pingidentity.adapters.pingone.risk.api.model.User;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class RiskEvaluationTranslator {
    private RiskEvaluationTranslator() {
    }

    public static RiskEvaluationRequest translateToRequest(RiskEvent riskEvent) {
        Event event = new Event.Builder().setIp(riskEvent.getIpAddress()).setUser(new User(User.Type.EXTERNAL.name(), riskEvent.getUsername(), RiskEvaluationTranslator.getUserGroups(riskEvent))).setBrowser(Browser.from(riskEvent.getDeviceProfile(), riskEvent.getBrowserId())).setTargetResource(new TargetResource(riskEvent.getTargetResourceId(), riskEvent.getTargetResourceName())).setFlow(new Flow(riskEvent.getFlowType())).setSession(new Session(riskEvent.getSessionId())).setCompletionStatus(CompletionStatus.IN_PROGRESS.name()).setSharingType(riskEvent.getSharingType()).setOrigin(Event.Origin.PF_RISK_IK.name()).setPredictorDetails(RiskEvaluationTranslator.getPredictors(riskEvent)).build();
        return new RiskEvaluationRequest(event);
    }

    public static RiskEvaluation translateFromResponse(RiskEvaluationResponse riskEvaluationResponse, Map<String, String> apiResponseMappings) {
        String id = riskEvaluationResponse.getId();
        Result result = riskEvaluationResponse.getResult();
        String riskLevel = null;
        String riskValue = null;
        if (result != null) {
            riskLevel = result.getLevel().name();
            riskValue = result.getValue();
        }
        String json = riskEvaluationResponse.getJson();
        Map<String, Object> apiResponseAttributes = ApiResponseMapper.map(apiResponseMappings, json);
        return new RiskEvaluation(id, riskLevel, riskValue, apiResponseAttributes);
    }

    private static List<Group> getUserGroups(RiskEvent riskEvent) {
        Map<OptionalUserAttribute, AttributeValue> optionalUserAttributes = riskEvent.getOptionalUserAttributes();
        if (!optionalUserAttributes.isEmpty() && optionalUserAttributes.containsKey((Object)OptionalUserAttribute.USER_GROUPS)) {
            return riskEvent.getOptionalUserAttributes().get((Object)OptionalUserAttribute.USER_GROUPS).getValuesAsCollection().stream().map(Group::new).collect(Collectors.toList());
        }
        return null;
    }

    private static Map<String, Object> getPredictors(RiskEvent riskEvent) {
        Map<String, AttributeValue> optionalRiskPredictors = riskEvent.getOptionalRiskPredictors();
        if (null != optionalRiskPredictors && !optionalRiskPredictors.isEmpty()) {
            return optionalRiskPredictors.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AttributeValue)e.getValue()).getObjectValue()));
        }
        return null;
    }
}

