/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import com.pingidentity.adapters.pingone.risk.PingOneRiskManagementAdapterConfiguration;
import com.pingidentity.adapters.pingone.risk.RiskPolicyCallbackHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;

public class RiskPolicyPreRenderCallback
implements PreRenderCallback {
    public void callback(List<FieldDescriptor> fields, List<FieldDescriptor> advancedFields, List<TableDescriptor> tables, Configuration configuration) {
        if (PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration) && this.isValidPingOneEnvironment(configuration)) {
            RiskPolicyCallbackHelper riskPolicyCallbackHelper = new RiskPolicyCallbackHelper();
            List<AbstractSelectionFieldDescriptor.OptionValue> optionValues = riskPolicyCallbackHelper.getRiskPolicyOptionValues(configuration);
            Optional<FieldDescriptor> populationField = this.getRiskPolicyField(fields);
            populationField.ifPresent(fieldDescriptor -> ((SelectFieldDescriptor)fieldDescriptor).setOptionValues(optionValues));
        }
    }

    private Optional<FieldDescriptor> getRiskPolicyField(List<FieldDescriptor> fields) {
        return fields.stream().filter(it -> "PingOne Risk Policy".equals(it.getName())).findFirst();
    }

    private boolean isValidPingOneEnvironment(Configuration configuration) {
        try {
            Class<?> pingOneEnvironmentValidatorClass = Class.forName("org.sourceid.saml20.adapter.gui.validation.impl.PingOneEnvironmentValidator");
            Constructor<?> pingOneEnvironmentValidatorConstructor = pingOneEnvironmentValidatorClass.getConstructor(new Class[0]);
            Object pingOneEnvironmentValidator = pingOneEnvironmentValidatorConstructor.newInstance(new Object[0]);
            Method validateMethod = pingOneEnvironmentValidatorClass.getMethod("validate", Field.class);
            validateMethod.invoke(pingOneEnvironmentValidator, configuration.getField("PingOne Environment"));
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }
}

