/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import com.pingidentity.adapters.pingone.risk.LogEvent;
import com.pingidentity.adapters.pingone.risk.TokenProvider;
import com.pingidentity.adapters.pingone.risk.TokenProviderException;
import com.pingidentity.adapters.pingone.risk.api.ApiResponseException;
import com.pingidentity.adapters.pingone.risk.api.TokenServiceException;
import com.pingidentity.adapters.pingone.risk.api.model.TokenErrorResponse;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.JwtClaims;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.MalformedClaimException;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.NumericDate;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.consumer.InvalidJwtException;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.consumer.JwtConsumer;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.consumer.JwtConsumerBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TokenService {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(TokenService.class);
    private static final long SKEW = -5L;
    private static final ConcurrentMap<String, AccessTokenWrapper> tokenWrapperMap = new ConcurrentHashMap<String, AccessTokenWrapper>();
    private final TokenProvider tokenProvider;
    private final String clientIdentifier;

    public TokenService(TokenProvider tokenProvider, String clientIdentifier) {
        this.tokenProvider = tokenProvider;
        this.clientIdentifier = clientIdentifier;
    }

    public synchronized String getToken() throws TokenServiceException {
        AccessTokenWrapper tokenWrapper = (AccessTokenWrapper)tokenWrapperMap.get(this.clientIdentifier);
        if (tokenWrapper == null || tokenWrapper.isExpired(-5L)) {
            LOGGER.log(LogEvent.REQUESTING_NEW_TOKEN);
            return this.requestToken();
        }
        LOGGER.log(LogEvent.REUSING_TOKEN);
        return tokenWrapper.getAccessToken();
    }

    private String requestToken() throws TokenServiceException {
        try {
            String token = this.tokenProvider.getToken();
            AccessTokenWrapper tokenWrapper = new AccessTokenWrapper(token);
            tokenWrapperMap.put(this.clientIdentifier, tokenWrapper);
            return tokenWrapper.getAccessToken();
        }
        catch (TokenProviderException e) {
            ApiResponseException apiResponseException;
            TokenErrorResponse tokenEndpointErrorResponse;
            if (e.getCause() instanceof ApiResponseException && (tokenEndpointErrorResponse = (TokenErrorResponse)(apiResponseException = (ApiResponseException)e.getCause()).getErrorResponse()) != null) {
                throw new TokenServiceException.Builder().setClientId(this.clientIdentifier).setStatusCode(apiResponseException.getStatusCode()).setError(tokenEndpointErrorResponse.getError()).setErrorDescription(tokenEndpointErrorResponse.getErrorDescription()).setCause(apiResponseException).build();
            }
            throw new TokenServiceException(this.clientIdentifier, e.getCause());
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new TokenServiceException(this.clientIdentifier, e);
        }
    }

    public static class AccessTokenWrapper {
        private final String accessToken;
        private final NumericDate expiresAt;

        public AccessTokenWrapper(String accessToken) throws InvalidJwtException, MalformedClaimException {
            this.accessToken = accessToken;
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setSkipSignatureVerification().build();
            JwtClaims jwtClaims = jwtConsumer.processToClaims(accessToken);
            this.expiresAt = jwtClaims.getExpirationTime();
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public boolean isExpired(long skew) {
            this.expiresAt.addSeconds(skew);
            return NumericDate.now().isOnOrAfter(this.expiresAt);
        }

        public boolean isExpired() {
            return this.isExpired(0L);
        }
    }
}

