/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk.api;

import com.pingidentity.adapters.pingone.risk.ObjectMappers;
import com.pingidentity.adapters.pingone.risk.RiskPolicySetsResponseHandler;
import com.pingidentity.adapters.pingone.risk.RiskPredictorsResponseHandler;
import com.pingidentity.adapters.pingone.risk.api.ApiResponseException;
import com.pingidentity.adapters.pingone.risk.api.RiskEvaluationResponseHandler;
import com.pingidentity.adapters.pingone.risk.api.RiskEventResponseHandler;
import com.pingidentity.adapters.pingone.risk.api.model.RiskEvaluationRequest;
import com.pingidentity.adapters.pingone.risk.api.model.RiskEvaluationResponse;
import com.pingidentity.adapters.pingone.risk.api.model.RiskEventRequest;
import com.pingidentity.adapters.pingone.risk.api.model.RiskEventResponse;
import com.pingidentity.adapters.pingone.risk.api.model.RiskPolicySetsResponse;
import com.pingidentity.adapters.pingone.risk.api.model.RiskPredictorsResponse;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.fluent.Executor;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.fluent.Request;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.ContentType;
import java.io.IOException;

public class RiskApiClient {
    private static final String PING_ONE_ENVIRONMENT_PATH = "%s/v1/environments/%s";
    public static final String RISK_EVALUATIONS_ENDPOINT = "/riskEvaluations";
    public static final String RISK_POLICY_SETS_ENDPOINT = "/riskPolicySets";
    public static final String RISK_PREDICTORS_ENDPOINT = "/riskPredictors";
    private static final String RISK_EVALUATIONS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/riskEvaluations";
    private static final String RISK_POLICY_SETS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/riskPolicySets";
    private static final String RISK_PREDICTORS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/riskPredictors";
    private static final String BEARER_TOKEN_FORMAT = "Bearer %s";
    private static final String EVENT_PATH = "%s/event";
    private Executor executor;
    private String riskEvaluationsUrl;
    private String riskPolicySetsUrl;
    private String riskPredictorsUrl;

    public RiskApiClient(Executor executor, String apiPath, String envId) {
        this.executor = executor;
        this.riskEvaluationsUrl = String.format(RISK_EVALUATIONS_ENDPOINT_TEMPLATE, apiPath, envId);
        this.riskPolicySetsUrl = String.format(RISK_POLICY_SETS_ENDPOINT_TEMPLATE, apiPath, envId);
        this.riskPredictorsUrl = String.format(RISK_PREDICTORS_ENDPOINT_TEMPLATE, apiPath, envId);
    }

    public RiskEvaluationResponse postRiskEvent(RiskEvaluationRequest request, String accessToken) throws IOException, ApiResponseException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String bodyString = ObjectMappers.getDefault().writeValueAsString(request);
        RiskEvaluationResponseHandler responseHandler = new RiskEvaluationResponseHandler();
        return this.executor.execute(Request.post(this.riskEvaluationsUrl).setHeader("Authorization", authHeader).bodyString(bodyString, ContentType.APPLICATION_JSON)).handleResponse(responseHandler);
    }

    public RiskEvaluationResponse getRiskEvaluation(String riskEvaluationId, String accessToken) throws IOException, ApiResponseException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        RiskEvaluationResponseHandler responseHandler = new RiskEvaluationResponseHandler();
        return this.executor.execute(Request.get(this.riskEvaluationsUrl + "/" + riskEvaluationId).setHeader("Authorization", authHeader)).handleResponse(responseHandler);
    }

    public RiskEventResponse putRiskEvent(RiskEventRequest request, String riskEvaluationId, String accessToken) throws IOException, ApiResponseException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String bodyString = ObjectMappers.getDefault().writeValueAsString(request);
        RiskEventResponseHandler responseHandler = new RiskEventResponseHandler();
        return this.executor.execute(Request.put(this.riskEvaluationsUrl + "/" + String.format(EVENT_PATH, riskEvaluationId)).setHeader("Authorization", authHeader).bodyString(bodyString, ContentType.APPLICATION_JSON)).handleResponse(responseHandler);
    }

    public RiskPolicySetsResponse getRiskPolicySets(String accessToken) throws IOException, ApiResponseException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        RiskPolicySetsResponseHandler responseHandler = new RiskPolicySetsResponseHandler();
        return this.executor.execute(Request.get(this.riskPolicySetsUrl).setHeader("Authorization", authHeader)).handleResponse(responseHandler);
    }

    public RiskPredictorsResponse getRiskPredictors(String accessToken) throws IOException, ApiResponseException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        RiskPredictorsResponseHandler responseHandler = new RiskPredictorsResponseHandler();
        return this.executor.execute(Request.get(this.riskPredictorsUrl).setHeader("Authorization", authHeader)).handleResponse(responseHandler);
    }
}

