/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.impl.nio;

import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.HttpException;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.HttpRequest;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.HttpRequestFactory;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.MessageConstraintException;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.RequestHeaderFieldsTooLargeException;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.config.Http1Config;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.impl.nio.AbstractMessageParser;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.message.LineParser;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.message.RequestLine;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.nio.SessionInputBuffer;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.util.Args;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpRequestParser<T extends HttpRequest>
extends AbstractMessageParser<T> {
    private final HttpRequestFactory<T> requestFactory;

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, LineParser parser, Http1Config http1Config) {
        super(parser, http1Config);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, Http1Config http1Config) {
        this(requestFactory, null, http1Config);
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory) {
        this(requestFactory, null);
    }

    @Override
    public T parse(SessionInputBuffer sessionBuffer, boolean endOfStream) throws IOException, HttpException {
        try {
            return (T)((HttpRequest)super.parse(sessionBuffer, endOfStream));
        }
        catch (MessageConstraintException ex) {
            throw new RequestHeaderFieldsTooLargeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected T createMessage(CharArrayBuffer buffer) throws HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        T request = this.requestFactory.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request.setVersion(requestLine.getProtocolVersion());
        return request;
    }
}

