/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk.shade.org.jose4j.keys.resolvers;

import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwe.JsonWebEncryption;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwk.DecryptionJwkSelector;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwk.JsonWebKey;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwk.PublicJsonWebKey;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwx.JsonWebStructure;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.keys.resolvers.DecryptionKeyResolver;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.lang.JoseException;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.lang.UnresolvableKeyException;
import java.security.Key;
import java.util.List;

public class JwksDecryptionKeyResolver
implements DecryptionKeyResolver {
    private final List<JsonWebKey> jsonWebKeys;
    private final DecryptionJwkSelector selector = new DecryptionJwkSelector();
    boolean disambiguateWithAttemptDecrypt;

    public JwksDecryptionKeyResolver(List<JsonWebKey> jsonWebKeys) {
        this.jsonWebKeys = jsonWebKeys;
    }

    @Override
    public Key resolveKey(JsonWebEncryption jwe, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        JsonWebKey selected;
        try {
            List<JsonWebKey> selectedList = this.selector.selectList(jwe, this.jsonWebKeys);
            if (selectedList.isEmpty()) {
                selected = null;
            } else if (selectedList.size() == 1 || !this.disambiguateWithAttemptDecrypt) {
                selected = selectedList.get(0);
            } else {
                selected = this.selector.attemptDecryptDisambiguate(jwe, selectedList);
                if (selected == null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Unable to find a suitable key for JWE w/ header ").append(jwe.getHeaders().getFullHeaderAsJsonString());
                    sb.append(" using attempted decryption to disambiguate from filtered candidate JWKs ").append(this.jsonWebKeys);
                    throw new UnresolvableKeyException(sb.toString());
                }
            }
        }
        catch (JoseException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find a suitable key for JWE w/ header ").append(jwe.getHeaders().getFullHeaderAsJsonString());
            sb.append(" due to an unexpected exception (").append(e).append(") selecting from keys: ").append(this.jsonWebKeys);
            throw new UnresolvableKeyException(sb.toString(), e);
        }
        if (selected == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find a suitable key for JWE w/ header ").append(jwe.getHeaders().getFullHeaderAsJsonString());
            sb.append(" from JWKs ").append(this.jsonWebKeys);
            throw new UnresolvableKeyException(sb.toString());
        }
        return selected instanceof PublicJsonWebKey ? ((PublicJsonWebKey)selected).getPrivateKey() : selected.getKey();
    }

    public void setDisambiguateWithAttemptDecrypt(boolean disambiguateWithAttemptDecrypt) {
        this.disambiguateWithAttemptDecrypt = disambiguateWithAttemptDecrypt;
    }
}

