/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk.validator;

import java.util.function.Predicate;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.validation.EnhancedRowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class TableUniqueKeyValidator
implements EnhancedRowValidator {
    private String tableName;
    private String keyName;

    public TableUniqueKeyValidator(String tableName, String keyName) {
        this.tableName = tableName;
        this.keyName = keyName;
    }

    static boolean duplicates(Table table, Predicate<Row> isDuplicate) {
        return table.getRows().stream().filter(isDuplicate).count() > 1L;
    }

    public void validate(FieldList fieldsInRow, Configuration configuration) throws ValidationException {
        String key;
        Predicate<Row> isDuplicate;
        Table table = configuration.getTable(this.tableName);
        if (TableUniqueKeyValidator.duplicates(table, isDuplicate = arg_0 -> this.lambda$validate$0(key = fieldsInRow.getFieldValue(this.keyName), arg_0))) {
            throw new ValidationException(this.keyName + " in " + this.tableName + " must be unique.");
        }
    }

    public void validate(FieldList fieldList) throws ValidationException {
    }

    private /* synthetic */ boolean lambda$validate$0(String key, Row row) {
        return row.getFieldValue(this.keyName).equals(key);
    }
}

