/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONIntermediateClientRequestControl
implements Serializable {
    private static final long serialVersionUID = -575977471763904665L;
    @Nullable
    private final Boolean downstreamClientSecure;
    @Nullable
    private final JSONIntermediateClientRequestControl downstreamRequest;
    @NotNull
    private final JSONObject controlObject;
    @Nullable
    private final String clientIdentity;
    @Nullable
    private final String clientName;
    @Nullable
    private final String downstreamClientAddress;
    @Nullable
    private final String requestID;
    @Nullable
    private final String sessionID;

    public JSONIntermediateClientRequestControl(@NotNull JSONObject controlObject) {
        this.controlObject = controlObject;
        this.downstreamClientAddress = controlObject.getFieldAsString(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_REQUEST_CONTROL_DOWNSTREAM_CLIENT_ADDRESS.getFieldName());
        this.downstreamClientSecure = controlObject.getFieldAsBoolean(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_REQUEST_CONTROL_DOWNSTREAM_CLIENT_SECURE.getFieldName());
        this.clientIdentity = controlObject.getFieldAsString(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_REQUEST_CONTROL_CLIENT_IDENTITY.getFieldName());
        this.clientName = controlObject.getFieldAsString(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_REQUEST_CONTROL_CLIENT_NAME.getFieldName());
        this.sessionID = controlObject.getFieldAsString(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_REQUEST_CONTROL_SESSION_ID.getFieldName());
        this.requestID = controlObject.getFieldAsString(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_REQUEST_CONTROL_REQUEST_ID.getFieldName());
        JSONObject downstreamObject = controlObject.getFieldAsObject(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_REQUEST_CONTROL_DOWNSTREAM_REQUEST.getFieldName());
        this.downstreamRequest = downstreamObject == null ? null : new JSONIntermediateClientRequestControl(downstreamObject);
    }

    @NotNull
    public JSONObject getControlObject() {
        return this.controlObject;
    }

    @Nullable
    public String getDownstreamClientAddress() {
        return this.downstreamClientAddress;
    }

    @Nullable
    public Boolean getDownstreamClientSecure() {
        return this.downstreamClientSecure;
    }

    @Nullable
    public String getClientIdentity() {
        return this.clientIdentity;
    }

    @Nullable
    public String getClientName() {
        return this.clientName;
    }

    @Nullable
    public String getSessionID() {
        return this.sessionID;
    }

    @Nullable
    public String getRequestID() {
        return this.requestID;
    }

    @Nullable
    public JSONIntermediateClientRequestControl getDownstreamRequest() {
        return this.downstreamRequest;
    }

    @NotNull
    public String toString() {
        return this.controlObject.toSingleLineString();
    }
}

