/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify;

import com.pingidentity.adapters.pingone.verify.config.UiConfig;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.LogLevel;

public enum CustomLogEvent implements LogEvent
{
    USER_NOT_AUTHENTICATED(LogLevel.ERROR, "000", "User arrived at Verify Adapter without being authenticated."),
    BLOCK_USER_ERROR(LogLevel.WARN, "002", "PingOne Verify verification failed and '" + UiConfig.VERIFICATION_RETRY.field + "' is set to 'false'."),
    ACCESS_TOKEN_EXCEPTION(LogLevel.WARN, "003", "Exception thrown when getting an access token."),
    UNRECOVERABLE_ERROR(LogLevel.WARN, "004", "PingOne Verify verification failed, retry not allowed."),
    EXCEPTION_THROWN(LogLevel.DEBUG, "005", "Exception thrown by the PingOne Verify Adapter."),
    BYPASS(LogLevel.DEBUG, "006", "Authentication bypassed due to adapter failure mode configuration."),
    RATE_LIMIT_EXCEEDED(LogLevel.ERROR, "007", "< Requests exceeded rate limit >"),
    FAIL_BYPASS(LogLevel.DEBUG, "008", "Authentication should not be bypassed for password reset."),
    INVALID_USER_ACCOUNT_RECOVERY(LogLevel.DEBUG, "009", "User not found/provisioned in PingOne or has PingOne Verify disabled during account recovery."),
    INVALID_USER(LogLevel.DEBUG, "010", "User not found/provisioned in PingOne or has PingOne Verify disabled."),
    PINGONE_FAILED(LogLevel.DEBUG, "011", "PingOne service unavailable or failed."),
    ADAPTER_STATE(LogLevel.DEBUG, "012", "Verify transaction has status '%s', adapter is in state '%s'."),
    RETRY_VERIFICATION(LogLevel.DEBUG, "013", "Handling request to retry verification."),
    CONTINUE_AUTHENTICATION(LogLevel.DEBUG, "014", "Handling request to continue authentication."),
    CANCEL_AUTHENTICATION(LogLevel.DEBUG, "015", "Handling request to cancel. Returning from adapter with failure."),
    TIMED_OUT(LogLevel.DEBUG, "016", "User authentication timed out."),
    SEND_POLL_REQUEST_ERROR(LogLevel.DEBUG, "017", "Error sending poll request. %s"),
    HTTP_EXECUTE_ERROR(LogLevel.DEBUG, "018", "Unable to execute http request."),
    READ_RESPONSE_ERROR(LogLevel.DEBUG, "019", "Unable to read http response."),
    HTTP_RESPONSE_CODE(LogLevel.DEBUG, "020", "Http response code: %d"),
    NO_USER_ID(LogLevel.ERROR, "021", "No user id or username was passed in to the adapter."),
    GET_POPULATIONS_ERROR(LogLevel.WARN, "022", "Error getting list of populations for dropdown."),
    VERIFY_DISABLED(LogLevel.WARN, "023", "User has PingOne Verify disabled."),
    USER_DOES_NOT_EXIST(LogLevel.INFO, "024", "Current user '%s' does not exist in PingOne. Provisioning a user in PingOne."),
    CREATE_TRANSACTION(LogLevel.INFO, "025", "Creating a new verification transaction for user '%s' with email '%s' phone '%s'."),
    PINGONE_UNEXPECTED_STATUS(LogLevel.DEBUG, "026", "PingOne returned an unexpected status code. %s"),
    GET_USER_ID(LogLevel.DEBUG, "027", "Getting user id of user '%s'."),
    RETURN_USER_ID(LogLevel.DEBUG, "028", "User '%s' has user id '%s'."),
    USER_PROVISION_FAILED(LogLevel.DEBUG, "029", "User provisioning for user '%s' failed. %s"),
    CREATED_TRANSACTION(LogLevel.DEBUG, "030", "Verification transaction '%s' created for user '%s'."),
    GET_IDV_STATUS(LogLevel.DEBUG, "031", "User '%s' getting verification status for transaction '%s'."),
    TRANSACTION_STATUS(LogLevel.DEBUG, "032", "The status of verification transaction '%s' is '%s'."),
    GET_STATUS_FAILED(LogLevel.DEBUG, "033", "Failed to get ID verification status of user '%s'. %s"),
    GET_POPULATIONS(LogLevel.DEBUG, "037", "Getting list of PingOne populations."),
    CREATE_VERIFICATION_FAILED(LogLevel.DEBUG, "038", "Failed to create ID verification transaction for user '%s'. %s"),
    GET_ACCESS_FAILED_MESSAGE(LogLevel.DEBUG, "039", "Failed to get message for status code 'ACCESS_FAILED'."),
    GET_USER_DATA_FAILED(LogLevel.DEBUG, "040", "Failed to get user data. %s"),
    NULL_QR_URL(LogLevel.DEBUG, "041", "qrUrl is null."),
    NULL_USER_ID(LogLevel.DEBUG, "042", "User id is null."),
    ACCESS_TOKEN_ERROR(LogLevel.WARN, "043", "Error getting access token: %s"),
    REQUESTING_NEW_TOKEN(LogLevel.DEBUG, "044", "PingOne Verify Management access token is not cached or has expired. Requesting new token."),
    REUSING_TOKEN(LogLevel.DEBUG, "045", "Reusing PingOne Risk Management access token."),
    POPULATIONS_CALLBACK_ERROR(LogLevel.ERROR, "046", "There was an error fetching populations from PingOne."),
    GET_USER_DATA_SUCCESS(LogLevel.DEBUG, "047", "Get user data success. %s"),
    POLL_STATUS_TRACK(LogLevel.INFO, "048", "Track poll status. %s"),
    AUTHN_SUCCESS_RESPONSE(LogLevel.DEBUG, "049", "Authn success response. username: %s, attributeMap: %s."),
    AUTHN_FAIL_RESPONSE(LogLevel.ERROR, "050", "Authn fail response. %s"),
    FORCE_POLICY_ERROR(LogLevel.WARN, "051", "Force policy error: \"%s\". Reason: '%s' is on."),
    GET_CHAINED_ATTR(LogLevel.DEBUG, "052", "Get chained attributes: [%s] passed in %s: %s, passed in %s: %s."),
    SERIALIZATION_ERROR(LogLevel.ERROR, "053", "Failed to serialize %s to Json string."),
    GET_VERIFY_POLICIES(LogLevel.DEBUG, "054", "Getting list of verify policies."),
    GET_VERIFY_POLICIES_ERROR(LogLevel.WARN, "055", "Error getting list of verify policies."),
    VERIFY_POLICIES_CALLBACK_ERROR(LogLevel.ERROR, "056", "There was an error fetching verifyPolicies from PingOne."),
    VERIFY_POLICY_TRACK(LogLevel.DEBUG, "057", "verifyPolicy %s, emailreq %s, phonereq %s, emails %s, phones %s."),
    RESET_VERIFICATION_STATUS(LogLevel.DEBUG, "058", "Reset verification status for user '%s'."),
    RESET_VERIFICATION_LIMITS_SUCCESS(LogLevel.DEBUG, "059", "Reset verification limits success for user '%s'."),
    RESET_VERIFICATION_LIMITS_FAILED(LogLevel.DEBUG, "060", "Failed to reset verification limits for user '%s'."),
    VERIFY_POLICIES_NOT_FOUND(LogLevel.WARN, "061", "Unable to read Verify Policies from Environment. Environment may not support Verify."),
    MISSING_BIOGRAPHIC_VALUE(LogLevel.WARN, "062", "Biographic Matching chained attribute not found: %s.");

    private static final String PRODUCT_CODE = "VERI";
    private final LogLevel level;
    private final String code;
    private final String message;

    private CustomLogEvent(LogLevel level, String code, String message) {
        this.level = level;
        this.code = code;
        this.message = message;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getCode() {
        return "VERI-" + this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

