/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify;

import com.pingidentity.adapters.pingone.verify.api.model.CustomAuthnErrorDetail;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class LanguagePackMessagesSupport {
    public String verifyMessages;
    private final String errorMessageKeyPrefix;

    public LanguagePackMessagesSupport(String verifyMessages, String errorMessageKeyPrefix) {
        this.verifyMessages = verifyMessages;
        this.errorMessageKeyPrefix = errorMessageKeyPrefix;
    }

    public LanguagePackMessages getPingOneVerifyAdapterMessages(HttpServletRequest req) {
        Locale userLocale = LocaleUtil.getUserLocale((HttpServletRequest)req);
        return new LanguagePackMessages(this.verifyMessages, userLocale);
    }

    public String getVerifyMessage(HttpServletRequest req, String key) {
        return this.getMessage(req, this.verifyMessages, key);
    }

    public String getMessage(HttpServletRequest req, String resourceBundleBaseName, String key) {
        LanguagePackMessages lpm = this.getLanguagePackMessages(req, resourceBundleBaseName);
        String message = lpm.getMessage(key);
        if (message == null) {
            message = key;
        }
        return message;
    }

    public LanguagePackMessages getLanguagePackMessages(HttpServletRequest req, String resourceBundleBaseName) {
        Locale userLocale = LocaleUtil.getUserLocale((HttpServletRequest)req);
        return new LanguagePackMessages(resourceBundleBaseName, userLocale);
    }

    public String getErrorMessage(HttpServletRequest req, List<String> messageKeySuffixList) {
        StringBuilder error = null;
        if (messageKeySuffixList != null) {
            for (String messageKey : messageKeySuffixList) {
                String message;
                String key = this.errorMessageKeyPrefix + messageKey;
                if (key.equals(message = this.getVerifyMessage(req, key))) {
                    message = this.getVerifyMessage(req, this.errorMessageKeyPrefix + "general");
                }
                if (error == null) {
                    error = message == null ? null : new StringBuilder(message);
                    continue;
                }
                String lineMessage = "<br>" + message;
                error.append(lineMessage);
            }
        }
        return error == null ? null : error.toString();
    }

    public List<CustomAuthnErrorDetail> getErrorMessage(List<CustomAuthnErrorDetail> customAuthnErrorDetailList, HttpServletRequest req) {
        if (customAuthnErrorDetailList != null) {
            for (int i = 0; i < customAuthnErrorDetailList.size(); ++i) {
                String message;
                CustomAuthnErrorDetail errorDetail = customAuthnErrorDetailList.get(i);
                String key = this.errorMessageKeyPrefix + errorDetail.getUserMessage();
                if (key.equals(message = this.getVerifyMessage(req, key))) {
                    message = this.getVerifyMessage(req, this.errorMessageKeyPrefix + "general");
                }
                errorDetail.setUserMessage(message);
                customAuthnErrorDetailList.set(i, errorDetail);
            }
        }
        return customAuthnErrorDetailList;
    }
}

