/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.api;

import com.pingidentity.adapters.pingone.verify.CoreContract;
import com.pingidentity.adapters.pingone.verify.CustomLogEvent;
import com.pingidentity.adapters.pingone.verify.api.PingOneClient;
import com.pingidentity.adapters.pingone.verify.api.PingOneStatusCode;
import com.pingidentity.adapters.pingone.verify.api.VerifyTransactionRequest;
import com.pingidentity.adapters.pingone.verify.api.model.TransactionStatus;
import com.pingidentity.adapters.pingone.verify.api.model.VerifyResponse;
import com.pingidentity.adapters.pingone.verify.api.model.VerifyResponseWrapper;
import com.pingidentity.adapters.pingone.verify.config.UiConfig;
import com.pingidentity.adapters.pingone.verify.exception.ApiException;
import com.pingidentity.adapters.pingone.verify.exception.InvalidUserException;
import com.pingidentity.adapters.pingone.verify.exception.InvalidValueException;
import com.pingidentity.adapters.pingone.verify.exception.LimitExceededException;
import com.pingidentity.adapters.pingone.verify.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.adapters.pingone.verify.shade.com.google.common.collect.ImmutableMap;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpQueryParams;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.HttpService;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.util.JsonPointerUtil;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.adapters.pingone.verify.shade.org.json.simple.JSONArray;
import com.pingidentity.adapters.pingone.verify.shade.org.json.simple.JSONObject;
import com.pingidentity.adapters.pingone.verify.util.ObjectMapperUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;

public class ApiClient
extends PingOneClient {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(ApiClient.class);
    private static final String ENV_ENDPOINT_TEMPLATE = "%s/v1/environments/%s";
    private static final String USERS_ENDPOINT_TEMPLATE = "%s/users";
    private static final String POPULATIONS_ENDPOINT_TEMPLATE = "%s/populations";
    private static final String VERIFY_POLICIES_ENDPOINT_TEMPLATE = "%s/verifyPolicies";
    private static final String VERIFY_TRANSACTIONS_ENDPOINT_TEMPLATE = "%s/users/%s/verifyTransactions";
    private static final String SPECIFIC_ENDPOINT_TEMPLATE = "%s/%s";
    private static final String USERNAME_FILTER = "username eq \"%s\"";
    private static final String FILTER = "%s?filter=%s";
    private static final String CONTENT_TYPE_IMPORT = "application/vnd.pingidentity.user.import+json";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String SIZE = "size";
    private static final String EMBEDDED = "_embedded";
    private static final String VERIFIED_DATA = "verifiedData?type=";
    private static final String JSON_POINTER_SELFIE = "/_embedded/verifiedData/0/data/IMAGE";
    private static final String JSON_POINTER_METADATA = "/_embedded/metaData";
    private static final String LIMIT_EXCEEDED_ID = CustomLogEvent.RATE_LIMIT_EXCEEDED.getMessage();
    private static final Map<UiConfig, String> BIOGRAPHIC_FIELD_NAME_MAP = ImmutableMap.of(UiConfig.BIOGRAPHIC_FIRST_NAME_ATTR_NAME, "given_name", UiConfig.BIOGRAPHIC_LAST_NAME_ATTR_NAME, "family_name", UiConfig.BIOGRAPHIC_FULL_NAME_ATTR_NAME, "name", UiConfig.BIOGRAPHIC_ADDRESS_ATTR_NAME, "address", UiConfig.BIOGRAPHIC_DOB_ATTR_NAME, "birth_date");
    private final ObjectMapper objectMapper;
    private final String envUrl;
    private final String usersUrl;
    private String token;

    public ApiClient(HttpService httpService, String apiBaseUrl, String envId) {
        super(httpService);
        this.envUrl = String.format(ENV_ENDPOINT_TEMPLATE, apiBaseUrl, envId);
        this.usersUrl = String.format(USERS_ENDPOINT_TEMPLATE, this.envUrl);
        this.objectMapper = ObjectMapperUtil.getDefault();
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getEnvUrl() {
        return this.envUrl;
    }

    public String getUsersUrl() {
        return this.usersUrl;
    }

    public String getVerifyTransactionsUrl(String userId) throws ApiException {
        if (userId == null) {
            LOGGER.log(CustomLogEvent.NULL_USER_ID);
            throw new ApiException("userId is null");
        }
        return String.format(VERIFY_TRANSACTIONS_ENDPOINT_TEMPLATE, this.envUrl, userId);
    }

    public String getUserId(String passedInUser, String popId, boolean provisionUser) throws AuthnAdapterException, InvalidUserException, LimitExceededException {
        LOGGER.log((LogEvent)CustomLogEvent.GET_USER_ID, passedInUser);
        if (passedInUser == null) {
            LOGGER.log(CustomLogEvent.NO_USER_ID);
            throw new AuthnAdapterException(CustomLogEvent.NO_USER_ID.getMessage());
        }
        try {
            String getUserIdUrl = String.format(SPECIFIC_ENDPOINT_TEMPLATE, this.usersUrl, passedInUser);
            GenericHttpResponse getUserIdResponse = this.executeGetRequest(getUserIdUrl);
            int getUserIdStatusCode = getUserIdResponse.getStatusCode();
            if (getUserIdStatusCode == PingOneStatusCode.LIMIT_EXCEEDED.getStatusCode()) {
                LOGGER.log(CustomLogEvent.RATE_LIMIT_EXCEEDED);
                throw new LimitExceededException();
            }
            if (getUserIdStatusCode == PingOneStatusCode.SUCCESS.getStatusCode()) {
                LOGGER.log((LogEvent)CustomLogEvent.RETURN_USER_ID, passedInUser, passedInUser);
                return passedInUser;
            }
            if (getUserIdStatusCode != PingOneStatusCode.BAD_REQUEST.getStatusCode() && getUserIdStatusCode != PingOneStatusCode.RESOURCE_NOT_FOUND.getStatusCode()) {
                String message = "Get user id with passed in user info as user id failed.";
                LOGGER.log((LogEvent)CustomLogEvent.PINGONE_UNEXPECTED_STATUS, message);
                throw new InvalidUserException(message);
            }
            String getUsernamePart = String.format(USERNAME_FILTER, passedInUser);
            try {
                getUsernamePart = URLEncoder.encode(getUsernamePart, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String getUsernameUrl = String.format(FILTER, this.usersUrl, getUsernamePart);
            GenericHttpResponse getUsernameResponse = this.executeGetRequest(getUsernameUrl);
            int getUsernameStatusCode = getUsernameResponse.getStatusCode();
            if (getUsernameStatusCode == PingOneStatusCode.LIMIT_EXCEEDED.getStatusCode()) {
                LOGGER.log(CustomLogEvent.RATE_LIMIT_EXCEEDED);
                throw new LimitExceededException();
            }
            if (getUsernameStatusCode == PingOneStatusCode.SUCCESS.getStatusCode()) {
                String userId;
                JSONObject usernameResponse = (JSONObject)this.getResponseBody(getUsernameResponse, false);
                Long size = (Long)usernameResponse.get(SIZE);
                if (size == 1L) {
                    JSONObject embedded = (JSONObject)usernameResponse.get(EMBEDDED);
                    JSONArray users = (JSONArray)embedded.get("users");
                    JSONObject user = (JSONObject)users.get(0);
                    userId = (String)user.get(ID);
                } else {
                    LOGGER.log((LogEvent)CustomLogEvent.USER_DOES_NOT_EXIST, passedInUser);
                    if (!provisionUser) {
                        String errorMessage = "Adapter configuration does not allow user provisioning";
                        LOGGER.log((LogEvent)CustomLogEvent.USER_PROVISION_FAILED, passedInUser, errorMessage);
                        throw new InvalidUserException(errorMessage);
                    }
                    if (StringUtils.isBlank(popId)) {
                        String errorMessage = "Population ID was not configured for user provisioning.";
                        LOGGER.log((LogEvent)CustomLogEvent.USER_PROVISION_FAILED, passedInUser, errorMessage);
                        throw new InvalidUserException(errorMessage);
                    }
                    JSONObject popObject = new JSONObject();
                    popObject.put(ID, popId);
                    JSONObject attribute = new JSONObject();
                    attribute.put("population", popObject);
                    attribute.put("username", passedInUser);
                    GenericHttpRequest request = new GenericHttpRequest(GenericHttpMethod.POST, this.usersUrl, new GenericHttpQueryParams(), this.getHttpHeaders(CONTENT_TYPE_IMPORT), this.getHttpBody(attribute));
                    GenericHttpResponse createUserResponse = this.executeRequest(request);
                    int statusCode = createUserResponse.getStatusCode();
                    if (statusCode == PingOneStatusCode.LIMIT_EXCEEDED.getStatusCode()) {
                        LOGGER.log(CustomLogEvent.RATE_LIMIT_EXCEEDED);
                        throw new LimitExceededException();
                    }
                    if (statusCode != PingOneStatusCode.CREATED.getStatusCode()) {
                        String message = "User provisioning failed.";
                        LOGGER.log((LogEvent)CustomLogEvent.PINGONE_UNEXPECTED_STATUS, message);
                        throw new InvalidUserException(message);
                    }
                    JSONObject userObject = (JSONObject)this.getResponseBody(createUserResponse, false);
                    userId = (String)userObject.get(ID);
                }
                LOGGER.log((LogEvent)CustomLogEvent.RETURN_USER_ID, passedInUser, userId);
                return userId;
            }
            String message = "Get user id with passed in user info as username failed.";
            LOGGER.log((LogEvent)CustomLogEvent.PINGONE_UNEXPECTED_STATUS, message);
            throw new InvalidUserException(message);
        }
        catch (LimitExceededException e) {
            throw e;
        }
        catch (ApiException | InvalidUserException e) {
            throw new InvalidUserException(e.getMessage(), e);
        }
    }

    public void resetVerificationLimits(String userId) throws ApiException {
        String userUrl = String.format(SPECIFIC_ENDPOINT_TEMPLATE, this.usersUrl, userId);
        String target = String.format(SPECIFIC_ENDPOINT_TEMPLATE, userUrl, "resetVerification");
        GenericHttpRequest request = new GenericHttpRequest(GenericHttpMethod.POST, target, new GenericHttpQueryParams(), this.getHttpHeaders());
        GenericHttpResponse genericHttpResponse = this.executeRequest(request);
        int statusCode = genericHttpResponse.getStatusCode();
        if (statusCode == PingOneStatusCode.LIMIT_EXCEEDED.getStatusCode()) {
            LOGGER.log(CustomLogEvent.RATE_LIMIT_EXCEEDED);
            throw new LimitExceededException();
        }
        if (statusCode != PingOneStatusCode.SUCCESS.getStatusCode()) {
            LOGGER.log((LogEvent)CustomLogEvent.RESET_VERIFICATION_LIMITS_FAILED, userId);
            throw new ApiException("Failed to reset verification limits.");
        }
        LOGGER.log((LogEvent)CustomLogEvent.RESET_VERIFICATION_LIMITS_SUCCESS, userId);
    }

    public VerifyResponseWrapper getIdvStatus(String userId, String transactionId, String qrCode, String verificationCode, String webVerificationUrl) throws ApiException, InvalidUserException {
        return this.getIdvStatus(userId, transactionId, qrCode, verificationCode, webVerificationUrl, false);
    }

    public VerifyResponseWrapper getIdvStatus(String userId, String transactionId, String qrCode, String verificationCode, String webVerificationUrl, boolean verificationReset) throws ApiException, InvalidUserException {
        LOGGER.log((LogEvent)CustomLogEvent.GET_IDV_STATUS, userId, transactionId);
        try {
            VerifyResponse verifyResponse;
            GenericHttpResponse genericHttpResponse;
            String verifyTransactionsUrl = this.getVerifyTransactionsUrl(userId);
            if (transactionId == null) {
                if (verificationReset) {
                    VerifyResponse verifyResponse2 = new VerifyResponse();
                    LOGGER.log((LogEvent)CustomLogEvent.RESET_VERIFICATION_STATUS, userId);
                    return new VerifyResponseWrapper(verifyResponse2);
                }
                String latestVerifyTransactionUrl = verifyTransactionsUrl + "?limit=1&order=-createdAt";
                genericHttpResponse = this.executeGetRequest(latestVerifyTransactionUrl);
                int statusCode = genericHttpResponse.getStatusCode();
                if (statusCode == PingOneStatusCode.LIMIT_EXCEEDED.getStatusCode()) {
                    LOGGER.log(CustomLogEvent.RATE_LIMIT_EXCEEDED);
                    throw new LimitExceededException();
                }
                if (statusCode != PingOneStatusCode.SUCCESS.getStatusCode()) {
                    String errorMessage = "Unable to get list of verification transaction";
                    LOGGER.log((LogEvent)CustomLogEvent.GET_STATUS_FAILED, userId, errorMessage);
                    throw new ApiException(errorMessage);
                }
                JSONObject response = (JSONObject)this.getResponseBody(genericHttpResponse, false);
                Long size = (Long)response.get(SIZE);
                if (size == 0L) {
                    VerifyResponse verifyResponse3 = new VerifyResponse();
                    LOGGER.log((LogEvent)CustomLogEvent.TRANSACTION_STATUS, verifyResponse3.getId(), null);
                    return new VerifyResponseWrapper(verifyResponse3);
                }
                JSONObject embedded = (JSONObject)response.get(EMBEDDED);
                JSONArray transactions = (JSONArray)embedded.get("verifyTransactions");
                JSONObject newestTransaction = (JSONObject)transactions.get(0);
                String jsonString = newestTransaction.toJSONString();
                verifyResponse = this.objectMapper.readValue(jsonString, VerifyResponse.class);
            } else {
                String target = String.format(SPECIFIC_ENDPOINT_TEMPLATE, verifyTransactionsUrl, transactionId);
                genericHttpResponse = this.executeGetRequest(target);
                int statusCode = genericHttpResponse.getStatusCode();
                if (statusCode == PingOneStatusCode.LIMIT_EXCEEDED.getStatusCode()) {
                    LOGGER.log(CustomLogEvent.RATE_LIMIT_EXCEEDED);
                    throw new LimitExceededException();
                }
                if (statusCode != PingOneStatusCode.SUCCESS.getStatusCode()) {
                    String errorMessage = "Unable to get verification status of current transaction.";
                    LOGGER.log((LogEvent)CustomLogEvent.GET_STATUS_FAILED, userId, errorMessage);
                    throw new ApiException(errorMessage);
                }
                String response = (String)this.getResponseBody(genericHttpResponse, true);
                verifyResponse = this.objectMapper.readValue(response, VerifyResponse.class);
            }
            VerifyResponseWrapper verifyResponseWrapper = new VerifyResponseWrapper(verifyResponse, qrCode, verificationCode, webVerificationUrl);
            String transactionStatus = verifyResponseWrapper.getTransactionStatus();
            LOGGER.log((LogEvent)CustomLogEvent.TRANSACTION_STATUS, verifyResponseWrapper.getId(), transactionStatus);
            if (TransactionStatus.NOT_REQUIRED.getValue().equals(transactionStatus)) {
                LOGGER.log(CustomLogEvent.VERIFY_DISABLED);
                throw new ApiException("PingOne Verify is disabled for user.");
            }
            return verifyResponseWrapper;
        }
        catch (IOException e) {
            String errorMessage = "Unable to read response from PingOne Verify.";
            LOGGER.log((LogEvent)CustomLogEvent.GET_STATUS_FAILED, userId, errorMessage);
            throw new ApiException(errorMessage, e);
        }
    }

    public VerifyResponseWrapper createTransaction(VerifyTransactionRequest verifyTransactionRequest) throws ApiException, InvalidValueException {
        String userId = verifyTransactionRequest.getUserId();
        LOGGER.log((LogEvent)CustomLogEvent.CREATE_TRANSACTION, userId, verifyTransactionRequest.getEmail(), verifyTransactionRequest.getPhone());
        try {
            String verifyTransactionsUrl = this.getVerifyTransactionsUrl(userId);
            JSONObject webreqObject = this.writeWebRequestBody(verifyTransactionRequest);
            GenericHttpRequest request = new GenericHttpRequest(GenericHttpMethod.POST, verifyTransactionsUrl, new GenericHttpQueryParams(), this.getHttpHeaders(), this.getHttpBody(webreqObject));
            GenericHttpResponse genericHttpResponse = this.executeRequest(request);
            int responseCode = genericHttpResponse.getStatusCode();
            if (responseCode == PingOneStatusCode.LIMIT_EXCEEDED.getStatusCode()) {
                LOGGER.log(CustomLogEvent.RATE_LIMIT_EXCEEDED);
                throw new LimitExceededException();
            }
            if (responseCode != PingOneStatusCode.CREATED.getStatusCode()) {
                String errorMessage = "Unexpected status code returned.";
                if (responseCode == PingOneStatusCode.ACCESS_FAILED.getStatusCode() || responseCode == PingOneStatusCode.BAD_REQUEST.getStatusCode()) {
                    try {
                        String message;
                        JSONObject response = (JSONObject)this.getResponseBody(genericHttpResponse, false);
                        JSONArray details = (JSONArray)response.get("details");
                        JSONObject detail = (JSONObject)details.get(0);
                        String code = (String)detail.get("code");
                        if (("INSUFFICIENT_PERMISSIONS".equals(code) || "INVALID_VALUE".equals(code)) && StringUtils.isNotBlank(message = (String)detail.get("message"))) {
                            errorMessage = message;
                        }
                        if (responseCode == PingOneStatusCode.BAD_REQUEST.getStatusCode() && "INVALID_VALUE".equals(code)) {
                            LOGGER.log((LogEvent)CustomLogEvent.CREATE_VERIFICATION_FAILED, userId, errorMessage);
                            throw new InvalidValueException(errorMessage);
                        }
                    }
                    catch (NullPointerException e) {
                        LOGGER.log(CustomLogEvent.GET_ACCESS_FAILED_MESSAGE);
                    }
                }
                LOGGER.log((LogEvent)CustomLogEvent.CREATE_VERIFICATION_FAILED, userId, errorMessage);
                throw new ApiException(errorMessage);
            }
            String response = (String)this.getResponseBody(genericHttpResponse, true);
            VerifyResponse verifyResponse = this.objectMapper.readValue(response, VerifyResponse.class);
            this.checkRequirements(verifyResponse, verifyTransactionRequest.getVerifyPolicy(), userId);
            LOGGER.log((LogEvent)CustomLogEvent.CREATED_TRANSACTION, verifyResponse.getId(), userId);
            return new VerifyResponseWrapper(verifyResponse);
        }
        catch (IOException e) {
            String errorMessage = "Unable to read response from PingOne Verify.";
            LOGGER.log((LogEvent)CustomLogEvent.CREATE_VERIFICATION_FAILED, userId, errorMessage);
            throw new ApiException(errorMessage, e);
        }
    }

    public void checkRequirements(VerifyResponse verifyResponse, String verifyPolicy, String userId) throws InvalidValueException {
        if (verifyPolicy != null) {
            return;
        }
        HashMap transactionStatus = (HashMap)verifyResponse.getTransactionStatus();
        if (transactionStatus == null) {
            return;
        }
        HashMap verificationStatus = transactionStatus.getOrDefault("verificationStatus", new HashMap());
        boolean emailRequested = "REQUESTED".equals(verificationStatus.get("EMAIL"));
        boolean phoneRequested = "REQUESTED".equals(verificationStatus.get("PHONE"));
        if (emailRequested || phoneRequested) {
            Map<String, Object> requirements = verifyResponse.getRequirements();
            boolean emailInRequirement = requirements != null && requirements.containsKey("email");
            boolean phoneInRequirement = requirements != null && requirements.containsKey("phone");
            LOGGER.log((LogEvent)CustomLogEvent.VERIFY_POLICY_TRACK, verifyPolicy, emailRequested, phoneRequested, emailInRequirement, phoneInRequirement);
            ArrayList<String> errors = new ArrayList<String>();
            if (emailRequested && !emailInRequirement) {
                errors.add("missing required email requirement");
            }
            if (phoneRequested && !phoneInRequirement) {
                errors.add("missing required phone requirement");
            }
            if (!errors.isEmpty()) {
                String errorMsg = ((Object)errors).toString();
                LOGGER.log((LogEvent)CustomLogEvent.CREATE_VERIFICATION_FAILED, userId, errorMsg);
                throw new InvalidValueException(errorMsg);
            }
        }
    }

    public JSONObject writeWebRequestBody(VerifyTransactionRequest verifyTransactionRequest) {
        JSONObject webreqObject = new JSONObject();
        String email = verifyTransactionRequest.getEmail();
        String phone = verifyTransactionRequest.getPhone();
        if (StringUtils.isNotBlank(email) || StringUtils.isNotBlank(phone)) {
            JSONObject notifObject = new JSONObject();
            if (StringUtils.isNotBlank(email)) {
                notifObject.put("email", email);
            }
            if (StringUtils.isNotBlank(phone)) {
                notifObject.put("phone", phone);
            }
            webreqObject.put("sendNotification", notifObject);
        }
        JSONObject requirementObject = new JSONObject();
        this.addValue(webreqObject, "verifyPolicy", ID, verifyTransactionRequest.getVerifyPolicy());
        this.addValue(requirementObject, "referenceSelfie", "value", verifyTransactionRequest.getSelfie());
        this.addArray(requirementObject, "email", "options", verifyTransactionRequest.getEmails());
        this.addArray(requirementObject, "phone", "options", verifyTransactionRequest.getPhones());
        Map<UiConfig, String[]> biographicFieldValues = verifyTransactionRequest.getBiographicFieldValues();
        if (biographicFieldValues != null) {
            for (Map.Entry<UiConfig, String[]> entry : biographicFieldValues.entrySet()) {
                UiConfig uiConfig = entry.getKey();
                String[] values = entry.getValue();
                String fieldName = BIOGRAPHIC_FIELD_NAME_MAP.get((Object)uiConfig);
                this.addArray(requirementObject, fieldName, "options", values);
            }
        }
        if (!requirementObject.isEmpty()) {
            webreqObject.put("requirements", requirementObject);
        }
        String redirectUrl = verifyTransactionRequest.getRedirectUrl();
        String redirectMessage = verifyTransactionRequest.getRedirectMessage();
        if (!StringUtils.isAnyBlank(redirectMessage, redirectUrl)) {
            JSONObject redirectObject = new JSONObject();
            redirectObject.put("url", redirectUrl);
            redirectObject.put("message", redirectMessage);
            webreqObject.put("redirect", redirectObject);
        }
        return webreqObject;
    }

    private void addValue(JSONObject outerObj, String outerAttr, String innerAttr, String val) {
        if (StringUtils.isNotBlank(val)) {
            JSONObject innerObj = new JSONObject();
            innerObj.put(innerAttr, val);
            outerObj.put(outerAttr, innerObj);
        }
    }

    private void addArray(JSONObject outerObj, String outerAttr, String innerAttr, String[][] vals) {
        if (vals != null && vals.length > 0) {
            JSONArray array = new JSONArray();
            Arrays.stream(vals).forEach(e -> array.add(e[0]));
            JSONObject innerObj = new JSONObject();
            innerObj.put(innerAttr, array);
            outerObj.put(outerAttr, innerObj);
        }
    }

    private void addArray(JSONObject outerObj, String outerAttr, String innerAttr, String[] vals) {
        if (vals != null && vals.length > 0) {
            JSONArray array = new JSONArray();
            array.addAll(Arrays.asList(vals));
            JSONObject innerObj = new JSONObject();
            innerObj.put(innerAttr, array);
            outerObj.put(outerAttr, innerObj);
        }
    }

    public HashMap<String, AttributeValue> getUserData(String userId, String transactionId, Map<String, String> optionalAttributes) {
        HashMap<String, AttributeValue> userData = this.getUserData(userId, transactionId, optionalAttributes, "GOVERNMENT_ID");
        HashMap<String, AttributeValue> selfie = this.getUserData(userId, transactionId, optionalAttributes, "SELFIE");
        HashMap<String, AttributeValue> metadata = this.getUserData(userId, transactionId, optionalAttributes, "metaData");
        userData.putAll(selfie);
        userData.putAll(metadata);
        return userData;
    }

    public HashMap<String, AttributeValue> getMetaData(String userId, String transactionId, Map<String, String> optionalAttributes) {
        return this.getUserData(userId, transactionId, optionalAttributes, "metaData");
    }

    public HashMap<String, AttributeValue> getUserData(String userId, String transactionId, Map<String, String> optionalAttributes, String type) {
        LOGGER.logMethodEntry();
        HashMap<String, AttributeValue> userData = new HashMap<String, AttributeValue>();
        try {
            String verifyTransactionsUrl = this.getVerifyTransactionsUrl(userId);
            if (transactionId == null) {
                throw new ApiException("transactionId was null.");
            }
            String transactionUrl = String.format(SPECIFIC_ENDPOINT_TEMPLATE, verifyTransactionsUrl, transactionId);
            String target = String.format(SPECIFIC_ENDPOINT_TEMPLATE, transactionUrl, type.equals("metaData") ? type : VERIFIED_DATA + type);
            GenericHttpResponse genericHttpResponse = this.executeGetRequest(target);
            int statusCode = genericHttpResponse.getStatusCode();
            if (statusCode == PingOneStatusCode.LIMIT_EXCEEDED.getStatusCode()) {
                LOGGER.log(CustomLogEvent.RATE_LIMIT_EXCEEDED);
                throw new LimitExceededException();
            }
            if (statusCode != PingOneStatusCode.SUCCESS.getStatusCode()) {
                throw new ApiException("Unexpected status code returned.");
            }
            String userDataResponse = (String)this.getResponseBody(genericHttpResponse, true);
            if (!userDataResponse.contains("\"size\" : 0")) {
                if (type.equals("GOVERNMENT_ID")) {
                    Map<String, AttributeValue> coreContractValues = JsonPointerUtil.mapResponse(ObjectMapperUtil.getDefault(), this.getCoreContractMapping(), userDataResponse);
                    userData.putAll(coreContractValues);
                }
            } else {
                throw new ApiException(type + " for tx " + transactionId + " was not returned as a part of the response from the Verify service.");
            }
            if (!optionalAttributes.isEmpty()) {
                Map<String, AttributeValue> optionalValues = JsonPointerUtil.mapResponse(ObjectMapperUtil.getDefault(), this.getOptionalContractMapping(optionalAttributes, type), userDataResponse);
                userData.putAll(optionalValues);
            }
            LOGGER.log((LogEvent)CustomLogEvent.GET_USER_DATA_SUCCESS, type + ": " + userData);
        }
        catch (ApiException e) {
            LOGGER.log((LogEvent)CustomLogEvent.GET_USER_DATA_FAILED, type + ": " + e.getMessage());
        }
        LOGGER.logMethodExit();
        return userData;
    }

    public JSONArray getPopulations() {
        LOGGER.log(CustomLogEvent.GET_POPULATIONS);
        String populationUrl = String.format(POPULATIONS_ENDPOINT_TEMPLATE, this.envUrl);
        JSONArray populations = null;
        try {
            GenericHttpResponse getPopulationsResponse = this.executeGetRequest(populationUrl);
            int statusCode = getPopulationsResponse.getStatusCode();
            if (statusCode == PingOneStatusCode.SUCCESS.getStatusCode()) {
                JSONObject populationResponse = (JSONObject)this.getResponseBody(getPopulationsResponse, false);
                JSONObject embedded = (JSONObject)populationResponse.get(EMBEDDED);
                populations = (JSONArray)embedded.get("populations");
            } else if (statusCode == PingOneStatusCode.LIMIT_EXCEEDED.getStatusCode()) {
                LOGGER.log(CustomLogEvent.RATE_LIMIT_EXCEEDED);
                populations = this.addLimitExceededToDropdown();
            }
        }
        catch (ApiException e) {
            LOGGER.log(CustomLogEvent.GET_POPULATIONS_ERROR);
        }
        return populations;
    }

    public List<AbstractSelectionFieldDescriptor.OptionValue> getPopulationsAsOptionValues() {
        LOGGER.log(CustomLogEvent.GET_POPULATIONS);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> options = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        options.add(SelectFieldDescriptor.SELECT_ONE);
        JSONArray populations = this.getPopulations();
        if (populations != null) {
            for (Object o : populations) {
                JSONObject population = (JSONObject)o;
                String id = (String)population.get(ID);
                String name = (String)population.get(NAME);
                if (id.equals(LIMIT_EXCEEDED_ID)) {
                    options.clear();
                }
                options.add(new AbstractSelectionFieldDescriptor.OptionValue(name, id));
            }
        }
        return options;
    }

    public JSONArray getVerifyPolicies() {
        LOGGER.log(CustomLogEvent.GET_VERIFY_POLICIES);
        String verifyPoliciesUrl = String.format(VERIFY_POLICIES_ENDPOINT_TEMPLATE, this.envUrl);
        JSONArray verifyPolicies = null;
        try {
            GenericHttpResponse getVerifyPoliciesResponse = this.executeGetRequest(verifyPoliciesUrl);
            int statusCode = getVerifyPoliciesResponse.getStatusCode();
            if (statusCode == PingOneStatusCode.SUCCESS.getStatusCode()) {
                JSONObject verifyPoliciesResponse = (JSONObject)this.getResponseBody(getVerifyPoliciesResponse, false);
                JSONObject embedded = (JSONObject)verifyPoliciesResponse.get(EMBEDDED);
                verifyPolicies = (JSONArray)embedded.get("verifyPolicies");
            } else if (statusCode == PingOneStatusCode.LIMIT_EXCEEDED.getStatusCode()) {
                LOGGER.log(CustomLogEvent.RATE_LIMIT_EXCEEDED);
                verifyPolicies = this.addLimitExceededToDropdown();
            }
        }
        catch (ApiException e) {
            LOGGER.log(CustomLogEvent.GET_VERIFY_POLICIES_ERROR);
        }
        return verifyPolicies;
    }

    public List<AbstractSelectionFieldDescriptor.OptionValue> getVerifyPoliciesAsOptionValues() {
        LOGGER.log(CustomLogEvent.GET_VERIFY_POLICIES);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> options = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        JSONArray verifyPolicies = this.getVerifyPolicies();
        if (verifyPolicies != null) {
            for (int i = 0; i < verifyPolicies.size(); ++i) {
                JSONObject verifyPolicy = (JSONObject)verifyPolicies.get(i);
                String id = (String)verifyPolicy.get(ID);
                String name = (String)verifyPolicy.get(NAME);
                if (i == 0 && !id.equals(LIMIT_EXCEEDED_ID)) {
                    name = name + " (Default)";
                }
                options.add(new AbstractSelectionFieldDescriptor.OptionValue(name, id));
            }
        }
        if (options.isEmpty()) {
            LOGGER.log(CustomLogEvent.VERIFY_POLICIES_NOT_FOUND);
            options.add(new AbstractSelectionFieldDescriptor.OptionValue("Verify Policies not found in Environment", "Verify Policies not found in Environment"));
        }
        return options;
    }

    private JSONArray addLimitExceededToDropdown() {
        JSONArray list = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put(ID, LIMIT_EXCEEDED_ID);
        obj.put(NAME, LIMIT_EXCEEDED_ID);
        list.add(obj);
        return list;
    }

    public String checkVerifyPolicy(String verifyPolicy, String[][] emails, String[][] phones, String userId) throws InvalidValueException, LimitExceededException {
        JSONArray verifyPolicies = this.getVerifyPolicies();
        if (verifyPolicies == null || verifyPolicies.isEmpty()) {
            return null;
        }
        JSONObject firstPolicy = (JSONObject)verifyPolicies.get(0);
        String policyId = (String)firstPolicy.get(ID);
        if (policyId.equals(LIMIT_EXCEEDED_ID)) {
            throw new LimitExceededException();
        }
        boolean emailRequired = false;
        boolean phoneRequired = false;
        try {
            for (Object o : verifyPolicies) {
                JSONObject policy = (JSONObject)o;
                if (!policy.get(ID).equals(verifyPolicy)) continue;
                emailRequired = ((JSONObject)policy.get("email")).get("verify").equals("REQUIRED");
                phoneRequired = ((JSONObject)policy.get("phone")).get("verify").equals("REQUIRED");
            }
        }
        catch (NullPointerException e) {
            LOGGER.log(CustomLogEvent.GET_VERIFY_POLICIES_ERROR);
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (emailRequired || phoneRequired) {
            int emailSize = this.getSize(emails);
            int phoneSize = this.getSize(phones);
            LOGGER.log((LogEvent)CustomLogEvent.VERIFY_POLICY_TRACK, verifyPolicy, emailRequired, phoneRequired, emailSize, phoneSize);
            if (emailRequired && emailSize == 0) {
                errors.add("missing required email requirement");
            }
            if (phoneRequired && phoneSize == 0) {
                errors.add("missing required phone requirement");
            }
        }
        if (!errors.isEmpty()) {
            String errorMsg = ((Object)errors).toString();
            LOGGER.log((LogEvent)CustomLogEvent.CREATE_VERIFICATION_FAILED, userId, errorMsg);
            throw new InvalidValueException(errorMsg);
        }
        return verifyPolicy;
    }

    private int getSize(String[][] array) {
        return array == null ? 0 : array.length;
    }

    private GenericHttpResponse executeGetRequest(String target) throws ApiException {
        GenericHttpRequest request = new GenericHttpRequest(GenericHttpMethod.GET, target, new GenericHttpQueryParams(), this.getHttpHeaders());
        return this.executeRequest(request);
    }

    private GenericHttpHeaders getHttpHeaders(String contentType) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", contentType);
        headerMap.put("Authorization", "Bearer " + this.token);
        return new GenericHttpHeaders(headerMap);
    }

    private GenericHttpHeaders getHttpHeaders() {
        return this.getHttpHeaders(ContentType.APPLICATION_JSON.getMimeType());
    }

    private GenericHttpBody getHttpBody(JSONObject values) {
        return new GenericHttpBody(values.toString(), ContentType.APPLICATION_JSON.getMimeType(), ContentType.APPLICATION_JSON.getCharset().toString());
    }

    private Map<String, String> getCoreContractMapping() {
        Map<String, String> coreContractMapping = Arrays.stream(CoreContract.values()).collect(Collectors.toMap(CoreContract::getValue, CoreContract::getPointer));
        return coreContractMapping.entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, String> getOptionalContractMapping(Map<String, String> optionalAttributes, String type) {
        String jsonPointer;
        if (type.equals("SELFIE")) {
            jsonPointer = JSON_POINTER_SELFIE;
        } else if (type.equals("metaData")) {
            jsonPointer = JSON_POINTER_METADATA;
        } else {
            return optionalAttributes;
        }
        return optionalAttributes.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(jsonPointer)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

