/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.api;

import com.pingidentity.adapters.pingone.verify.CustomLogEvent;
import com.pingidentity.adapters.pingone.verify.api.PingOneClient;
import com.pingidentity.adapters.pingone.verify.api.model.TokenResponse;
import com.pingidentity.adapters.pingone.verify.exception.ApiException;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpQueryParams;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.HttpService;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.commons.codec.binary.Base64;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.adapters.pingone.verify.shade.org.json.simple.JSONObject;
import com.pingidentity.adapters.pingone.verify.shade.org.json.simple.parser.JSONParser;
import com.pingidentity.adapters.pingone.verify.shade.org.json.simple.parser.ParseException;
import com.pingidentity.adapters.pingone.verify.util.ObjectMapperUtil;
import java.io.IOException;
import java.util.HashMap;

public class AuthClient
extends PingOneClient {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(AuthClient.class);
    private static final String BASIC_AUTH_CRED_FORMAT = "%s:%s";
    private static final String BASIC_AUTH_HEADER_FORMAT = "Basic %s";
    public static final String TOKEN_ENDPOINT = "/as/token";
    private static final String TOKEN_ENDPOINT_TEMPLATE = "%s/%s/as/token";
    private static final String ERROR_MSG_FORMAT = "%s - %s";
    private final String tokenEndpointUrl;
    private final String basicAuthHeaderValue;
    private static final JSONParser parser = new JSONParser();

    public AuthClient(HttpService httpService, String authPath, String envId, String clientId, String clientSecret) {
        super(httpService);
        this.tokenEndpointUrl = String.format(TOKEN_ENDPOINT_TEMPLATE, authPath, envId);
        String basicAuthCred = String.format(BASIC_AUTH_CRED_FORMAT, clientId, clientSecret);
        String encodedBasicAuthCred = Base64.encodeBase64String(basicAuthCred.getBytes());
        this.basicAuthHeaderValue = String.format(BASIC_AUTH_HEADER_FORMAT, encodedBasicAuthCred);
    }

    public String postTokenRequest() throws ApiException {
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
            header.put("Accept", "*/*");
            header.put("Authorization", this.basicAuthHeaderValue);
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("grant_type", "client_credentials");
            GenericHttpRequest request = new GenericHttpRequest(GenericHttpMethod.POST, this.tokenEndpointUrl, new GenericHttpQueryParams(), new GenericHttpHeaders(header), AuthClient.getBody(body));
            GenericHttpResponse genericHttpResponse = this.executeRequest(request);
            String response = (String)this.getResponseBody(genericHttpResponse, true);
            JSONObject jsonObj = (JSONObject)parser.parse(response);
            Object error = jsonObj.get("error");
            if (error != null) {
                String errorDesc = (String)jsonObj.get("error_description");
                String errorMsg = String.format(ERROR_MSG_FORMAT, error.toString(), errorDesc);
                LOGGER.log((LogEvent)CustomLogEvent.ACCESS_TOKEN_ERROR, errorMsg);
                throw new ApiException("Error getting access token: " + error.toString());
            }
            TokenResponse tokenResponse = ObjectMapperUtil.getDefault().readValue(response, TokenResponse.class);
            return tokenResponse.getAccessToken();
        }
        catch (ParseException | IOException e) {
            String errorMsg = String.format(ERROR_MSG_FORMAT, "access_token_error", "Unable to read PingOne response");
            LOGGER.log((LogEvent)CustomLogEvent.ACCESS_TOKEN_ERROR, errorMsg);
            throw new ApiException("Error getting access token: " + errorMsg, e);
        }
    }
}

