/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.api;

import com.pingidentity.adapters.pingone.verify.CustomLogEvent;
import com.pingidentity.adapters.pingone.verify.exception.ApiException;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.HttpService;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.HttpServiceException;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.adapters.pingone.verify.shade.org.json.simple.parser.JSONParser;
import com.pingidentity.adapters.pingone.verify.shade.org.json.simple.parser.ParseException;
import java.util.Map;

public abstract class PingOneClient {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(PingOneClient.class);
    private static final JSONParser parser = new JSONParser();
    HttpService httpService;

    public PingOneClient(HttpService httpService) {
        this.httpService = httpService;
    }

    protected static GenericHttpBody getBody(Map<String, String> values) {
        StringBuilder contentBuilder = null;
        for (Map.Entry<String, String> entry : values.entrySet()) {
            if (contentBuilder == null) {
                contentBuilder = new StringBuilder(entry.getKey() + "=" + entry.getValue());
                continue;
            }
            String value = "&" + entry.getKey() + "=" + entry.getValue();
            contentBuilder.append(value);
        }
        String content = contentBuilder == null ? null : contentBuilder.toString();
        return new GenericHttpBody(content, ContentType.APPLICATION_FORM_URLENCODED.getMimeType(), ContentType.APPLICATION_FORM_URLENCODED.getCharset().toString());
    }

    protected GenericHttpResponse executeRequest(GenericHttpRequest request) throws ApiException {
        GenericHttpResponse genericHttpResponse;
        try {
            genericHttpResponse = this.httpService.execute(request);
        }
        catch (HttpServiceException e) {
            LOGGER.log(CustomLogEvent.HTTP_EXECUTE_ERROR);
            throw new ApiException("Unable to execute request", e);
        }
        LOGGER.log((LogEvent)CustomLogEvent.HTTP_RESPONSE_CODE, genericHttpResponse.getStatusCode());
        return genericHttpResponse;
    }

    public Object getResponseBody(GenericHttpResponse genericHttpResponse, boolean stringResp) throws ApiException {
        try {
            String responseString = genericHttpResponse.getBody().getContent();
            if (stringResp) {
                return responseString;
            }
            return parser.parse(responseString);
        }
        catch (ParseException e) {
            LOGGER.log(CustomLogEvent.READ_RESPONSE_ERROR);
            throw new ApiException("Unable to read response", e);
        }
    }
}

