/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.api.model;

import com.pingidentity.adapters.pingone.verify.CustomLogEvent;
import com.pingidentity.adapters.pingone.verify.api.model.CustomAuthnErrorDetail;
import com.pingidentity.adapters.pingone.verify.api.model.TransactionStatus;
import com.pingidentity.adapters.pingone.verify.api.model.VerifyResponse;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.verify.util.ObjectMapperUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VerifyResponseWrapper {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(VerifyResponseWrapper.class);
    private static final String MESSAGES = "messages";
    private static final String PROVIDER_ID = "providerId";
    private static final String ID_VALIDATION = "ID_VALIDATION";
    public static final List<String> VALIDATION_ERROR_CODES = Arrays.asList("102", "110", "111", "112", "113", "118", "119");
    public static final String VALIDATION_ERROR_MESSAGE_KEY_SUFFIX = "validation.error";
    public static final String SERVER_ERROR_MESSAGE_KEY_SUFFIX = "server.error";
    public static final String THIRD_PARTY_ERROR_MESSAGE_KEY_SUFFIX = "third.party";
    public static final String LIMIT_EXCEEDED_ERROR_MESSAGE_KEY_SUFFIX = "limit.exceeded";
    private final String id;
    private final String transactionStatus;
    private List<LinkedHashMap<String, Object>> errorMessage;
    private String errJson = null;
    private final String qrUrl;
    private final String verificationCode;
    private final String verifiedDocuments;
    private final String webVerificationUrl;
    private final String webVerificationCode;

    public VerifyResponseWrapper(String id, String transactionStatus) {
        this.id = id;
        this.transactionStatus = transactionStatus;
        this.qrUrl = null;
        this.verificationCode = null;
        this.verifiedDocuments = null;
        this.webVerificationUrl = null;
        this.webVerificationCode = null;
    }

    public VerifyResponseWrapper(VerifyResponse verifyResponse, String qrCode, String verificationCode, String webVerificationUrl) {
        this.id = verifyResponse.getId();
        Object transactionStatus = verifyResponse.getTransactionStatus();
        if (transactionStatus == null) {
            this.transactionStatus = null;
            this.errorMessage = null;
        } else {
            LinkedHashMap map = (LinkedHashMap)transactionStatus;
            this.transactionStatus = (String)map.get("status");
            if (TransactionStatus.DELETED.getValue().equals(this.transactionStatus)) {
                this.setSingleErrorMessage("deleted", "");
            } else {
                this.errorMessage = (List)map.get("providerMessagesList");
                if (this.errorMessage != null) {
                    try {
                        this.errJson = ObjectMapperUtil.getDefault().writeValueAsString(this.errorMessage);
                    }
                    catch (Exception e) {
                        LOGGER.log((LogEvent)CustomLogEvent.SERIALIZATION_ERROR, "providerMessagesList");
                    }
                }
            }
        }
        this.qrUrl = qrCode;
        this.verificationCode = verificationCode;
        this.webVerificationUrl = webVerificationUrl;
        this.verifiedDocuments = verifyResponse.getVerifiedDocuments();
        this.webVerificationCode = verifyResponse.getWebVerificationCode();
    }

    public VerifyResponseWrapper(VerifyResponse verifyResponse) {
        this(verifyResponse, verifyResponse.getQrUrl(), verifyResponse.getWebVerificationCode(), verifyResponse.getWebVerificationUrl());
    }

    public String getId() {
        return this.id;
    }

    public String getTransactionStatus() {
        return this.transactionStatus;
    }

    public List<LinkedHashMap<String, Object>> getErrorMessage() {
        return this.errorMessage;
    }

    public List<? extends Serializable> getErrorMessage(boolean returnErrorMessageKeySuffix) {
        if (this.errorMessage == null) {
            return null;
        }
        if (returnErrorMessageKeySuffix) {
            ArrayList<String> listOfErrors = new ArrayList<String>();
            for (LinkedHashMap<String, Object> object : this.errorMessage) {
                String provider = (String)object.get(PROVIDER_ID);
                if (ID_VALIDATION.equals(provider)) {
                    LinkedHashMap messages = (LinkedHashMap)object.get(MESSAGES);
                    for (String key : messages.keySet()) {
                        listOfErrors.add(this.getMessageKeySuffix(key));
                    }
                    continue;
                }
                listOfErrors.add(THIRD_PARTY_ERROR_MESSAGE_KEY_SUFFIX);
            }
            return listOfErrors;
        }
        ArrayList<CustomAuthnErrorDetail> listOfErrors = new ArrayList<CustomAuthnErrorDetail>();
        for (LinkedHashMap<String, Object> object : this.errorMessage) {
            String provider = (String)object.get(PROVIDER_ID);
            LinkedHashMap messages = (LinkedHashMap)object.get(MESSAGES);
            for (Map.Entry entry : messages.entrySet()) {
                String key = (String)entry.getKey();
                String code = "PINGONE_VERIFY_ERROR_" + this.toUpperCaseWithUnderscore(key);
                String userMessage = ID_VALIDATION.equals(provider) ? this.getMessageKeySuffix(key) : this.getMessageKeySuffix(THIRD_PARTY_ERROR_MESSAGE_KEY_SUFFIX);
                CustomAuthnErrorDetail errorDetail = new CustomAuthnErrorDetail.Builder().setCode(code).setMessage((String)entry.getValue()).setUserMessage(userMessage).setProviderId(provider).build();
                listOfErrors.add(errorDetail);
            }
        }
        return listOfErrors;
    }

    public String getErrJson() {
        return this.errJson;
    }

    public void setErrJson(String errJson) {
        this.errJson = errJson;
    }

    public String getQrUrl() {
        return this.qrUrl;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public String getVerifiedDocuments() {
        return this.verifiedDocuments;
    }

    public String getWebVerificationUrl() {
        return this.webVerificationUrl;
    }

    public String getWebVerificationCode() {
        return this.webVerificationCode;
    }

    public void setErrorMessage(List<LinkedHashMap<String, Object>> errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setSingleErrorMessage(String key, String value) {
        ArrayList<LinkedHashMap<String, Object>> providerMessagesList = new ArrayList<LinkedHashMap<String, Object>>();
        LinkedHashMap<String, Object> providerMessage = new LinkedHashMap<String, Object>();
        providerMessage.put(PROVIDER_ID, ID_VALIDATION);
        LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
        message.put(key, value);
        providerMessage.put(MESSAGES, message);
        providerMessagesList.add(providerMessage);
        this.errorMessage = providerMessagesList;
    }

    public void setLimitExceededErrorMessage() {
        this.setSingleErrorMessage(LIMIT_EXCEEDED_ERROR_MESSAGE_KEY_SUFFIX, "");
    }

    private String getMessageKeySuffix(String key) {
        if (!StringUtils.isNumeric(key)) {
            return key;
        }
        if (VALIDATION_ERROR_CODES.contains(key)) {
            return VALIDATION_ERROR_MESSAGE_KEY_SUFFIX;
        }
        return SERVER_ERROR_MESSAGE_KEY_SUFFIX;
    }

    private String toUpperCaseWithUnderscore(String key) {
        if (!StringUtils.isNumeric(key)) {
            key = key.toUpperCase();
            key = key.replace(".", "_");
        }
        return key;
    }
}

