/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.util;

import com.pingidentity.adapters.pingone.verify.shade.com.fasterxml.jackson.databind.JsonNode;
import com.pingidentity.adapters.pingone.verify.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import com.pingidentity.adapters.pingone.verify.shade.com.fasterxml.jackson.databind.node.BinaryNode;
import com.pingidentity.adapters.pingone.verify.shade.com.fasterxml.jackson.databind.node.MissingNode;
import com.pingidentity.adapters.pingone.verify.shade.com.fasterxml.jackson.databind.node.NullNode;
import com.pingidentity.adapters.pingone.verify.shade.com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class JsonNodeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JsonNodeUtil.class);

    public static AttributeValue convert(JsonNode jsonNode) {
        AttributeValue attributeValue = null;
        if (jsonNode != null) {
            if (jsonNode instanceof MissingNode || jsonNode instanceof NullNode) {
                return null;
            }
            if (jsonNode instanceof ArrayNode) {
                Iterator<JsonNode> jsonNodes = jsonNode.elements();
                ArrayList resultObjectList = new ArrayList();
                jsonNodes.forEachRemaining(node -> resultObjectList.add(node.toString()));
                attributeValue = AttrValueSupport.make(resultObjectList, (boolean)false);
            } else {
                attributeValue = jsonNode instanceof TextNode ? AttrValueSupport.make((Object)jsonNode.textValue()) : (jsonNode instanceof BinaryNode ? AttrValueSupport.make((Object)jsonNode.asText()) : AttrValueSupport.make((Object)jsonNode.toString()));
            }
            if (attributeValue.isMultiValue()) {
                LOG.debug("Converted attribute values: " + attributeValue.getValues());
            } else {
                LOG.debug("Converted attribute value: " + attributeValue.getValue());
            }
        }
        return attributeValue;
    }
}

